/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JLabel;

public class VerticalLabel
extends JLabel {
    public static final int ROTATE_RIGHT = 1;
    public static final int DONT_ROTATE = 0;
    public static final int ROTATE_LEFT = -1;
    private int rotation = 0;
    private boolean painting = false;

    public VerticalLabel() {
    }

    public VerticalLabel(Icon icon) {
        super(icon);
    }

    public VerticalLabel(String text) {
        super(text);
    }

    public VerticalLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    public VerticalLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    public VerticalLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public boolean isRotated() {
        return this.rotation != 0;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform oldAt = g2d.getTransform();
        if (this.isRotated()) {
            g2d.rotate(Math.toRadians(90 * this.rotation), this.getLocation().x, this.getLocation().y);
            g2d.translate(-this.getWidth() / 2, 0);
        }
        if (this.isRotated()) {
            this.setSize(this.getHeight(), this.getWidth());
        }
        this.painting = true;
        super.paint(g2d);
        this.painting = false;
        g2d.setTransform(oldAt);
    }

    @Override
    public Insets getInsets(Insets insets) {
        insets = super.getInsets(insets);
        if (this.painting) {
            if (this.rotation == -1) {
                int temp = insets.bottom;
                insets.bottom = insets.left;
                insets.left = insets.top;
                insets.top = insets.right;
                insets.right = temp;
            } else if (this.rotation == 1) {
                int temp = insets.bottom;
                insets.bottom = insets.right;
                insets.right = insets.top;
                insets.top = insets.left;
                insets.left = temp;
            }
        }
        return insets;
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.painting) {
            if (this.rotation == -1) {
                int temp = insets.bottom;
                insets.bottom = insets.left;
                insets.left = insets.top;
                insets.top = insets.right;
                insets.right = temp;
            } else if (this.rotation == 1) {
                int temp = insets.bottom;
                insets.bottom = insets.right;
                insets.right = insets.top;
                insets.top = insets.left;
                insets.left = temp;
            }
        }
        return insets;
    }

    @Override
    public int getWidth() {
        if (this.painting && this.isRotated()) {
            return super.getHeight();
        }
        return super.getWidth();
    }

    @Override
    public int getHeight() {
        if (this.painting && this.isRotated()) {
            return super.getWidth();
        }
        return super.getHeight();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.isRotated()) {
            int width = d.width;
            d.width = d.height;
            d.height = width;
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (this.isRotated()) {
            int width = d.width;
            d.width = d.height;
            d.height = width;
        }
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        if (this.isRotated()) {
            int width = d.width;
            d.width = d.height;
            d.height = width;
        }
        return d;
    }
}

