/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.AxeH;
import fr.dbe.graphique.AxeV;
import fr.dbe.graphique.Fond;
import fr.dbe.graphique.IPositionAxe;
import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.PointCourbe;
import fr.dbe.graphique.PointGraphique;
import fr.dbe.graphique.PositionAxeH;
import fr.dbe.graphique.PositionAxeV;
import fr.dbe.graphique.Quadrillage;
import fr.dbe.graphique.QuadrillageH;
import fr.dbe.graphique.QuadrillageV;
import fr.dbe.graphique.Repartition;
import fr.dbe.graphique.Sens;
import fr.dbe.graphique.Serie;
import fr.dbe.graphique.pixeltransformer.DirectHPixelTransformer;
import fr.dbe.graphique.pixeltransformer.DirectVPixelTransformer;
import fr.dbe.graphique.pixeltransformer.IndirectHPixelTransformer;
import fr.dbe.graphique.pixeltransformer.IndirectVPixelTransformer;
import fr.dbe.graphique.pixeltransformer.PixelTransformeFacade2D;
import fr.dbe.graphique.pixeltransformer.PixelTransformer;
import fr.dbe.util.commun.Bornes;
import fr.dbe.util.commun.IElementListener;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.log.Level;
import fr.dbe.util.log.Log;
import fr.dbe.util.xml.IXmlElement;
import fr.dbe.util.xml.XmlUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Repere
implements IXmlElement {
    private static final String DOM_POSITION_H = "posH";
    private static final String DOM_POSITION_V = "posV";
    private final Rectangle fDrawingRectangle;
    protected AxeH fAxeH;
    protected AxeV fAxeV;
    protected QuadrillageH fQuadrillageH;
    protected QuadrillageV fQuadrillageV;
    protected List<Serie> fSeries;
    protected List<Fond> fFonds;
    protected PositionAxeH fPosAxeH;
    protected PositionAxeV fPosAxeV;
    protected JDessinGraphique fDessin;
    private int fPasAffichage = 1;
    private Rectangle fClipSeries;

    public Repere(JDessinGraphique pDessin) {
        this.fDessin = pDessin;
        this.fDrawingRectangle = new Rectangle();
        this.fAxeH = new AxeH(pDessin, this);
        this.fAxeV = new AxeV(pDessin, this);
        this.fQuadrillageH = new QuadrillageH();
        this.fQuadrillageH.setVisible(true);
        this.fQuadrillageH.setNombre(5);
        this.fQuadrillageV = new QuadrillageV();
        this.fQuadrillageV.setVisible(true);
        this.fQuadrillageV.setNombre(5);
        this.fPosAxeH = PositionAxeH.BAS;
        this.fPosAxeV = PositionAxeV.GAUCHE;
        this.fSeries = new ArrayList<Serie>();
        this.fFonds = new ArrayList<Fond>();
    }

    public double getValPosAxeH() {
        double posAxeH = 0.0;
        if (this.fPosAxeH.equals(PositionAxeH.HAUT)) {
            posAxeH = this.fAxeV.getSens().equals((Object)Sens.DIRECT) ? this.fAxeV.getMax() : this.fAxeV.getMin();
        } else if (this.fPosAxeH.equals(PositionAxeH.ORIGINE)) {
            posAxeH = 0.0;
        } else if (this.fPosAxeH.equals(PositionAxeH.BAS)) {
            posAxeH = this.fAxeV.getSens().equals((Object)Sens.DIRECT) ? this.fAxeV.getMin() : this.fAxeV.getMax();
        }
        return posAxeH;
    }

    public double getValPosAxeV() {
        double posAxeV = 0.0;
        if (this.fPosAxeV.equals(PositionAxeV.GAUCHE)) {
            posAxeV = this.fAxeH.getSens().equals((Object)Sens.DIRECT) ? this.fAxeH.getMin() : this.fAxeH.getMax();
        } else if (this.fPosAxeV.equals(PositionAxeV.ORIGINE)) {
            posAxeV = 0.0;
        } else if (this.fPosAxeV.equals(PositionAxeV.DROITE)) {
            posAxeV = this.fAxeH.getSens().equals((Object)Sens.DIRECT) ? this.fAxeH.getMax() : this.fAxeH.getMin();
        }
        return posAxeV;
    }

    public void dessineQuadrillage(Graphics2D pGraphics) {
        Rectangle clip = pGraphics.getClipBounds();
        if (this.fQuadrillageH.getRepartition() == Repartition.LIE) {
            pGraphics.setClip(new Rectangle());
            this.fAxeH.getGraduation().dessine(pGraphics);
            this.fQuadrillageH.setPositions(this.fAxeH.getGraduation().getLastDrawingPositions());
            pGraphics.setClip(this.fClipSeries);
            this.fQuadrillageH.dessine((Graphics)pGraphics, (Axe)this.fAxeH, this.getValPosAxeH());
            this.fQuadrillageH.linkToGraduation();
        } else {
            pGraphics.setClip(this.fClipSeries);
            this.fQuadrillageH.dessine((Graphics)pGraphics, (Axe)this.fAxeH, this.getValPosAxeH());
        }
        if (this.fQuadrillageV.getRepartition() == Repartition.LIE) {
            pGraphics.setClip(new Rectangle());
            this.fAxeV.getGraduation().dessine(pGraphics);
            this.fQuadrillageV.setPositions(this.fAxeV.getGraduation().getLastDrawingPositions());
            pGraphics.setClip(this.fClipSeries);
            this.fQuadrillageV.dessine((Graphics)pGraphics, (Axe)this.fAxeV, this.getValPosAxeH());
            this.fQuadrillageV.linkToGraduation();
        } else {
            pGraphics.setClip(this.fClipSeries);
            this.fQuadrillageV.dessine((Graphics)pGraphics, (Axe)this.fAxeV, this.getValPosAxeV());
        }
        pGraphics.setClip(clip);
    }

    public void dessineAxes(Graphics2D pGraphics) {
        int posAxeH = 0;
        switch (this.fPosAxeH) {
            case HAUT: {
                posAxeH = this.fAxeV.getSens() == Sens.DIRECT ? (int)this.fAxeV.fPixelTransformer.val2Pix(this.fAxeV.getMax()) : (int)this.fAxeV.fPixelTransformer.val2Pix(this.fAxeV.getMin());
                posAxeH = (int)Math.max((double)posAxeH, this.fDessin.getMargesAxe().getHaut());
                break;
            }
            case ORIGINE: {
                posAxeH = (int)this.fAxeV.valToPix(0.0);
                break;
            }
            case BAS: {
                posAxeH = (int)((double)this.fDessin.getHeight() - this.fDessin.getMargesAxe().getBas());
            }
        }
        int posAxeV = 0;
        switch (this.fPosAxeV) {
            case GAUCHE: {
                posAxeV = (int)this.fDessin.getMargesAxe().getGauche();
                break;
            }
            case ORIGINE: {
                posAxeV = (int)this.fAxeH.valToPix(0.0);
                break;
            }
            case DROITE: {
                posAxeV = this.fAxeH.getSens() == Sens.DIRECT ? (int)this.fAxeH.fPixelTransformer.val2Pix(this.fAxeH.getMax()) : (int)this.fAxeH.fPixelTransformer.val2Pix(this.fAxeH.getMin());
                posAxeV = (int)Math.min((double)posAxeV, (double)this.fDessin.getWidth() - this.fDessin.getMargesAxe().getDroite());
            }
        }
        this.fAxeH.setPosition(posAxeH);
        this.fAxeV.setPosition(posAxeV);
        this.fAxeH.dessine(pGraphics);
        this.fAxeV.dessine(pGraphics);
    }

    public void dessineSeries(Graphics2D pGraphics) {
        Rectangle clip = pGraphics.getClipBounds();
        pGraphics.setClip(this.fClipSeries);
        double min = this.fAxeH.pixToVal((int)this.fDrawingRectangle.getMinX());
        double max = this.fAxeH.pixToVal((int)this.fDrawingRectangle.getMaxX());
        try {
            for (Serie s : this.fSeries) {
                if (!s.isVisible()) continue;
                s.dessine(pGraphics, Math.min(min, max), Math.max(min, max), this.fPasAffichage);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        pGraphics.setClip(clip);
    }

    public void dessineFonds(Graphics2D pGraphics) {
        Rectangle clip = pGraphics.getClipBounds();
        pGraphics.setClip(this.fClipSeries);
        for (Fond fond : this.fFonds) {
            fond.dessine(pGraphics, this);
        }
        pGraphics.setClip(clip);
    }

    public Axe getAxeH() {
        return this.fAxeH;
    }

    public void setAxeH(AxeH pAxeH) {
        this.fAxeH = pAxeH;
    }

    public Axe getAxeV() {
        return this.fAxeV;
    }

    public void setAxeV(AxeV pAxeV) {
        this.fAxeV = pAxeV;
    }

    public void setPositionAxes(PositionAxeH pPositionH, PositionAxeV pPositionV) {
        this.fPosAxeH = pPositionH;
        if (this.fPosAxeH == PositionAxeH.ORIGINE) {
            this.fAxeV.setBorneMaxAutorisee(0.0);
            this.fAxeV.setBorneMinAutorisee(0.0);
        } else {
            this.fAxeV.setBorneMaxAutorisee(null);
            this.fAxeV.setBorneMinAutorisee(null);
        }
        this.fPosAxeV = pPositionV;
        if (this.fPosAxeV == PositionAxeV.ORIGINE) {
            this.fAxeH.setBorneMaxAutorisee(0.0);
            this.fAxeH.setBorneMinAutorisee(0.0);
        } else {
            this.fAxeH.setBorneMaxAutorisee(null);
            this.fAxeH.setBorneMinAutorisee(null);
        }
    }

    public void setBornes(double xMin, double xMax, double yMin, double yMax) {
        this.fAxeH.setBornes(xMin, xMax);
        this.fAxeV.setBornes(yMin, yMax);
    }

    public void setBornesX(double xMin, double xMax) {
        this.fAxeH.setBornes(xMin, xMax);
    }

    public void setBornesY(double yMin, double yMax) {
        this.fAxeV.setBornes(yMin, yMax);
    }

    public Element getDomElement(Document doc) {
        Element root = doc.createElement(MapXmlGraph.getInstance().getNomElement((IXmlElement)this));
        root.setAttribute(DOM_POSITION_H, String.valueOf(this.fPosAxeH.ordinal()));
        root.setAttribute(DOM_POSITION_V, String.valueOf(this.fPosAxeV.ordinal()));
        root.appendChild(this.fAxeH.getDomElement(doc));
        root.appendChild(this.fAxeV.getDomElement(doc));
        root.appendChild(this.fQuadrillageH.getDomElement(doc));
        root.appendChild(this.fQuadrillageV.getDomElement(doc));
        for (Serie s : this.fSeries) {
            root.appendChild(s.getDomElement(doc));
        }
        return root;
    }

    public void setProperties(Node pNoeud) {
        this.fPosAxeH = PositionAxeH.values()[XmlUtils.getAttributeIntValue((Node)pNoeud, (String)DOM_POSITION_H, (int)1)];
        this.fPosAxeV = PositionAxeV.values()[XmlUtils.getAttributeIntValue((Node)pNoeud, (String)DOM_POSITION_V, (int)1)];
        Node n = XmlUtils.getFils((Node)pNoeud, (String)MapXmlGraph.getInstance().getNomElement((IXmlElement)this.fAxeH));
        if (n != null) {
            this.fAxeH.setProperties(n);
        } else {
            Log.getInstance().warn(Messages.getString("Repere.2") + MapXmlGraph.getInstance().getNomElement((IXmlElement)this.fAxeH) + Messages.getString("Repere.3"));
        }
        n = XmlUtils.getFils((Node)pNoeud, (String)MapXmlGraph.getInstance().getNomElement((IXmlElement)this.fAxeV));
        if (n != null) {
            this.fAxeV.setProperties(n);
        } else {
            Log.getInstance().log(Level.WARN, Messages.getString("Repere.4") + MapXmlGraph.getInstance().getNomElement((IXmlElement)this.fAxeV) + Messages.getString("Repere.5"));
        }
        n = XmlUtils.getFils((Node)pNoeud, (String)MapXmlGraph.getInstance().getNomElement((IXmlElement)this.fQuadrillageH));
        if (n != null) {
            this.fQuadrillageH.setProperties(n);
        } else {
            Log.getInstance().log(Level.WARN, Messages.getString("Repere.6") + MapXmlGraph.getInstance().getNomElement((IXmlElement)this.fQuadrillageH) + Messages.getString("Repere.7"));
        }
        n = XmlUtils.getFils((Node)pNoeud, (String)MapXmlGraph.getInstance().getNomElement((IXmlElement)this.fQuadrillageV));
        if (n != null) {
            this.fQuadrillageV.setProperties(n);
        } else {
            Log.getInstance().log(Level.WARN, Messages.getString("Repere.8") + MapXmlGraph.getInstance().getNomElement((IXmlElement)this.fQuadrillageV) + Messages.getString("Repere.9"));
        }
        n = XmlUtils.getFils((Node)pNoeud, (String)MapXmlGraph.getInstance().getNomElement(Serie.class));
        while (n != null) {
            for (Serie s : this.fSeries) {
                if (!s.getNom().equalsIgnoreCase(XmlUtils.getAttributeStringValue((Node)n, (String)"nom", (String)""))) continue;
                s.setProperties(n);
                break;
            }
            n = XmlUtils.getFrereSuivant((Node)n, (String)MapXmlGraph.getInstance().getNomElement(Serie.class));
        }
    }

    public void ajusterPlageCourante() {
        Bornes bornesY = null;
        double xMin = this.fAxeH.pixToVal((int)this.fDrawingRectangle.getMinX());
        double xMax = this.fAxeH.pixToVal((int)this.fDrawingRectangle.getMaxX());
        for (Serie s : this.fSeries) {
            Bornes b;
            if (!s.isVisible() || !s.isActive() || (b = s.bornesY(Math.min(xMin, xMax), Math.max(xMin, xMax))) == null) continue;
            if (bornesY != null) {
                bornesY = bornesY.union(b);
                continue;
            }
            bornesY = b;
        }
        if (bornesY == null) {
            return;
        }
        double yMin = bornesY.getMin();
        double yMax = bornesY.getMax();
        yMax = yMin + (yMax - yMin) * 100.0 / (double)this.fDessin.getTauxAjustementV();
        this.setBornesY(yMin, yMax);
    }

    public boolean ajusterY() {
        double yMin = Double.POSITIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        for (Serie s : this.fSeries) {
            if (!s.isActive()) continue;
            yMin = Math.min(s.getYMin(), yMin);
            yMax = Math.max(s.getYMax(), yMax);
        }
        yMax = yMin + (yMax - yMin) * 100.0 / (double)this.fDessin.getTauxAjustementV();
        if (yMin == Double.POSITIVE_INFINITY || yMax == Double.NEGATIVE_INFINITY) {
            yMin = -1.0;
            yMax = 1.0;
        }
        if (yMin != this.fAxeV.getMin() || yMax != this.fAxeV.getMax()) {
            this.fAxeV.setBornes(yMin, yMax);
            return true;
        }
        return false;
    }

    public boolean ajusterY(double pYMin, double pYMax) {
        if ((pYMax = pYMin + (pYMax - pYMin) * 100.0 / (double)this.fDessin.getTauxAjustementV()) > this.fAxeV.getMax() || pYMin < this.fAxeV.getMin()) {
            double yMax = Math.max(this.fAxeV.getMax(), pYMax);
            double yMin = Math.min(this.fAxeV.getMin(), pYMin);
            if (yMin != this.fAxeV.getMin() || yMax != this.fAxeV.getMax()) {
                this.fAxeV.setBornes(yMin, yMax);
                return true;
            }
        }
        return false;
    }

    public void ajuster(int pIndice, double pValY) {
        this.ajusterY(pValY, pValY);
        if (this.fAxeH.getMax() < (double)pIndice) {
            this.setBornesX(this.fAxeH.getMin(), pIndice * 2);
        }
    }

    public void razMinMax() {
        for (Serie s : this.fSeries) {
            s.razMinMax();
        }
    }

    public void ajouterSerie(Serie c) {
        c.setRepere(this);
        this.fSeries.add(c);
    }

    public void insererSerie(Serie c) {
        c.setRepere(this);
        this.fSeries.add(0, c);
    }

    public void ajouterSeries(List<Serie> series) {
        for (Serie c : series) {
            c.setRepere(this);
            this.fSeries.add(c);
        }
    }

    public void supprimerSerie(Serie c) {
        if (c == null) {
            return;
        }
        this.fSeries.remove(c);
    }

    public PointCourbe convertir(Point p) {
        return new PointCourbe(this.fAxeH.pixToVal((int)p.getX()), this.fAxeV.pixToVal((int)p.getY()));
    }

    public Point convertir(PointGraphique p) {
        return new Point((int)this.fAxeH.valToPix(p.getX()), (int)this.fAxeV.valToPix(p.getY()));
    }

    public void effacerSeries() {
        for (Serie s : this.fSeries) {
            s.clear();
        }
    }

    public void supprimerSeries() {
        this.fSeries.clear();
    }

    public void saveValeursSeries(String pNomFic) throws IOException {
        if (this.fSeries == null || this.fSeries.isEmpty()) {
            return;
        }
        if (!((String)pNomFic).toLowerCase().endsWith(".txt")) {
            pNomFic = (String)pNomFic + ".txt";
        }
        StringWriter sw = new StringWriter(10000);
        PrintWriter pw = new PrintWriter(sw);
        int nb = 0;
        pw.print(this.fAxeH.getEtiquette());
        for (Serie s : this.fSeries) {
            pw.print(";" + s.getNom());
            nb = Math.max(nb, s.size());
        }
        pw.println();
        for (int i = 0; i < nb; ++i) {
            pw.print(this.fSeries.get(0).getX(i));
            for (Serie s : this.fSeries) {
                double val = i < s.size() ? s.getY(i) : 0.0;
                pw.print((";" + val).replace('.', ','));
            }
            pw.println();
        }
        pw.flush();
        Utilitaire.saveEncode((String)pNomFic, (String)sw.toString(), (String)"UTF-8");
        pw.close();
    }

    public List<Serie> getSeries() {
        return this.fSeries;
    }

    public double getYMax() {
        double max = Double.MIN_VALUE;
        for (Serie serie : this.fSeries) {
            max = Math.max(max, serie.getYMax());
        }
        return max;
    }

    public double getYMin() {
        double min = Double.POSITIVE_INFINITY;
        try {
            for (Serie serie : this.fSeries) {
                min = Math.min(min, serie.getYMin());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return min;
    }

    public void setVisible(boolean pVisible) {
        this.fAxeH.setVisible(pVisible);
        this.fAxeV.setVisible(pVisible);
        this.fQuadrillageH.setVisible(pVisible);
        this.fQuadrillageV.setVisible(pVisible);
    }

    public Quadrillage getQuadrillageH() {
        return this.fQuadrillageH;
    }

    public Quadrillage getQuadrillageV() {
        return this.fQuadrillageV;
    }

    public IPositionAxe getPosAxeH() {
        return this.fPosAxeH;
    }

    public void setPosAxeH(PositionAxeH pPosAxeH) {
        this.fPosAxeH = pPosAxeH;
    }

    public IPositionAxe getPosAxeV() {
        return this.fPosAxeV;
    }

    public void setPosAxeV(PositionAxeV pPosAxeV) {
        this.fPosAxeV = pPosAxeV;
    }

    public int getPasAffichage() {
        return this.fPasAffichage;
    }

    public void setPasAffichage(int pPasAffichage) {
        this.fPasAffichage = Math.max(1, pPasAffichage);
    }

    public void ajouteFond(Fond pFond) {
        this.fFonds.add(pFond);
    }

    public List<Fond> getFonds() {
        return this.fFonds;
    }

    public Marges estimeMarge() {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics graphics = img.getGraphics();
        int marge = 1;
        Rectangle2D rEtiqAxeV = this.getAxeV().empriseEtiquette(graphics);
        Rectangle2D rEtiqAxeH = this.getAxeH().empriseEtiquette(graphics);
        Rectangle2D empriseGraduationV = this.fAxeV.getGraduation().emprise(graphics);
        Rectangle2D empriseGraduationH = this.fAxeH.getGraduation().emprise(graphics);
        graphics.dispose();
        double gauche = 0.0;
        double droite = 0.0;
        double haut = 0.0;
        double bas = 0.0;
        switch ((PositionAxeV)this.getPosAxeV()) {
            case GAUCHE: 
            case ORIGINE: {
                gauche = empriseGraduationV.getWidth() + (double)marge + (double)this.fAxeV.getGraduation().getTaille() / 2.0 + rEtiqAxeV.getWidth() + (double)marge;
                break;
            }
            case DROITE: {
                droite = empriseGraduationV.getWidth() + (double)(2 * marge) + (double)this.fAxeV.getGraduation().getTaille() / 2.0 + rEtiqAxeV.getWidth() + (double)marge;
                break;
            }
        }
        switch ((PositionAxeH)this.getPosAxeH()) {
            case ORIGINE: 
            case BAS: {
                bas = empriseGraduationH.getHeight() + (double)(2 * marge) + (double)this.fAxeH.getGraduation().getTaille() / 2.0 + rEtiqAxeH.getHeight() + (double)marge;
                break;
            }
            case HAUT: {
                haut = empriseGraduationH.getHeight() + (double)(2 * marge) + (double)this.fAxeH.getGraduation().getTaille() / 2.0 + rEtiqAxeH.getHeight() + (double)marge;
                break;
            }
        }
        return new Marges(haut, droite, bas, gauche);
    }

    public JDessinGraphique getDessin() {
        return this.fDessin;
    }

    public List<Serie> getSeriesActives() {
        ArrayList<Serie> series = new ArrayList<Serie>();
        for (Serie s : this.fSeries) {
            if (!s.isActive()) continue;
            series.add(s);
        }
        return series;
    }

    public void supprimeFonds() {
        this.fFonds.clear();
    }

    protected void majDpix() {
        if (this.fAxeH != null && this.fAxeV != null) {
            this.fDessin.ajusteMarges();
            PixelTransformer ptH = null;
            switch (this.fAxeH.getSens()) {
                case DIRECT: {
                    ptH = new DirectHPixelTransformer(this.fAxeH.getMin(), this.fAxeH.getMax(), this.fDessin.getMargesAxe().getGauche(), this.fDessin.getMargesAxe().getDroite(), this.fDessin.getWidth(), this.fDessin.getTranslationH(), this.fDessin.getZoomX(), this.fAxeH.getScaleFunction());
                    break;
                }
                case INDIRECT: {
                    ptH = new IndirectHPixelTransformer(this.fAxeH.getMin(), this.fAxeH.getMax(), this.fDessin.getMargesAxe().getGauche(), this.fDessin.getMargesAxe().getDroite(), this.fDessin.getWidth(), this.fDessin.getTranslationH(), this.fDessin.getZoomX(), this.fAxeH.getScaleFunction());
                }
            }
            this.fAxeH.setPixelTransformer(ptH);
            PixelTransformer ptV = null;
            switch (this.fAxeV.getSens()) {
                case DIRECT: {
                    ptV = new DirectVPixelTransformer(this.fAxeV.getMin(), this.fAxeV.getMax(), this.fDessin.getMargesAxe().getBas(), this.fDessin.getMargesAxe().getHaut(), this.fDessin.getHeight(), this.fDessin.getTranslationV(), this.fDessin.getZoomY(), this.fAxeV.getScaleFunction());
                    break;
                }
                case INDIRECT: {
                    ptV = new IndirectVPixelTransformer(this.fAxeV.getMin(), this.fAxeV.getMax(), this.fDessin.getMargesAxe().getBas(), this.fDessin.getMargesAxe().getHaut(), this.fDessin.getHeight(), this.fDessin.getTranslationV(), this.fDessin.getZoomY(), this.fAxeV.getScaleFunction());
                }
            }
            this.fAxeV.setPixelTransformer(ptV);
            PixelTransformeFacade2D ptf2D = new PixelTransformeFacade2D(ptH, ptV);
            ptf2D.majDpix(this.fDessin.isOrthonorme());
            this.majDrawingRectangle();
        }
    }

    private void majDrawingRectangle() {
        this.fDrawingRectangle.setBounds((int)this.fDessin.getMargesAxe().getGauche(), (int)this.fDessin.getMargesAxe().getHaut(), (int)((double)this.fDessin.getWidth() - this.fDessin.getMargesAxe().getDroite() - this.fDessin.getMargesAxe().getGauche()), (int)((double)this.fDessin.getHeight() - this.fDessin.getMargesAxe().getHaut() - this.fDessin.getMargesAxe().getBas()));
    }

    public Rectangle getDrawingRectangle() {
        return this.fDrawingRectangle.getBounds();
    }

    public void setClip(Rectangle pClipSeries) {
        this.fClipSeries = pClipSeries;
    }

    public IElementListener linkWith(final Repere rep1) {
        IElementListener listener = new IElementListener(){

            public void valeurModifiee(Object pValue) {
                if (rep1.getAxeV().getMin() != Repere.this.getAxeV().getMin() || rep1.getAxeV().getMax() != Repere.this.getAxeV().getMax()) {
                    rep1.setBornesY(Repere.this.getAxeV().getMin(), Repere.this.getAxeV().getMax());
                }
            }

            public boolean desactivable() {
                return true;
            }
        };
        this.getAxeV().getElementListenerHelper().addElementListener("BORNES", listener);
        return listener;
    }
}

