/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.ITypeDessin;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.xml.XmlUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PolyLigne
implements ITypeDessin {
    private Stroke fStroke = new BasicStroke(1.0f);

    @Override
    public void dessine(Serie pCourbe, Graphics pG, double pXMin, double pXMax, int pPasAffichage) {
        if (pCourbe.size() < 2) {
            return;
        }
        Plage plage = pCourbe.plageFor(pXMin, pXMax);
        int i0 = plage.getIndiceMin();
        int i1 = plage.getIndiceMax();
        if (i0 >= pCourbe.size()) {
            return;
        }
        Axe axeH = pCourbe.getRepere().getAxeH();
        Axe axeV = pCourbe.getRepere().getAxeV();
        pG.setColor(pCourbe.getCouleur());
        Stroke oldStroke = ((Graphics2D)pG).getStroke();
        ((Graphics2D)pG).setStroke(this.fStroke);
        if (i0 < i1) {
            int n = 0;
            int[] xPoints = new int[i1 - i0 + 1];
            int[] yPoints = new int[i1 - i0 + 1];
            double x = axeH.valToPix(pCourbe.getX(i0));
            double y = axeV.valToPix(pCourbe.getY(i0));
            if (Double.isFinite(y)) {
                xPoints[n] = (int)x;
                yPoints[n] = (int)y;
                yPoints[n] = y < -1000.0 ? -1000 : (int)y;
                ++n;
            }
            try {
                for (int j = i0 + pPasAffichage; j < i1; j += pPasAffichage) {
                    x = axeH.valToPix(pCourbe.getX(j));
                    y = axeV.valToPix(pCourbe.getY(j));
                    if (Double.isFinite(y)) {
                        if (n != 0 && xPoints[n - 1] == (int)x && (double)yPoints[n - 1] == y) continue;
                        xPoints[n] = (int)x;
                        yPoints[n] = y < -1000.0 ? -1000 : (int)y;
                        ++n;
                        continue;
                    }
                    if (n > 1) {
                        pG.drawPolyline(xPoints, yPoints, n);
                        n = 0;
                        continue;
                    }
                    pG.fillOval(xPoints[0], yPoints[0], 2, 2);
                    n = 0;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            pG.drawPolyline(xPoints, yPoints, n);
        }
        ((Graphics2D)pG).setStroke(oldStroke);
    }

    @Override
    public Stroke getStroke() {
        return this.fStroke;
    }

    @Override
    public void setStroke(Stroke pStroke) {
        this.fStroke = pStroke == null ? new BasicStroke(1.0f) : pStroke;
    }

    public Element getDomElement(Document pDoc) {
        Element root = pDoc.createElement(MapXmlGraph.getInstance().getNomElement(ITypeDessin.class));
        root.appendChild(XmlUtils.createStrokeNode((Document)pDoc, (BasicStroke)((BasicStroke)this.fStroke)));
        return root;
    }

    public void setProperties(Node pNoeud) {
        this.setStroke(XmlUtils.getStroke((Node)pNoeud));
    }

    @Override
    public boolean hasFillColor() {
        return false;
    }

    @Override
    public Color getFillColor() {
        return null;
    }

    @Override
    public void setFillColor(Color pCOlor) {
    }

    @Override
    public int getDXMinAff() {
        return 0;
    }

    @Override
    public int getDXMaxAff() {
        return 0;
    }
}

