/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.Histogramme;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.MultiCourbes;
import fr.dbe.graphique.PositionBarreHistogramme;
import fr.dbe.graphique.Repere;
import java.awt.Graphics;
import java.awt.Point;
import java.util.List;

public class HistoMoyenne
extends MultiCourbes {
    public HistoMoyenne(String pNom, List<Courbe> pCourbes, PositionBarreHistogramme pPositionBarreHistogramme) {
        super(pNom, pCourbes.get(0).getXMin(), pCourbes.get(0).getDx());
        this.fCourbes = pCourbes;
        for (Courbe c : this.fCourbes) {
            if (c.getTypeDessin() instanceof Histogramme) continue;
            c.setTypeDessin(new Histogramme(pPositionBarreHistogramme));
        }
        this.setTypeDessin(new Histogramme(pPositionBarreHistogramme));
        this.setCursorable(false);
    }

    @Override
    public void setVisible(boolean pEtat) {
        super.setVisible(pEtat);
        for (Courbe c : this.fCourbes) {
            c.setVisible(pEtat);
        }
    }

    @Override
    public void setRepere(Repere pRepere) {
        if (this.fRepere != null && pRepere != this.fRepere) {
            throw new IllegalArgumentException(Messages.getString("HistoSuperpose.0"));
        }
        this.fRepere = pRepere;
        for (Courbe c : this.fCourbes) {
            c.setRepere(pRepere);
        }
    }

    @Override
    public double getX(int pIndice) {
        return ((Courbe)this.fCourbes.get(0)).getX(pIndice);
    }

    @Override
    public double getXMin() {
        double res = Double.POSITIVE_INFINITY;
        for (Courbe c : this.fCourbes) {
            res = Math.min(res, c.getXMin());
        }
        return res;
    }

    @Override
    public double getXMax() {
        double res = Double.MIN_VALUE;
        for (Courbe c : this.fCourbes) {
            res = Math.max(res, c.getXMax());
        }
        return res;
    }

    @Override
    public double getY(int pIndice) {
        double res = 0.0;
        for (Courbe c : this.fCourbes) {
            res += c.getY(pIndice);
        }
        return res / (double)this.fCourbes.size();
    }

    @Override
    public double getYMax() {
        double res = Double.MIN_VALUE;
        for (int i = 0; i < this.size(); ++i) {
            double somme = 0.0;
            for (Courbe c : this.fCourbes) {
                somme += c.getY(i);
            }
            res = Math.max(res, somme);
        }
        return res / (double)this.fCourbes.size();
    }

    @Override
    public double getYMin() {
        double res = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.size(); ++i) {
            double somme = 0.0;
            for (Courbe c : this.fCourbes) {
                somme += c.getY(i);
            }
            res = Math.min(res, somme);
        }
        return res / (double)this.fCourbes.size();
    }

    @Override
    public int size() {
        return ((Courbe)this.fCourbes.get(0)).size();
    }

    @Override
    public void dessine(Graphics pG, double pXMin, double pXMax, int pPasAffichage) {
        this.getTypeDessin().dessine(this, pG, pXMin, pXMax, pPasAffichage);
    }

    @Override
    public void remove(int pIndice) {
        for (Courbe c : this.fCourbes) {
            c.remove(pIndice);
        }
    }

    @Override
    public void clear() {
        for (Courbe c : this.fCourbes) {
            c.clear();
        }
    }

    @Override
    public void clearDirect() {
        for (Courbe c : this.fCourbes) {
            c.clearDirect();
        }
    }

    @Override
    public int getIndice(Point pP) {
        return ((Courbe)this.fCourbes.get(0)).getIndice(pP);
    }

    public int getNbCourbesVisibles() {
        int nb = 1;
        for (Courbe c : this.fCourbes) {
            if (!c.isVisible()) continue;
            ++nb;
        }
        return nb;
    }
}

