/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.AxeH;
import fr.dbe.graphique.Direction;
import fr.dbe.graphique.Graduation;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.PositionAxeH;
import fr.dbe.graphique.PositionGraduation;
import fr.dbe.graphique.Sens;
import fr.dbe.graphique.Serie;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.util.List;

class GraduationH
extends Graduation {
    private double fDebutDrag;

    public GraduationH(AxeH pAxeH) {
        super(pAxeH);
        this.setMarges(new Marges(4.0, 3.0, 3.0, 3.0));
    }

    @Override
    protected Polygon dessineGraduation(Graphics pGraphics, int pPosition, String pTexte, Polygon[] pPolygons) {
        if (pTexte.length() == 0) {
            return null;
        }
        int positionAxe = this.getAxe().getPosition();
        Point p = new Point(pPosition, positionAxe);
        FontMetrics fm = pGraphics.getFontMetrics();
        Rectangle textBounds = fm.getStringBounds(pTexte, pGraphics).getBounds();
        if (this.getOrientation() == 0.0) {
            Polygon emprise = this.empriseGraduation(pGraphics, pPosition, pTexte);
            if (emprise.getBounds2D().getMaxX() > 0.0 && !this.intersects(emprise, pPolygons)) {
                pGraphics.setColor(this.getCouleur());
                pGraphics.drawLine(p.x, p.y + this.getTaille(), p.x, p.y - this.getTaille());
                pGraphics.setColor(this.getCouleurTexte());
                int py = this.getAxe().getRepere().getPosAxeH() == PositionAxeH.ORIGINE && this.positionGraduation == PositionGraduation.NEAR_AXIS ? (int)this.getAxe().getRepere().getAxeV().valToPix(0.0) - textBounds.y + this.getTaille() + 2 : (int)(emprise.getBounds2D().getMinY() + this.getMarges().getHaut() - (double)textBounds.y);
                pGraphics.drawString(pTexte, (int)(emprise.getBounds2D().getMinX() + this.getMarges().getGauche()), py);
                return emprise;
            }
        } else {
            double h = this.getDhText(textBounds, (PositionAxeH)this.getAxe().getRepere().getPosAxeH());
            int py = this.getAxe().getRepere().getPosAxeH() == PositionAxeH.ORIGINE ? (int)((double)this.getAxe().getDessin().getHeight() - this.getAxe().getDessin().getMargesAxe().getBas()) : positionAxe;
            Polygon emprise = this.empriseGraduation(pGraphics, pPosition, pTexte);
            if (emprise.getBounds2D().getMaxX() > 0.0 && !this.intersects(emprise, pPolygons)) {
                pGraphics.setColor(this.getCouleur());
                pGraphics.drawLine(p.x, p.y + this.getTaille(), p.x, p.y - this.getTaille());
                pGraphics.setColor(this.getCouleurTexte());
                Graphics2D g2D = (Graphics2D)pGraphics;
                AffineTransform atOld = g2D.getTransform();
                AffineTransform at = new AffineTransform();
                at.setToRotation(-this.getOrientation(), p.x, py);
                AffineTransform at2 = new AffineTransform();
                at2.setToTranslation(0.0, h);
                at2.concatenate(at);
                g2D.transform(at2);
                int[] ypoints = new int[emprise.ypoints.length];
                for (int i = 0; i < emprise.ypoints.length; ++i) {
                    ypoints[i] = (int)((double)emprise.ypoints[i] - h);
                }
                Polygon pp = new Polygon(emprise.xpoints, ypoints, emprise.npoints);
                pp = GraduationH.rotate(pp, new Point(p.x, py), this.getOrientation(), 0.0);
                TextLayout tl = new TextLayout(pTexte, g2D.getFont(), g2D.getFontRenderContext());
                tl.draw(g2D, (int)(pp.getBounds2D().getMinX() + this.getMarges().getGauche()), (int)(pp.getBounds2D().getMinY() - (double)textBounds.y + this.getMarges().getHaut()));
                g2D.setTransform(atOld);
                return emprise;
            }
        }
        return null;
    }

    @Override
    protected Polygon empriseGraduation(Graphics pGraphics, int pPosition, String pTexte) {
        int y;
        int x;
        int positionAxe = this.getAxe().getPosition();
        FontMetrics fm = pGraphics.getFontMetrics();
        Rectangle textBounds = fm.getStringBounds(pTexte, pGraphics).getBounds();
        textBounds.x = (int)((double)textBounds.x - this.getMarges().getGauche());
        textBounds.y = (int)((double)textBounds.y - this.getMarges().getHaut());
        textBounds.width = (int)((double)textBounds.width + (this.getMarges().getGauche() + this.getMarges().getDroite()));
        textBounds.y = (int)((double)textBounds.y - (this.getMarges().getHaut() + this.getMarges().getBas()));
        Polygon poly = null;
        if (this.getOrientation() == 0.0) {
            int y2;
            int x2;
            switch ((PositionAxeH)this.getAxe().getRepere().getPosAxeH()) {
                case BAS: {
                    x2 = pPosition - textBounds.width / 2;
                    y2 = positionAxe - textBounds.y + this.getTaille() / 2;
                    break;
                }
                case HAUT: {
                    x2 = pPosition - textBounds.width / 2;
                    y2 = positionAxe - textBounds.height - textBounds.y - this.getTaille() / 2;
                    break;
                }
                case ORIGINE: {
                    x2 = pPosition - textBounds.width / 2;
                    int py = (int)((double)this.getAxe().getDessin().getHeight() - this.getAxe().getDessin().getMargesAxe().getBas());
                    y2 = py - textBounds.y + this.getTaille() / 2;
                    break;
                }
                default: {
                    return null;
                }
            }
            return GraduationH.rectangleToPolygon(new Rectangle(x2, y2 + textBounds.y, textBounds.width, textBounds.height));
        }
        double h = this.getDhText(textBounds, (PositionAxeH)this.getAxe().getRepere().getPosAxeH());
        int py = this.getAxe().getRepere().getPosAxeH() == PositionAxeH.ORIGINE ? (int)((double)this.getAxe().getDessin().getHeight() - this.getAxe().getDessin().getMargesAxe().getBas()) : positionAxe;
        switch ((PositionAxeH)this.getAxe().getRepere().getPosAxeH()) {
            case BAS: 
            case ORIGINE: {
                x = this.getOrientation() > 0.0 ? pPosition - textBounds.width : pPosition;
                y = py - textBounds.y / 2;
                break;
            }
            case HAUT: {
                x = this.getOrientation() < 0.0 ? pPosition - textBounds.width : pPosition;
                y = py - textBounds.y / 2;
                break;
            }
            default: {
                return poly;
            }
        }
        poly = GraduationH.rectangleToPolygon(new Rectangle(x, y + textBounds.y, textBounds.width, textBounds.height));
        poly = GraduationH.rotate(poly, new Point(pPosition, py), -this.getOrientation(), h);
        return poly;
    }

    @Override
    public Direction getDirection() {
        return Direction.HORIZONTALE;
    }

    @Override
    public boolean contains(Point pPoint) {
        this.fSelectedPoint = null;
        boolean res = this.containsFast(pPoint);
        if (res) {
            this.fSelectedPoint = pPoint;
            this.fValSelection = this.getAxe().pixToVal(this.fSelectedPoint.x);
        }
        return res;
    }

    @Override
    public boolean containsFast(Point pPoint) {
        return Math.abs(this.getAxe().getPosition() - pPoint.y) <= this.getTaille() + 1;
    }

    @Override
    public Dimension deplace(double pDx, double pDy) {
        if (pDx == 0.0 || !this.fDeplacable) {
            return new Dimension(0, 0);
        }
        this.fCurrentDrag.x = (int)((double)this.fCurrentDrag.x + pDx);
        if (this.fSelectedPoint != null) {
            double dx = this.getAxe().getSens() == Sens.DIRECT ? (double)(this.fCurrentDrag.x - this.fSelectedPoint.x) : (double)(this.fSelectedPoint.x - this.fCurrentDrag.x);
            List<Serie> series = this.getAxe().getRepere().getSeries();
            double xMin = Double.MAX_VALUE;
            double xMax = -1.7976931348623157E308;
            if (!series.isEmpty()) {
                for (Serie serie : series) {
                    xMin = Math.min(xMin, serie.getXMin());
                    xMax = Math.max(xMax, serie.getXMax());
                }
            }
            double cMax = 10.0;
            double zoom = dx > 0.0 ? Math.pow((dx + cMax) / cMax, 2.0) * this.fZoomDebutDrag : Math.pow((Math.abs(dx) + cMax) / cMax, -2.0) * this.fZoomDebutDrag;
            if (zoom < 1.0 && (this.getAxe().getMin() > xMin || this.getAxe().getMax() < xMax)) {
                this.getAxe().setBornes(xMin, xMax);
            }
            zoom = Math.max(1.0, zoom);
            this.getAxe().getRepere().getDessin().setZoom(zoom, this.getAxe().getRepere().getDessin().getZoomY());
            if (zoom != 1.0) {
                Point p = new Point((int)(this.getAxe().valToPix(this.fDebutDrag) - (this.fCurrentDrag.getX() - (double)this.getAxe().getDessin().getWidth() / 2.0)), 0);
                this.getAxe().getRepere().getDessin().centre(p);
            }
        }
        return new Dimension((int)pDx, 0);
    }

    @Override
    public void setDebutDrag(Point pPoint) {
        if (pPoint != null) {
            this.fDebutDrag = this.getAxe().pixToVal((int)pPoint.getX());
        }
        this.fCurrentDrag = pPoint;
        this.fZoomDebutDrag = this.getAxe().getRepere().getDessin().getZoomX();
    }

    @Override
    public double computeIntervalle(Axe pAxeH) {
        Rectangle r = pAxeH.getRepere().getDrawingRectangle();
        return Math.abs(pAxeH.pixToVal((int)r.getMinX()) - pAxeH.pixToVal((int)r.getMaxX())) / (double)this.getNombre();
    }

    public double getDhText(Rectangle pTextBounds, PositionAxeH pPositionAxeH) {
        if (pPositionAxeH == PositionAxeH.HAUT) {
            return -(Math.cos(this.getOrientation()) * (double)pTextBounds.height / 2.0 + this.getMarges().getBas()) - (pTextBounds.getHeight() + pTextBounds.getY());
        }
        return Math.cos(this.getOrientation()) * (double)pTextBounds.height / 2.0 + this.getMarges().getHaut();
    }
}

