/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Graduation;
import fr.dbe.graphique.GraduationH;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.PositionGraduation;
import fr.dbe.graphique.Repartition;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.BoxAssistant;
import fr.dbe.util.ihm.JAssistant;
import fr.dbe.util.ihm.JButtonColorWithLib;
import fr.dbe.util.ihm.JFontSel;
import fr.dbe.util.ihm.JTextFieldSel;
import fr.dbe.util.ihm.JTextFieldWithLabel;
import fr.dbe.util.ihm.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;

class BoxGraduation
extends BoxAssistant {
    public static final int TAILLE_LIBELLE = 90;
    private final JButtonColorWithLib fBtCouleur = new JButtonColorWithLib(90);
    protected JTextFieldSel fSleIntervalle = Utils.createTextFieldSel((String)"", (int)150);
    protected JTextFieldSel fSleNombre = Utils.createTextFieldSel((String)"", (int)150);
    protected JTextFieldSel fSlePositions = Utils.createTextFieldSel((String)"", (int)150);
    protected JRadioButton fRbIntervalle = Utils.createRadioButton((String)Messages.getString("BoxQuadrillage.3"), (int)90);
    protected JRadioButton fRbNombre = Utils.createRadioButton((String)Messages.getString("BoxQuadrillage.4"), (int)90);
    protected JRadioButton fRbPositions = Utils.createRadioButton((String)Messages.getString("BoxQuadrillage.12"), (int)90);
    protected JRadioButton fRbOut = Utils.createRadioButton((String)Messages.getString("BoxQuadrillage.104"), (int)150);
    protected JRadioButton fRbNear = Utils.createRadioButton((String)Messages.getString("BoxQuadrillage.112"), (int)150);
    protected JCheckBox fCbVisible = Utils.createCheckBox((String)Messages.getString("BoxQuadrillage.2"));
    protected JTextFieldWithLabel fSleTaille = new JTextFieldWithLabel(Messages.getString("BoxGraduation.4"), 90, "", 150, null);
    protected JSlider fSliderOrientation = new JSlider(0, -90, 90, 0);
    protected JFontSel fFontSel = new JFontSel(90);
    protected Box fBoxRepartition;
    protected JTextFieldWithLabel fSleGauche = new JTextFieldWithLabel(Messages.getString("BoxGeneral.0"), 90, "", 150, null);
    protected JTextFieldWithLabel fSleDroite = new JTextFieldWithLabel(Messages.getString("BoxGeneral.2"), 90, "", 150, null);
    protected JTextFieldWithLabel fSleHaut = new JTextFieldWithLabel(Messages.getString("BoxGeneral.4"), 90, "", 150, null);
    protected JTextFieldWithLabel fSleBas = new JTextFieldWithLabel(Messages.getString("BoxGeneral.6"), 90, "", 150, null);
    protected JCheckBox fCbValeursEntieres = Utils.createCheckBox((String)Messages.getString("BoxGraduation.11"));
    protected JCheckBox fCbValeursRondes = Utils.createCheckBox((String)Messages.getString("BoxGraduation.12"));
    private Graduation fGraduation;

    public BoxGraduation(JAssistant pAssistant, Graduation pGraduation) {
        super(pAssistant, 0);
        this.add(Box.createHorizontalStrut(10));
        Box bIntervalle = Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fRbIntervalle, this.fSleIntervalle});
        Box bNombre = Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fRbNombre, this.fSleNombre});
        Box bPositions = Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fRbPositions, this.fSlePositions});
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.fRbIntervalle);
        bg.add(this.fRbNombre);
        bg.add(this.fRbPositions);
        Box boxPosition = Utils.createHorizontalBox((int)0, (Component[])new Component[]{Utils.createLabel((String)"Position : "), this.fRbOut, this.fRbNear});
        bg = new ButtonGroup();
        bg.add(this.fRbOut);
        bg.add(this.fRbNear);
        Box bSelIntNb = Utils.createVerticalBox((int)5, (Component[])new Component[]{bIntervalle, bNombre, bPositions});
        Box bLibIntNBox = Utils.createVerticalBox((int)5, (Component[])new Component[]{Utils.createLabel((String)Messages.getString("BoxGraduation.9"), (int)90)});
        this.fBoxRepartition = Utils.createHorizontalBox((int)0, (Component[])new Component[]{bLibIntNBox, bSelIntNb});
        if (pGraduation instanceof GraduationH) {
            this.add(Utils.createVerticalBox((int)5, (Component[])new Component[]{boxPosition, this.fFontSel, this.fBtCouleur, this.fSleTaille, Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fSleGauche}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fSleDroite}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fSleHaut}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fSleBas}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fCbValeursEntieres}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fCbValeursRondes}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{Utils.createLabel((String)Messages.getString("BoxGraduation.10"), (int)90), this.fSliderOrientation}), this.fBoxRepartition, Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fCbValeursEntieres}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fCbValeursRondes}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fCbVisible})}));
        } else {
            this.add(Utils.createVerticalBox((int)5, (Component[])new Component[]{boxPosition, this.fFontSel, this.fBtCouleur, this.fSleTaille, Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fSleGauche}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fSleDroite}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fSleHaut}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fSleBas}), this.fBoxRepartition, Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fCbValeursEntieres}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fCbValeursRondes}), Utils.createHorizontalBox((int)0, (Component[])new Component[]{this.fCbVisible})}));
        }
        this.add(Box.createHorizontalStrut(10));
        this.setGraduation(pGraduation);
        ItemListener il = pE -> {
            this.fSleIntervalle.setEnabled(this.fRbIntervalle.isSelected());
            this.fSleNombre.setEnabled(this.fRbNombre.isSelected());
            this.fSlePositions.setEnabled(this.fRbPositions.isSelected());
        };
        this.fRbIntervalle.addItemListener(il);
        this.fRbNombre.addItemListener(il);
        this.fRbPositions.addItemListener(il);
        il.itemStateChanged(null);
        if (pGraduation.getAxe().getMaster() != null) {
            this.fSleIntervalle.setEnabled(false);
            this.fSleNombre.setEnabled(false);
            this.fSlePositions.setEnabled(false);
            this.fSleTaille.getTextField().setEnabled(false);
            this.fSliderOrientation.setEnabled(false);
            this.fRbNombre.setEnabled(false);
            this.fRbIntervalle.setEnabled(false);
            this.fRbPositions.setEnabled(false);
        }
        this.fSliderOrientation.setOpaque(false);
        this.fSliderOrientation.setPreferredSize(new Dimension(150, 40));
        this.fSliderOrientation.setMaximumSize(this.fSliderOrientation.getPreferredSize());
        this.fSliderOrientation.setMinimumSize(this.fSliderOrientation.getPreferredSize());
        this.fSliderOrientation.setMajorTickSpacing(90);
        this.fSliderOrientation.setMinorTickSpacing(10);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(-90, Utils.createLabel((String)"-90"));
        labelTable.put(0, Utils.createLabel((String)"0"));
        labelTable.put(90, Utils.createLabel((String)"90"));
        this.fSliderOrientation.setLabelTable(labelTable);
        this.fSliderOrientation.setPaintTicks(true);
        this.fSliderOrientation.setPaintLabels(true);
        this.fSliderOrientation.addChangeListener(pArg0 -> {
            this.fGraduation.setOrientation((double)this.fSliderOrientation.getValue() * Math.PI / 180.0);
            this.fGraduation.getAxe().getDessin().majDpix();
        });
    }

    public Graduation getGraduation() {
        return this.fGraduation;
    }

    public void setGraduation(Graduation pGraduation) {
        this.fGraduation = pGraduation;
        this.fBtCouleur.setCouleur(this.fGraduation.getCouleur());
        this.fCbVisible.setSelected(this.fGraduation.isVisible());
        this.fFontSel.setPolice(this.fGraduation.getPolice());
        this.fFontSel.setCouleur(this.fGraduation.getCouleurTexte());
        this.fRbIntervalle.setSelected(this.fGraduation.getRepartition() == Repartition.INTERVALLE);
        this.fRbNombre.setSelected(this.fGraduation.getRepartition() == Repartition.NOMBRE);
        this.fRbPositions.setSelected(this.fGraduation.getRepartition() == Repartition.POSITIONS);
        this.fRbOut.setSelected(this.fGraduation.getPositionGraduation() == PositionGraduation.OUT_DRAW_CANVAS);
        this.fRbNear.setSelected(this.fGraduation.getPositionGraduation() == PositionGraduation.NEAR_AXIS);
        if (this.fGraduation.getPositions() != null) {
            StringBuilder sb = new StringBuilder(100);
            for (double d : this.fGraduation.getPositions()) {
                sb.append(d).append(";");
            }
            this.fSlePositions.setText(sb.toString());
        }
        if (this.fRbIntervalle.isSelected()) {
            this.fSleIntervalle.setText("" + this.fGraduation.getIntervalle());
        }
        if (this.fRbNombre.isSelected()) {
            this.fSleNombre.setText("" + this.fGraduation.getNombre());
        }
        this.fSleTaille.setText("" + this.fGraduation.getTaille());
        this.fSliderOrientation.setValue((int)(this.fGraduation.getOrientation() / Math.PI * 180.0));
        this.fSleGauche.setText("" + (int)this.fGraduation.getMarges().getGauche());
        this.fSleDroite.setText("" + (int)this.fGraduation.getMarges().getDroite());
        this.fSleHaut.setText("" + (int)this.fGraduation.getMarges().getHaut());
        this.fSleBas.setText("" + (int)this.fGraduation.getMarges().getBas());
        this.fCbValeursEntieres.setSelected(this.fGraduation.isIntValues());
        this.fCbValeursRondes.setSelected(this.fGraduation.isValeursRondes());
        this.addValidationFor((JTextField)this.fSleIntervalle);
        this.addValidationFor((JTextField)this.fSleNombre);
        this.addValidationFor((JTextField)this.fSlePositions);
        this.addValidationFor(this.fSleTaille.getTextField());
        this.addValidationFor(this.fRbNombre);
        this.addValidationFor(this.fRbIntervalle);
        this.addValidationFor(this.fRbPositions);
        this.addValidationFor(this.fSleHaut);
        this.addValidationFor(this.fSleDroite);
        this.addValidationFor(this.fSleGauche);
        this.addValidationFor(this.fSleBas);
        this.addValidationFor(this.fCbValeursEntieres);
        this.addValidationFor(this.fCbValeursRondes);
        this.addValidationFor(this.fRbOut);
        this.addValidationFor(this.fRbNear);
    }

    public void majbtOk() {
        try {
            int h = Utilitaire.parseInt((String)this.fSleGauche.getText());
            if (h < 0 || h > 1000) {
                this.fAssistant.error(Messages.getString("BoxGeneral.17"));
                this.fSleGauche.setForeground(Color.RED);
            }
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxGeneral.18"));
            this.fSleGauche.setForeground(Color.RED);
        }
        try {
            int v = Utilitaire.parseInt((String)this.fSleDroite.getText());
            if (v < 0 || v > 1000) {
                this.fAssistant.error(Messages.getString("BoxGeneral.19"));
                this.fSleDroite.setForeground(Color.RED);
            }
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxGeneral.20"));
            this.fSleDroite.setForeground(Color.RED);
        }
        try {
            int v = Utilitaire.parseInt((String)this.fSleHaut.getText());
            if (v < 0 || v > 1000) {
                this.fAssistant.error(Messages.getString("BoxGeneral.21"));
                this.fSleHaut.setForeground(Color.RED);
            }
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxGeneral.22"));
            this.fSleHaut.setForeground(Color.RED);
        }
        try {
            int v = Utilitaire.parseInt((String)this.fSleBas.getText());
            if (v < 0 || v > 1000) {
                this.fAssistant.error(Messages.getString("BoxGeneral.23"));
                this.fSleBas.setForeground(Color.RED);
            }
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxGeneral.24"));
            this.fSleBas.setForeground(Color.RED);
        }
        this.fRbNombre.setForeground(Color.BLACK);
        if (this.fRbNombre.isSelected()) {
            try {
                int nb = Utilitaire.parseInt((String)this.fSleNombre.getText());
                if (nb < 1 || nb > 999) {
                    this.fAssistant.error(Messages.getString("BoxGraduation.14"));
                    this.fRbNombre.setForeground(Color.RED);
                }
            }
            catch (Exception ex) {
                this.fAssistant.error(Messages.getString("BoxGraduation.15"));
                this.fRbNombre.setForeground(Color.RED);
            }
        }
        this.fRbIntervalle.setForeground(Color.BLACK);
        if (this.fRbIntervalle.isSelected()) {
            try {
                double intervalle = Utilitaire.parseDouble((String)this.fSleIntervalle.getText());
                if (intervalle < 0.0) {
                    this.fAssistant.error(Messages.getString("BoxGraduation.16"));
                    this.fRbIntervalle.setForeground(Color.RED);
                }
            }
            catch (Exception ex) {
                this.fAssistant.error(Messages.getString("BoxGraduation.17"));
                this.fRbIntervalle.setForeground(Color.RED);
            }
        }
        this.fRbPositions.setForeground(Color.BLACK);
        if (this.fRbPositions.isSelected()) {
            try {
                Utilitaire.stringToDoubleArray((String)this.fSlePositions.getText(), (String)";");
            }
            catch (Exception ex) {
                this.fAssistant.error(Messages.getString("BoxQuadrillage.13"));
                this.fRbPositions.setForeground(Color.RED);
            }
        }
        try {
            int taille = Utilitaire.parseInt((String)this.fSleTaille.getText());
            if (taille < 1 || taille > 100) {
                this.fAssistant.error(Messages.getString("BoxGraduation.20"));
                this.fSleTaille.getLabel().setForeground(Color.RED);
            } else {
                this.fSleTaille.getLabel().setForeground(Color.BLACK);
            }
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxGraduation.21"));
            this.fSleTaille.getLabel().setForeground(Color.RED);
        }
        this.fGraduation.setValeursEntieres(this.fCbValeursEntieres.isSelected());
        this.fGraduation.setValeursRondes(this.fCbValeursRondes.isSelected());
    }

    public void doOk() {
        this.fGraduation.setCouleur(this.fBtCouleur.getCouleur());
        this.fGraduation.setVisible(this.fCbVisible.isSelected());
        this.fGraduation.setPolice(this.fFontSel.getPolice());
        this.fGraduation.setCouleurTexte(this.fFontSel.getCouleur());
        if (this.fRbIntervalle.isSelected()) {
            this.fGraduation.setIntervalle(Utilitaire.parseDouble((String)this.fSleIntervalle.getText()));
        } else if (this.fRbNombre.isSelected()) {
            this.fGraduation.setNombre(Utilitaire.parseInt((String)this.fSleNombre.getText()));
        } else if (this.fRbPositions.isSelected()) {
            this.fGraduation.setPositions(Utilitaire.stringToDoubleArray((String)this.fSlePositions.getText(), (String)";"));
        }
        this.fGraduation.setTaille(Utilitaire.parseInt((String)this.fSleTaille.getText()));
        this.fGraduation.setOrientation((double)this.fSliderOrientation.getValue() * Math.PI / 180.0);
        this.fGraduation.setMarges(new Marges(Utilitaire.parseInt((String)this.fSleHaut.getText()), Utilitaire.parseInt((String)this.fSleDroite.getText()), Utilitaire.parseInt((String)this.fSleBas.getText()), Utilitaire.parseInt((String)this.fSleGauche.getText())));
        this.fGraduation.setValeursEntieres(this.fCbValeursEntieres.isSelected());
        this.fGraduation.setValeursRondes(this.fCbValeursRondes.isSelected());
        if (this.fRbOut.isSelected()) {
            this.fGraduation.setPositionGraduation(PositionGraduation.OUT_DRAW_CANVAS);
        } else {
            this.fGraduation.setPositionGraduation(PositionGraduation.NEAR_AXIS);
        }
    }
}

