/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.Direction;
import fr.dbe.graphique.GraduationH;
import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.PositionAxeH;
import fr.dbe.graphique.Repere;
import fr.dbe.graphique.Sens;
import fr.dbe.graphique.pixeltransformer.DirectHPixelTransformer;
import fr.dbe.util.ihm.HorizontalLabelPosition;
import fr.dbe.util.ihm.Utils;
import fr.dbe.util.ihm.VerticalLabelPosition;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;

public class AxeH
extends Axe {
    public AxeH(JDessinGraphique p, Repere pRepere) {
        super(p, pRepere);
        this.fGraduation = new GraduationH(this);
        this.fEtiquette = "";
        this.fPixelTransformer = new DirectHPixelTransformer(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, null);
    }

    @Override
    public void dessineAxe(Graphics g) {
        int p;
        int signe;
        int xMin = (int)this.getRepere().getDrawingRectangle().getMinX();
        int xMax = (int)this.getRepere().getDrawingRectangle().getMaxX();
        g.drawLine(xMin, this.getPosition(), xMax, this.getPosition());
        if (this.fSens.equals((Object)Sens.DIRECT)) {
            signe = 1;
            p = xMax;
        } else {
            signe = -1;
            p = xMin;
        }
        g.drawLine(p - signe * 5, this.getPosition() - 2, p, this.getPosition());
        g.drawLine(p - signe * 5, this.getPosition() + 2, p, this.getPosition());
        String etiquette = this.getEtiquetteEtUnit();
        if (etiquette != null) {
            if (this.fCouleurEtiquette != null) {
                g.setColor(this.fCouleurEtiquette);
            }
            if (this.getFont() != null) {
                g.setFont(this.getActualFont());
                JLabel l = new JLabel(etiquette);
                l.setFont(g.getFont());
                while (g.getFont().getSize() > 4 && l.getPreferredSize().getWidth() > (double)(xMax - xMin)) {
                    g.setFont(new Font(g.getFont().getFontName(), g.getFont().getStyle(), g.getFont().getSize() - 1));
                    l.setFont(g.getFont());
                }
            }
            int x = 0;
            int y = 0;
            VerticalLabelPosition vp = VerticalLabelPosition.TOP;
            HorizontalLabelPosition hp = HorizontalLabelPosition.CENTER;
            if (this.getRepere().getPosAxeH().equals(PositionAxeH.HAUT)) {
                x = (xMax + xMin) / 2;
                y = (int)this.fDessin.getMarges().getHaut();
                vp = VerticalLabelPosition.TOP;
            } else if (this.getRepere().getPosAxeH().equals(PositionAxeH.BAS) || this.getRepere().getPosAxeH().equals(PositionAxeH.ORIGINE)) {
                x = (xMax + xMin) / 2;
                y = (int)((double)this.fDessin.getHeight() - this.fDessin.getMarges().getBas());
                vp = VerticalLabelPosition.BOTTOM;
            }
            Utils.drawLibelleHtml((Graphics)g, (int)x, (int)y, (String)etiquette, (HorizontalLabelPosition)hp, (VerticalLabelPosition)vp, null);
        }
    }

    @Override
    public double valToPix(double x) {
        return this.fPixelTransformer.val2Pix(x);
    }

    @Override
    public double pixToVal(int x) {
        return this.fPixelTransformer.pix2Val(x);
    }

    @Override
    public Direction getDirection() {
        return Direction.HORIZONTALE;
    }

    @Override
    public double getPositionAutreAxe() {
        return this.getRepere().getValPosAxeV();
    }

    @Override
    public Rectangle2D empriseEtiquette(Graphics pGraphics) {
        String etiquette = this.getEtiquetteEtUnit();
        if (etiquette == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        int xMin = (int)this.getRepere().getDrawingRectangle().getMinX();
        int xMax = (int)this.getRepere().getDrawingRectangle().getMaxX();
        Font font = this.getFont() == null ? pGraphics.getFont() : this.getActualFont();
        JLabel l = new JLabel(etiquette);
        l.setFont(font);
        while (font.getSize() > 4 && l.getPreferredSize().getWidth() > (double)(xMax - xMin)) {
            font = new Font(font.getFontName(), font.getStyle(), font.getSize() - 1);
            l.setFont(font);
        }
        return Utils.libelleHtmlBounds((Graphics)pGraphics, (int)0, (int)0, (String)etiquette, (HorizontalLabelPosition)HorizontalLabelPosition.CENTER, (VerticalLabelPosition)VerticalLabelPosition.MIDDLE, (Font)font);
    }
}

