/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm.customdialog;

import fr.dbe.util.ihm.customdialog.IntegerValidator;
import fr.dbe.util.ihm.customdialog.ObjectValidator;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class CustomDialog<T>
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private final ObjectValidator<T> fValidator;
    private final JTextField textField;
    private final JOptionPane optionPane;
    private final String btnString1 = "OK";
    private T typedObject = null;

    public CustomDialog(Frame aFrame, String pMessage, String pTitle, ObjectValidator<T> pValidator) {
        super(aFrame, true);
        this.setTitle(pTitle);
        this.fValidator = pValidator;
        this.textField = new JTextField(10);
        Object[] array = new Object[]{pMessage, this.textField};
        String btnString2 = "Cancel";
        Object[] options = new Object[]{"OK", btnString2};
        this.optionPane = new JOptionPane(array, 3, 0, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                CustomDialog.this.optionPane.setValue(-1);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                CustomDialog.this.textField.requestFocusInWindow();
            }
        });
        this.textField.addActionListener(this);
        this.optionPane.addPropertyChangeListener(this);
    }

    public static void main(String[] args) {
        CustomDialog<Integer> dialog = new CustomDialog<Integer>(null, "N", "Input", new IntegerValidator(1, Integer.MAX_VALUE));
        dialog.pack();
        dialog.setVisible(true);
        System.out.println(dialog.getValidated());
    }

    public T getValidated() {
        return this.typedObject;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.optionPane.setValue("OK");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if ("OK".equals(value)) {
                this.typedObject = this.fValidator.validate(this, this.textField.getText());
                if (this.typedObject == null) {
                    this.textField.selectAll();
                    this.textField.requestFocusInWindow();
                } else {
                    this.clearAndHide();
                }
            } else {
                this.typedObject = null;
                this.clearAndHide();
            }
        }
    }

    public void clearAndHide() {
        this.textField.setText(null);
        this.setVisible(false);
    }

    public void setText(String pString) {
        this.textField.setText(pString);
    }
}

