/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm;

import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.ColorFont;
import fr.dbe.util.ihm.JFontChooser;
import fr.dbe.util.ihm.Messages;
import fr.dbe.util.ihm.Utils;
import java.awt.Color;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;

public class JFontSel
extends Box {
    protected static final String PROPERTY_FONT = Messages.getString("JFontSel.0");
    private final JButton fBouton;
    private final JLabel fLibBouton;
    private Font fPolice;
    private Color fCouleur;

    public JFontSel(Font pFont, Color pColor) {
        this(pFont, pColor, -1);
    }

    public JFontSel(int pLongueurLibelle) {
        this(Utilitaire.FONT_PLAIN_10, Color.BLACK, pLongueurLibelle);
    }

    public JFontSel() {
        this(-1);
    }

    public JFontSel(Font pFont, Color pColor, int pLongueurLibelle) {
        super(0);
        this.fLibBouton = pLongueurLibelle > 0 ? Utils.createLabel(Messages.getString("JFontSel.1"), pLongueurLibelle) : Utils.createLabel(Messages.getString("JFontSel.2"));
        this.fBouton = Utils.createButton(Messages.getString("JFontSel.3"));
        this.fLibBouton.setLabelFor(this.fBouton);
        this.add(this.fLibBouton);
        this.add(this.fBouton);
        this.add(Box.createHorizontalGlue());
        this.fBouton.addActionListener(pActionEvent -> {
            ColorFont f = JFontChooser.showDialog(Utils.getParentFrame(this), Messages.getString("JFontSel.4"), new ColorFont(this.fPolice, this.fCouleur));
            ColorFont old = new ColorFont(this.fPolice, this.fCouleur);
            this.setPolice(f.getFont());
            this.setCouleur(f.getColor());
            this.firePropertyChange(PROPERTY_FONT, old, f);
        });
        this.setPolice(pFont);
        this.setCouleur(pColor);
    }

    public Font getPolice() {
        return this.fPolice;
    }

    public void setPolice(Font pPolice) {
        this.fPolice = pPolice;
        this.majApercu();
    }

    public Color getCouleur() {
        return this.fCouleur;
    }

    public void setCouleur(Color pCouleur) {
        this.fCouleur = pCouleur;
        this.majApercu();
    }

    private void majApercu() {
        if (this.fPolice == null || this.fCouleur == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.fPolice.getFamily()).append(", ").append(this.fPolice.getSize());
        sb = new StringBuffer();
        sb.append("<html><div style=\"background-color:#FFFFFF;color:").append(Utilitaire.colorToHtmlColor(this.fCouleur)).append(";").append("font-family:").append(this.fPolice.getFamily()).append(";").append("font-size:").append(this.fPolice.getSize()).append(";");
        if (this.fPolice.isBold()) {
            sb.append("font-weight:bold;");
        }
        if (this.fPolice.isItalic()) {
            sb.append("font-style:italic;");
        }
        sb.append("\" >");
        sb.append("&nbsp;").append(this.fPolice.getFamily()).append(", ").append(this.fPolice.getSize()).append("&nbsp;");
        if (this.fPolice.isBold()) {
            sb.append(Messages.getString("JFontSel.18"));
        }
        if (this.fPolice.isItalic()) {
            sb.append(Messages.getString("JFontSel.19"));
        }
        sb.append("</div></html>");
        this.fBouton.setToolTipText(sb.toString());
        this.fLibBouton.setToolTipText(sb.toString());
        this.setToolTipText(sb.toString());
    }
}

