/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm;

import fr.dbe.util.ihm.BoxAssistant;
import fr.dbe.util.ihm.Messages;
import fr.dbe.util.ihm.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class JAssistant
extends JDialog {
    public static final Icon WARNING_ICONE = Utils.chargeIcone("warning.gif", JAssistant.class);
    public static final Icon ERROR_ICONE = Utils.chargeIcone("error.gif", JAssistant.class);
    public static final Icon INFO_ICONE = Utils.chargeIcone("success.gif", JAssistant.class);
    private final JLabel fLibMessage = Utils.createLabel("");
    private final boolean fAppliquer;
    private final List<BoxAssistant> fBoxes = new ArrayList<BoxAssistant>();
    private JButton fBtOk;
    private JButton fBtAnnuler;
    private JButton fBtAppliquer;
    private final transient DocumentListener fDocumentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            JAssistant.this.majBtOk();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JAssistant.this.majBtOk();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JAssistant.this.majBtOk();
        }
    };

    protected JAssistant(Frame pOwner, String pTitre) {
        this(pOwner, pTitre, false);
    }

    protected JAssistant(Dialog pOwner, String pTitre) {
        this(pOwner, pTitre, false);
    }

    protected JAssistant(Frame pOwner, String pTitre, boolean pAppliquer) {
        super(pOwner, pTitre, true);
        this.fAppliquer = pAppliquer;
        this.setLocationRelativeTo(pOwner);
        this.setDefaultCloseOperation(2);
    }

    protected JAssistant(Dialog pOwner, String pTitre, boolean pAppliquer) {
        super(pOwner, pTitre, true);
        this.fAppliquer = pAppliquer;
        this.setLocationRelativeTo(pOwner);
        this.setDefaultCloseOperation(2);
    }

    protected void init() {
        this.getContentPane().setLayout(new BorderLayout());
        Box bHaut = Box.createVerticalBox();
        Box bLib = Box.createHorizontalBox();
        bLib.add(Box.createHorizontalStrut(10));
        bLib.add(this.fLibMessage);
        bLib.add(Box.createHorizontalGlue());
        bHaut.add(Box.createVerticalStrut(10));
        bHaut.add(bLib);
        bHaut.add(Box.createVerticalStrut(10));
        Box bBas = Box.createVerticalBox();
        Box bBoutons = Box.createHorizontalBox();
        bBoutons.add(Box.createHorizontalGlue());
        bBoutons.add(this.getBtOk());
        bBoutons.add(Box.createHorizontalStrut(20));
        this.getBtAppliquer();
        if (this.fAppliquer) {
            bBoutons.add(this.getBtAppliquer());
            bBoutons.add(Box.createHorizontalStrut(20));
        }
        bBoutons.add(this.getBtAnnuler());
        bBoutons.add(Box.createHorizontalGlue());
        Component br = this.getBottomRightComponent();
        if (br != null) {
            bBoutons.add(br);
        }
        bBas.add(Box.createVerticalStrut(10));
        bBas.add(bBoutons);
        bBas.add(Box.createVerticalStrut(10));
        this.getContentPane().add((Component)bHaut, "North");
        Box bMilieu = this.getBox();
        bMilieu.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.GRAY));
        this.getContentPane().add((Component)bMilieu, "Center");
        this.getContentPane().add((Component)bBas, "South");
        Utils.setEscBouton(this.getRootPane(), this.fBtAnnuler);
        this.majBtOk();
        this.pack();
    }

    public void bindValidation(JTextField pTextField) {
        pTextField.getDocument().addDocumentListener(this.fDocumentListener);
    }

    protected Box getBox() {
        return Box.createHorizontalBox();
    }

    private JButton getBtOk() {
        if (this.fBtOk == null) {
            this.fBtOk = Utils.createButton("OK");
            this.fBtOk.setEnabled(false);
            this.getRootPane().setDefaultButton(this.fBtOk);
            this.fBtOk.addActionListener(pE -> {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.fBtOk.setEnabled(false);
                this.fBtAppliquer.setEnabled(false);
                this.fBtAnnuler.setEnabled(false);
                SwingUtilities.invokeLater(() -> {
                    this.doOk();
                    this.fBtOk.setEnabled(true);
                    this.fBtAnnuler.setEnabled(true);
                    this.fBtAppliquer.setEnabled(true);
                    this.setCursor(Cursor.getDefaultCursor());
                });
            });
        }
        return this.fBtOk;
    }

    private JButton getBtAppliquer() {
        if (this.fBtAppliquer == null) {
            this.fBtAppliquer = Utils.createButton(Messages.getString("JAssistant.5"));
            this.fBtAppliquer.setEnabled(false);
            this.fBtAppliquer.addActionListener(pE -> {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.fBtOk.setEnabled(false);
                this.fBtAppliquer.setEnabled(false);
                this.fBtAnnuler.setEnabled(false);
                SwingUtilities.invokeLater(() -> {
                    this.doAppliquer();
                    this.fBtAppliquer.setEnabled(true);
                    this.fBtOk.setEnabled(true);
                    this.fBtAnnuler.setEnabled(true);
                    this.setCursor(Cursor.getDefaultCursor());
                });
            });
        }
        return this.fBtAppliquer;
    }

    private JButton getBtAnnuler() {
        if (this.fBtAnnuler == null) {
            this.fBtAnnuler = Utils.createButton(Messages.getString("JAssistant.6"));
            Utils.setEscBouton(this.getRootPane(), this.fBtAnnuler);
            this.fBtAnnuler.addActionListener(e -> this.doAnnuler());
        }
        return this.fBtAnnuler;
    }

    protected abstract void doOk();

    protected void doAppliquer() {
    }

    protected abstract void doAnnuler();

    protected abstract void majBtOk();

    public void error(String pMessage) {
        this.fLibMessage.setIcon(ERROR_ICONE);
        if (this.fLibMessage.getToolTipText() != null) {
            this.fLibMessage.setToolTipText(this.fLibMessage.getToolTipText().replace("</body></html>", pMessage + "<br></body></html>"));
        }
        if (!this.fLibMessage.getText().contains(pMessage == null ? "" : pMessage)) {
            this.fLibMessage.setText(this.formatHtml(this.fLibMessage.getText() + " " + pMessage));
        }
        this.fBtOk.setEnabled(false);
        this.fBtAppliquer.setEnabled(false);
    }

    public void error(String pMessage, JComponent pComposant) {
        this.fLibMessage.setIcon(ERROR_ICONE);
        if (!this.fLibMessage.getText().contains(pMessage)) {
            this.fLibMessage.setText(this.formatHtml(this.fLibMessage.getText() + " " + pMessage));
        }
        this.fBtOk.setEnabled(false);
        this.fBtAppliquer.setEnabled(false);
        pComposant.setForeground(Color.RED);
    }

    public void warning(String pMessage) {
        this.fLibMessage.setIcon(WARNING_ICONE);
        this.fLibMessage.setText(this.formatHtml(pMessage));
        this.fBtOk.setEnabled(true);
        this.fBtAppliquer.setEnabled(true);
    }

    private String formatHtml(String pMessage) {
        return "<html>" + pMessage.replace("<html>", "").replace("</html>", "").replace("\n", "<br/>") + "</html>";
    }

    public void info(String pMessage) {
        this.fLibMessage.setIcon(INFO_ICONE);
        this.fLibMessage.setText(pMessage);
        this.fLibMessage.setToolTipText("<html><body></body></html>");
        this.fBtOk.setEnabled(true);
        this.fBtAppliquer.setEnabled(true);
    }

    public boolean messageIsEmpty() {
        return this.fLibMessage.getText().isEmpty();
    }

    public boolean isOk() {
        return this.fBtOk.isEnabled();
    }

    public void addBox(BoxAssistant pBox) {
        this.fBoxes.add(pBox);
    }

    public void validateBoxes() {
        this.info("");
        for (BoxAssistant b : this.fBoxes) {
            b.majbtOk();
        }
    }

    public void doOkBoxes() {
        this.info("");
        for (BoxAssistant b : this.fBoxes) {
            b.doOk();
        }
    }

    protected List<BoxAssistant> getBoxes() {
        return this.fBoxes;
    }

    public Component getBottomRightComponent() {
        return null;
    }
}

