/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import javax.imageio.ImageIO;

public class Utilitaire {
    public static final double LOG_10 = Math.log(10.0);
    public static final Font FONT_PLAIN_8 = new Font("", 0, 8);
    public static final Font FONT_PLAIN_9 = new Font("", 0, 9);
    public static final Font FONT_PLAIN_10 = new Font("", 0, 10);
    public static final Font FONT_PLAIN_11 = new Font("", 0, 11);
    public static final Font FONT_PLAIN_12 = new Font("", 0, 12);
    public static final Font FONT_BOLD_10 = new Font("", 1, 10);
    public static final Font FONT_BOLD_11 = new Font("", 1, 11);
    public static final Font FONT_BOLD_12 = new Font("", 1, 12);
    public static final Font FONT_DEFAUT = FONT_PLAIN_11;
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static Random rand;

    public static void initRand(long seed) {
        rand = new Random(seed);
    }

    public static double alea(double min, double max) {
        return (double)Math.round(1000.0 * (Math.random() * (max - min) + min)) / 1000.0;
    }

    public static double alea(Random r, double min, double max) {
        return (double)Math.round(1000.0 * (r.nextDouble() * (max - min) + min)) / 1000.0;
    }

    public static double alea(double val) {
        return (double)rand.nextFloat() < 0.5 ? -val : val;
    }

    public static String valeurChaine(double pValeur, int pNbChiffresSignificatifs) {
        if (Double.isNaN(pValeur)) {
            return "NaN";
        }
        if (Double.isInfinite(pValeur)) {
            return "\u221e";
        }
        if (pValeur == 0.0) {
            return "0";
        }
        if ((double)((long)pValeur) == pValeur && Math.abs(pValeur) < 1.0E7) {
            return Long.toString((long)pValeur);
        }
        if (pValeur < 1.0 && pValeur >= 0.01) {
            double pow = Math.pow(10.0, pNbChiffresSignificatifs);
            String mantisse = String.valueOf((double)Math.round(pValeur * pow) / pow);
            return mantisse.substring(0, Math.min(mantisse.length(), pNbChiffresSignificatifs + (pValeur < 0.0 ? 3 : 2)));
        }
        int e = (int)(Math.log(pValeur) / Math.log(10.0));
        if (e < 0) {
            --e;
        } else if (e < 4) {
            e = 0;
        }
        double exp = Math.pow(10.0, -e);
        double pow = Math.pow(10.0, pNbChiffresSignificatifs);
        String mant = String.valueOf((double)Math.round((pValeur *= exp) * pow) / pow);
        return mant.substring(0, Math.min(mant.length(), pNbChiffresSignificatifs + (pValeur < 0.0 ? 3 : 2))) + (String)(e != 0 ? "E" + e : "");
    }

    public static void normaliser(double[] t) {
        int i;
        double max = 0.0;
        for (i = t.length - 1; i >= 0; --i) {
            max = Math.max(Math.abs(t[i]), max);
        }
        if (max == 0.0) {
            return;
        }
        i = t.length - 1;
        while (i >= 0) {
            int n = i--;
            t[n] = t[n] / max;
        }
    }

    public static boolean supprimeDirNonVide(File pDir) {
        if (pDir == null) {
            return true;
        }
        if (!pDir.exists()) {
            return true;
        }
        File[] fichiers = pDir.listFiles();
        if (fichiers == null) {
            return true;
        }
        for (int i = fichiers.length - 1; i >= 0; --i) {
            if (!(fichiers[i].isDirectory() ? !Utilitaire.supprimeDirNonVide(fichiers[i]) : !fichiers[i].delete())) continue;
            return false;
        }
        pDir.delete();
        return !pDir.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copier(File pSource, File pCible) {
        boolean resultat = false;
        FileInputStream sourceFile = null;
        FileOutputStream destinationFile = null;
        try {
            int nbLecture;
            pCible.createNewFile();
            sourceFile = new FileInputStream(pSource);
            destinationFile = new FileOutputStream(pCible);
            byte[] buffer = new byte[(int)Math.min(pSource.length(), 0x100000L)];
            while ((nbLecture = sourceFile.read(buffer)) > 0) {
                destinationFile.write(buffer, 0, nbLecture);
            }
            resultat = true;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                sourceFile.close();
            }
            catch (Exception exception) {}
            try {
                destinationFile.close();
            }
            catch (Exception exception) {}
        }
        return resultat;
    }

    public static boolean copierRecursif(File pSource, File pCible) {
        if (!pCible.exists() ? !pCible.mkdir() : !pCible.isDirectory()) {
            return false;
        }
        List<File> fichiers = Utilitaire.listeFiles(pSource, true);
        if (fichiers == null) {
            return true;
        }
        String repSource = pSource.getAbsolutePath() + System.getProperty("file.separator");
        String repCible = pCible.getAbsolutePath() + System.getProperty("file.separator");
        for (File f : fichiers) {
            File dest = new File(repCible + f.getAbsolutePath().substring(repSource.length()));
            if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                return false;
            }
            if (Utilitaire.copier(f, dest)) continue;
            return false;
        }
        return true;
    }

    public static List<File> listeFiles(File pDir, boolean pRecursif) {
        if (!pDir.isDirectory()) {
            return null;
        }
        ArrayList<File> liste = new ArrayList<File>();
        pDir.listFiles(pFile -> {
            if (pFile.isDirectory() && pRecursif) {
                List<File> lst = Utilitaire.listeFiles(pFile, pRecursif);
                if (lst != null) {
                    liste.addAll(lst);
                }
            } else {
                liste.add(pFile);
            }
            return false;
        });
        return liste;
    }

    public static void saveImage(String pFormat, Component pComposant, File pFichier) throws IOException {
        BufferedImage img = new BufferedImage(pComposant.getWidth(), pComposant.getHeight(), 1);
        Graphics2D gr = img.createGraphics();
        pComposant.paint(gr);
        gr.dispose();
        ImageIO.write((RenderedImage)img, pFormat, pFichier);
    }

    public static void saveEncode(String pNomFic, String pChaine, String pEncoding) throws IOException {
        FileOutputStream fos = new FileOutputStream(pNomFic);
        FileChannel channelOut = fos.getChannel();
        CharsetEncoder encoder = Charset.forName(pEncoding).newEncoder();
        channelOut.write(encoder.encode(CharBuffer.wrap(pChaine)));
        channelOut.close();
        fos.flush();
        fos.close();
    }

    public static String colorToHtmlColor(Color couleur) {
        return ("#" + Utilitaire.toHexStringSur2(couleur.getRed()) + Utilitaire.toHexStringSur2(couleur.getGreen()) + Utilitaire.toHexStringSur2(couleur.getBlue())).toUpperCase();
    }

    private static String toHexStringSur2(int val) {
        String res = Integer.toHexString(val);
        return res.length() >= 2 ? res : "0" + res;
    }

    public static String cheminRelatif(File pRacine, File pFichier) {
        return Utilitaire.cheminRelatif(pRacine, pFichier, true);
    }

    public static String cheminRelatif(File pRacine, File pFichier, boolean fMustExists) {
        if (fMustExists && !pFichier.exists() || !pRacine.exists() || !pRacine.isDirectory()) {
            return null;
        }
        try {
            int iFichier;
            String[] racinelist = pRacine.getCanonicalPath().replace(File.separatorChar, '/').split("/");
            String[] ficList = pFichier.getCanonicalPath().replace(File.separatorChar, '/').split("/");
            StringBuilder chemin = new StringBuilder();
            int iRacine = 0;
            for (iFichier = 0; iRacine < racinelist.length && iFichier < ficList.length && racinelist[iRacine].equals(ficList[iFichier]); ++iRacine, ++iFichier) {
            }
            while (iRacine < racinelist.length) {
                chemin.append("..").append(File.separator);
                ++iRacine;
            }
            while (iFichier < ficList.length - 1) {
                chemin.append(ficList[iFichier]).append(File.separator);
                ++iFichier;
            }
            if (iFichier < ficList.length) {
                chemin.append(ficList[ficList.length - 1]);
            }
            if (chemin.toString().endsWith(File.separator)) {
                chemin.deleteCharAt(chemin.length() - 1);
            }
            if (!fMustExists || pFichier.exists() == new File(pRacine + File.separator + chemin).exists()) {
                return chemin.toString();
            }
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static boolean fils(File pRepBase, File pFichier) {
        if (pRepBase == null || pFichier == null || pRepBase.equals(pFichier)) {
            return false;
        }
        String repBase = pRepBase.getAbsolutePath();
        String chemin = pFichier.getAbsolutePath();
        return chemin.startsWith(repBase);
    }

    public static double parseDouble(String pChaine) {
        if (pChaine == null) {
            throw new NumberFormatException("Null value");
        }
        if ((pChaine = pChaine.trim()).length() == 0) {
            return 0.0;
        }
        if (pChaine.startsWith("+") && pChaine.length() > 1) {
            pChaine = pChaine.substring(1);
        }
        return Double.parseDouble(pChaine.replace(',', '.'));
    }

    public static double parseDouble(String pChaine, double pValeurDefaut) {
        if (pChaine == null) {
            return pValeurDefaut;
        }
        if ((pChaine = pChaine.trim()).length() == 0) {
            return 0.0;
        }
        if (pChaine.startsWith("+") && pChaine.length() > 1) {
            pChaine = pChaine.substring(1);
        }
        try {
            return Double.parseDouble(pChaine.replace(',', '.'));
        }
        catch (NumberFormatException ex) {
            return pValeurDefaut;
        }
    }

    public static int parseInt(String pChaine) {
        if (pChaine == null) {
            throw new NumberFormatException("Null value");
        }
        if ((pChaine = pChaine.trim()).length() == 0) {
            return 0;
        }
        if (pChaine.startsWith("+") && pChaine.length() > 1) {
            pChaine = pChaine.substring(1);
        }
        return Integer.parseInt(pChaine);
    }

    public static boolean parseBoolean(String pChaine) {
        if (pChaine == null) {
            throw new NumberFormatException("Null value");
        }
        if ((pChaine = pChaine.trim()).length() == 0) {
            return false;
        }
        return pChaine.equalsIgnoreCase("true");
    }

    public static int parseInt(String pChaine, int pValeurDefaut) {
        if (pChaine == null) {
            return pValeurDefaut;
        }
        if ((pChaine = pChaine.trim()).length() == 0) {
            return 0;
        }
        if (pChaine.startsWith("+") && pChaine.length() > 1) {
            pChaine = pChaine.substring(1);
        }
        try {
            return Integer.parseInt(pChaine);
        }
        catch (NumberFormatException ex) {
            return pValeurDefaut;
        }
    }

    public static double log10(double x) {
        return Math.log(x) / LOG_10;
    }

    public static double getMin(double[] pTableau) {
        double res = pTableau[0];
        for (int i = 1; i < pTableau.length; ++i) {
            res = Math.min(res, pTableau[i]);
        }
        return res;
    }

    public static double getMax(double[] pTableau) {
        double res = pTableau[0];
        for (int i = 1; i < pTableau.length; ++i) {
            res = Math.max(res, pTableau[i]);
        }
        return res;
    }

    public static Date getDateGMT() {
        Calendar calGMT = Calendar.getInstance();
        TimeZone tz = TimeZone.getDefault();
        return new Date(calGMT.getTimeInMillis() - (long)tz.getOffset(calGMT.getTime().getTime()));
    }

    public static String toString(double[] pTableau, String pSeparateur, String pDebut, String pFin) {
        return Utilitaire.toString(pTableau, pSeparateur, pDebut, pFin, pTableau.length);
    }

    public static String toString(double[] pTableau, String pSeparateur, String pDebut, String pFin, int pNbElements) {
        StringBuilder s = new StringBuilder(20 + 30 * pTableau.length);
        s.append(pDebut);
        for (int i = 0; i < pNbElements - 1; ++i) {
            s.append(pTableau[i]).append(pSeparateur);
        }
        if (pNbElements > 0) {
            s.append(pTableau[pNbElements - 1]);
        }
        s.append(pFin);
        return s.toString();
    }

    public static void openURL(String pUrl) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Runtime.getRuntime().exec(new String[]{"open", pUrl});
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler \"" + pUrl + "\"");
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, pUrl});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void openDocument(String pFichier) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Runtime.getRuntime().exec(new String[]{"open", pFichier});
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler \"" + pFichier + "\"");
            } else {
                Runtime.getRuntime().exec("open \"" + pFichier + "\"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    public static boolean isSolaris() {
        return OS.contains("sunos");
    }

    public static double[] stringToDoubleArray(String pString, String pSeparator) throws NumberFormatException {
        if (pString.isEmpty()) {
            return new double[0];
        }
        String[] sTab = pString.split(pSeparator);
        double[] res = new double[sTab.length];
        int i = 0;
        for (String s : sTab) {
            res[i++] = Double.parseDouble(s.replace(',', '.'));
        }
        return res;
    }

    public static String format(double pValue) {
        if (pValue == 0.0) {
            return "0";
        }
        if (Math.abs(pValue) < 0.1) {
            return String.format("%E", pValue);
        }
        return String.format("%f", pValue);
    }

    public static String readFully(InputStream in) throws IOException {
        int len;
        StringWriter sw = new StringWriter();
        byte[] b = new byte[0x100000];
        while ((len = in.read(b)) >= 0) {
            sw.write(new String(b, 0, len));
        }
        in.close();
        return sw.toString();
    }
}

