/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

import fr.dbe.util.commun.JavaSourceFromString;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public class InMemoryCompiler {
    public static Class compile(String pCode) throws Exception {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new Exception("Compilateur introuvable !");
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        int debut = pCode.indexOf("public class");
        int fin = pCode.indexOf(" ", (debut += "public class ".length()) + 1);
        String nomClasse = pCode.substring(debut, fin);
        JavaSourceFromString file = new JavaSourceFromString(nomClasse, pCode);
        List<JavaFileObject> compilationUnits = Arrays.asList(file);
        JavaCompiler.CompilationTask task = compiler.getTask(null, null, diagnostics, null, null, compilationUnits);
        boolean success = task.call();
        StringBuilder err = new StringBuilder();
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            err.append("Erreur ligne ").append(diagnostic.getLineNumber()).append(" colonne ").append(diagnostic.getColumnNumber()).append(" : ").append(diagnostic.getMessage(null)).append("\n");
        }
        if (success) {
            URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{new File("").toURI().toURL()});
            return Class.forName(nomClasse, true, classLoader);
        }
        throw new Exception(err.toString());
    }
}

