/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm.propertybox;

import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.Utils;
import fr.dbe.util.ihm.propertybox.ListItem;
import fr.dbe.util.ihm.propertybox.PropertyBox;
import fr.dbe.util.ihm.propertybox.PropertyBoxFactory;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.event.ChangeListener;

public class JComboBoxPlusDetail<T>
extends Box {
    private final JComboBox fComboBox;
    private final Box fDetailBox;
    private final ChangeListener fChangeListener;
    private List<ItemListener> fItemListeners = new ArrayList<ItemListener>();

    public JComboBoxPlusDetail(String pLibelle, Map<T, PropertyBox<? extends T>> pMap, ChangeListener pChangeListener) {
        super(1);
        this.fChangeListener = pChangeListener;
        ArrayList<T> l = new ArrayList<T>(pMap.keySet());
        l.sort(Comparator.comparing(Object::toString));
        Vector v = new Vector();
        for (Object item : l) {
            PropertyBoxFactory.getInstance().register(item.getClass(), pMap.get(item));
            v.add(new ListItem(item));
        }
        this.fComboBox = new JComboBox(v);
        this.fComboBox.setFont(Utilitaire.FONT_DEFAUT);
        this.fDetailBox = Box.createHorizontalBox();
        this.add(Utils.createHorizontalBox(0, Utils.createLabel(pLibelle), this.fComboBox));
        this.add(Box.createVerticalStrut(3));
        this.add(Utils.createHorizontalBox(0, Box.createHorizontalStrut(10), this.fDetailBox));
        this.add(Box.createVerticalStrut(3));
        this.add(Box.createVerticalGlue());
        this.fComboBox.addItemListener(pItemEvent -> {
            if ((pItemEvent.getStateChange() & 1) == 1) {
                this.setSelectedItem(((ListItem)pItemEvent.getItem()).getItem());
            }
        });
        ChangeListener changeListener = e -> {
            this.fireItemChanged();
            this.fComboBox.repaint();
        };
        for (ListItem listItem : v) {
            listItem.getPropertyBox().addChangeListener(this.fChangeListener);
            listItem.getPropertyBox().addChangeListener(changeListener);
        }
    }

    public T getSelectedItem() {
        PropertyBox prop = ((ListItem)this.fComboBox.getSelectedItem()).getPropertyBox();
        if (prop.isOk()) {
            return prop.getItem();
        }
        return null;
    }

    public void setSelectedItem(T pItem) {
        this.fComboBox.setSelectedItem(new ListItem<T>(pItem));
        ((ListItem)this.fComboBox.getSelectedItem()).setItem(pItem);
        this.fDetailBox.removeAll();
        this.fDetailBox.add(((ListItem)this.fComboBox.getSelectedItem()).getPropertyBox());
        this.fChangeListener.stateChanged(null);
        this.validate();
        this.repaint();
    }

    public String getErreurMsg() {
        return ((ListItem)this.fComboBox.getSelectedItem()).getPropertyBox().getErreurMsg();
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.fComboBox.setEnabled(pEnabled);
        ((ListItem)this.fComboBox.getSelectedItem()).getPropertyBox().setEnabled(pEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemListener(ItemListener pListener) {
        JComboBoxPlusDetail jComboBoxPlusDetail = this;
        synchronized (jComboBoxPlusDetail) {
            if (this.fItemListeners == null) {
                this.fItemListeners = new ArrayList<ItemListener>();
            }
        }
        this.fItemListeners.add(pListener);
    }

    public void removeItemListener(ItemListener pListener) {
        this.fItemListeners.remove(pListener);
    }

    private void fireItemChanged() {
        for (ItemListener list : this.fItemListeners) {
            list.itemStateChanged(null);
        }
    }
}

