/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm;

import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.HorizontalLabelPosition;
import fr.dbe.util.ihm.JButtonColor;
import fr.dbe.util.ihm.JTextFieldSel;
import fr.dbe.util.ihm.Messages;
import fr.dbe.util.ihm.VerticalLabelPosition;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class Utils {
    public static JTextArea createTextArea(String text) {
        JTextArea mle = new JTextArea(text);
        mle.setFont(Utilitaire.FONT_DEFAUT);
        return mle;
    }

    public static JTextArea createTextArea(String text, int length) {
        JTextArea mle = Utils.createTextArea(text);
        mle.setMaximumSize(new Dimension(length, 40));
        mle.setPreferredSize(new Dimension(length, 40));
        mle.setMinimumSize(new Dimension(length, 40));
        return mle;
    }

    public static JButton createButton(String text) {
        JButton bt = new JButton(text);
        bt.setFont(Utilitaire.FONT_DEFAUT);
        bt.setOpaque(false);
        return bt;
    }

    public static JButton createButton(Action pAction) {
        JButton bt = new JButton(pAction);
        bt.setFont(Utilitaire.FONT_DEFAUT);
        bt.setOpaque(false);
        return bt;
    }

    public static JButton createButton(String text, int length) {
        JButton bt = Utils.createButton(text);
        bt.setMinimumSize(new Dimension(length, 20));
        bt.setMaximumSize(new Dimension(length, 20));
        bt.setPreferredSize(new Dimension(length, 20));
        return bt;
    }

    public static JLabel createLabel(String text) {
        JLabel lib = new JLabel(text);
        lib.setFont(Utilitaire.FONT_DEFAUT);
        lib.setOpaque(false);
        return lib;
    }

    public static JLabel createLabel(String text, int length) {
        JLabel lib = Utils.createLabel(text);
        lib.setMinimumSize(new Dimension(length, 20));
        lib.setMaximumSize(new Dimension(length, 20));
        lib.setPreferredSize(new Dimension(length, 20));
        lib.setOpaque(false);
        return lib;
    }

    public static JRadioButton createRadioButton(String text) {
        JRadioButton rb = new JRadioButton(text);
        rb.setFont(Utilitaire.FONT_DEFAUT);
        rb.setOpaque(false);
        return rb;
    }

    public static JRadioButton createRadioButton(String text, int length) {
        JRadioButton rb = Utils.createRadioButton(text);
        rb.setMinimumSize(new Dimension(length, 20));
        rb.setMaximumSize(new Dimension(length, 20));
        rb.setPreferredSize(new Dimension(length, 20));
        rb.setOpaque(false);
        return rb;
    }

    public static JCheckBox createCheckBox(String text) {
        JCheckBox cb = new JCheckBox(text);
        cb.setFont(Utilitaire.FONT_DEFAUT);
        cb.setOpaque(false);
        return cb;
    }

    public static JComboBox createComboBox(int length) {
        JComboBox cb = Utils.createComboBox();
        cb.setMinimumSize(new Dimension(length, 22));
        cb.setMaximumSize(new Dimension(length, 22));
        cb.setPreferredSize(new Dimension(length, 22));
        return cb;
    }

    public static JComboBox createComboBox() {
        JComboBox cb = new JComboBox();
        cb.setFont(Utilitaire.FONT_DEFAUT);
        cb.setOpaque(false);
        return cb;
    }

    public static JCheckBox createCheckBox(String text, int length) {
        JCheckBox cb = Utils.createCheckBox(text);
        cb.setMinimumSize(new Dimension(length, 20));
        cb.setMaximumSize(new Dimension(length, 20));
        cb.setPreferredSize(new Dimension(length, 20));
        cb.setOpaque(false);
        return cb;
    }

    public static JTextFieldSel createTextFieldSel(String text) {
        JTextFieldSel sle = new JTextFieldSel(text);
        sle.setFont(Utilitaire.FONT_DEFAUT);
        return sle;
    }

    public static JTextFieldSel createTextFieldSel(String text, int length) {
        JTextFieldSel sle = Utils.createTextFieldSel(text);
        int height = (int)sle.getMinimumSize().getHeight();
        sle.setMaximumSize(new Dimension(length, height));
        sle.setPreferredSize(new Dimension(length, height));
        sle.setMinimumSize(new Dimension(length, height));
        return sle;
    }

    public static JButtonColor createButtonColor() {
        JButtonColor bt = new JButtonColor(Color.RED);
        bt.setPreferredSize(new Dimension(50, 24));
        bt.setMaximumSize(new Dimension(50, 24));
        bt.setMinimumSize(new Dimension(50, 24));
        bt.setOpaque(false);
        return bt;
    }

    public static Box createRadioButtonGroupWithLib(String pLibelle, int pLongueurLibelle, JRadioButton ... radios) {
        Box b = Box.createHorizontalBox();
        JLabel lib = Utils.createLabel(pLibelle + " : ", pLongueurLibelle);
        ButtonGroup bg = new ButtonGroup();
        b.add(lib);
        for (JRadioButton rb : radios) {
            bg.add(rb);
            b.add(rb);
        }
        b.add(Box.createHorizontalGlue());
        return b;
    }

    public static Box createHorizontalBox(int pEcartement, Component ... components) {
        return Utils.createHorizontalBox(pEcartement, true, components);
    }

    public static Box createHorizontalBox(int pEcartement, boolean pGlue, Component ... components) {
        Box b = Box.createHorizontalBox();
        for (Component comp : components) {
            if (pEcartement > 0) {
                b.add(Box.createRigidArea(new Dimension(pEcartement, 0)));
            }
            b.add(comp);
        }
        b.add(Box.createRigidArea(new Dimension(pEcartement, 0)));
        if (pGlue) {
            b.add(Box.createHorizontalGlue());
        }
        return b;
    }

    public static Box createVerticalBox(int pEcartement, Component ... components) {
        return Utils.createVerticalBox(pEcartement, true, components);
    }

    public static Box createVerticalBox(int pEcartement, boolean pGlue, Component ... components) {
        Box b = Box.createVerticalBox();
        for (Component comp : components) {
            b.add(Box.createRigidArea(new Dimension(0, pEcartement)));
            b.add(comp);
        }
        b.add(Box.createRigidArea(new Dimension(0, pEcartement)));
        if (pGlue) {
            b.add(Box.createVerticalGlue());
        }
        return b;
    }

    public static void setEscBouton(JRootPane pRootPane, final JButton pBtAnnuler) {
        InputMap inputMap = pRootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "escPressed");
        pRootPane.getActionMap().put("escPressed", new AbstractAction("escPressed"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                pBtAnnuler.doClick();
            }
        });
    }

    public static void setEscAction(JRootPane pRootPane, Action pAction) {
        InputMap inputMap = pRootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "escPressed");
        pRootPane.getActionMap().put("escPressed", pAction);
    }

    public static ImageIcon chargeIcone(String nom, Class<?> c) {
        URL url = c.getResource("images/" + nom);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public static Image chargeImage(String pImageName, Class<?> pClass) {
        ImageIcon imic = Utils.chargeIcone(pImageName, pClass);
        return imic == null ? null : imic.getImage();
    }

    public static void erreur(String message) {
        JOptionPane.showMessageDialog(null, message, Messages.getString("Utils.7"), 0);
    }

    public static void erreur(Throwable t) {
        JOptionPane.showMessageDialog(null, t.getMessage(), Messages.getString("Utils.8"), 0);
    }

    public static Frame getParentFrame(Component pComponent) {
        while (pComponent != null && !(pComponent instanceof Frame)) {
            pComponent = pComponent.getParent();
        }
        return (Frame)pComponent;
    }

    public static void scrollToRow(JTable table, int row) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(row, 0, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        if (!viewport.getVisibleRect().contains(rect)) {
            viewport.scrollRectToVisible(rect);
        }
    }

    public static Rectangle drawLibelleHtml(Graphics pGraphics, int pX, int pY, String pLabel, HorizontalLabelPosition pHorizontalPosition, VerticalLabelPosition pVerticalPosition) {
        return Utils.drawLibelleHtml(pGraphics, pX, pY, pLabel, pHorizontalPosition, pVerticalPosition, null, null);
    }

    public static Rectangle drawLibelleHtml(Graphics pGraphics, int pX, int pY, String pLabel, HorizontalLabelPosition pHorizontalPosition, VerticalLabelPosition pVerticalPosition, Color pBackgroundColor) {
        return Utils.drawLibelleHtml(pGraphics, pX, pY, pLabel, pHorizontalPosition, pVerticalPosition, pBackgroundColor, null);
    }

    public static Rectangle drawLibelleHtml(final Graphics pGraphics, int pX, int pY, String pLabel, HorizontalLabelPosition pHorizontalPosition, VerticalLabelPosition pVerticalPosition, Color pBackgroundColor, Border pBorder) {
        Rectangle bounds = Utils.libelleHtmlBounds(pGraphics, pX, pY, pLabel, pHorizontalPosition, pVerticalPosition);
        JLabel label = new JLabel((String)(pLabel.startsWith("<html>") ? pLabel : "<html>" + pLabel + " </html>")){

            @Override
            protected void paintComponent(Graphics g) {
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, (float)pGraphics.getColor().getAlpha() / 255.0f);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setComposite(alphaComposite);
                super.paintComponent(g2d);
            }
        };
        Insets insets = label.getInsets();
        bounds.width += 2 + insets.left + insets.right;
        label.setForeground(pGraphics.getColor());
        label.setOpaque(false);
        label.setFont(pGraphics.getFont());
        label.setSize(bounds.width, bounds.height);
        label.setHorizontalAlignment(0);
        if (pBorder != null) {
            label.setBorder(pBorder);
        }
        Color c = pGraphics.getColor();
        pGraphics.translate(bounds.x, bounds.y);
        if (pBackgroundColor != null) {
            pGraphics.setColor(pBackgroundColor);
            pGraphics.fillRect(0, 0, bounds.width, bounds.height);
        }
        label.update(pGraphics);
        pGraphics.translate(-bounds.x, -bounds.y);
        pGraphics.setColor(c);
        return bounds;
    }

    public static Rectangle libelleHtmlBounds(Graphics pGraphics, int pX, int pY, String pLabel, HorizontalLabelPosition pHorizontalPosition, VerticalLabelPosition pVerticalPosition) {
        return Utils.libelleHtmlBounds(pGraphics, pX, pY, pLabel, pHorizontalPosition, pVerticalPosition, pGraphics.getFont());
    }

    public static Rectangle libelleHtmlBounds(Graphics pGraphics, int pX, int pY, String pLabel, HorizontalLabelPosition pHorizontalPosition, VerticalLabelPosition pVerticalPosition, Font pFont) {
        int dx;
        int dy;
        Font oldFont = pGraphics.getFont();
        pGraphics.setFont(pFont);
        int ch = 0;
        if (pLabel.contains("<sub>")) {
            ++ch;
        }
        if (pLabel.contains("<sup>")) {
            ++ch;
        }
        String s = pLabel.replaceAll("<[^>]*>", "").replaceAll("</[^>]*>", "");
        FontMetrics fm = pGraphics.getFontMetrics();
        Rectangle2D textbounds = fm.getStringBounds(s, pGraphics);
        int w = (int)textbounds.getWidth() + 10;
        int h = fm.getMaxAscent() + fm.getMaxDescent() + (int)((double)(ch * fm.getHeight()) * 0.6);
        switch (pVerticalPosition) {
            case MIDDLE: {
                dy = pY - h / 2;
                break;
            }
            case BOTTOM: {
                dy = pY - h;
                break;
            }
            default: {
                dy = pY;
            }
        }
        switch (pHorizontalPosition) {
            case CENTER: {
                dx = pX - w / 2;
                break;
            }
            case RIGHT: {
                dx = pX - w;
                break;
            }
            default: {
                dx = pX;
            }
        }
        pGraphics.setFont(oldFont);
        return new Rectangle(dx, dy, w, h);
    }
}

