/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm;

import fr.dbe.util.ihm.JTextFieldSel;
import fr.dbe.util.ihm.UpdateListener;
import fr.dbe.util.ihm.Utils;
import fr.dbe.util.ihm.validation.IValidable;
import fr.dbe.util.ihm.validation.InputValidator;
import fr.dbe.util.ihm.validation.ValidationListener;
import fr.dbe.util.ihm.validation.ValidationResult;
import fr.dbe.util.ihm.validation.ValidationState;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;

public class JTextFieldWithLabel
extends Box
implements IValidable {
    private final JTextFieldSel fSle;
    private final JLabel fLib;
    private final Set<ValidationListener> fValidationListener;
    private InputValidator fValidator;
    private ValidationResult fValidationResult;

    public JTextFieldWithLabel(String pLibelle, String pTexte, InputValidator pValidator) {
        super(0);
        this.fSle = Utils.createTextFieldSel(pTexte);
        this.fLib = Utils.createLabel(pLibelle + " : ");
        this.fLib.setLabelFor(this.fSle);
        this.add(this.fLib);
        this.add(this.fSle);
        this.add(Box.createHorizontalGlue());
        this.fValidationListener = new HashSet<ValidationListener>();
        this.setValidator(pValidator);
    }

    public JTextFieldWithLabel(String pLibelle, String pTexte, int pLargeurTexte, InputValidator pValidator) {
        super(0);
        this.fSle = Utils.createTextFieldSel(pTexte, pLargeurTexte);
        this.fLib = Utils.createLabel(pLibelle + " : ");
        this.fLib.setLabelFor(this.fSle);
        this.add(this.fLib);
        this.add(this.fSle);
        this.add(Box.createHorizontalGlue());
        this.fValidationListener = new HashSet<ValidationListener>();
        this.setValidator(pValidator);
    }

    public JTextFieldWithLabel(String pLibelle, int pLargeurLibelle, String pTexte, int pLargeurTexte, InputValidator pValidator) {
        super(0);
        this.fSle = Utils.createTextFieldSel(pTexte, pLargeurTexte);
        this.fLib = Utils.createLabel(pLibelle + " : ", pLargeurLibelle);
        this.fLib.setLabelFor(this.fSle);
        this.add(this.fLib);
        this.add(this.fSle);
        this.add(Box.createHorizontalGlue());
        this.fValidationListener = new HashSet<ValidationListener>();
        this.setValidator(pValidator);
    }

    public void addValidationListener(ValidationListener pListener) {
        this.fValidationListener.add(pListener);
    }

    public void removeValidationListener(ValidationListener pListener) {
        this.fValidationListener.remove(pListener);
    }

    public void fireValidated() {
        for (ValidationListener listener : this.fValidationListener) {
            listener.updated(null);
        }
    }

    private void setValidator(InputValidator pValidator) {
        this.fValidator = pValidator;
        this.fValidationResult = new ValidationResult();
        this.getTextField().getDocument().addDocumentListener(new UpdateListener(){

            @Override
            public void textUpdated(DocumentEvent pE) {
                if (JTextFieldWithLabel.this.fValidator != null) {
                    JTextFieldWithLabel.this.valider();
                    JTextFieldWithLabel.this.fLib.setForeground(JTextFieldWithLabel.this.fValidationResult.getState().getColor());
                    JTextFieldWithLabel.this.fLib.setToolTipText(JTextFieldWithLabel.this.fValidationResult.getMessage());
                    JTextFieldWithLabel.this.fireValidated();
                }
            }
        });
    }

    private void valider() {
        this.fValidationResult = this.fValidator.getValidationResult(this.fSle.getText());
    }

    public String getText() {
        return this.fSle.getText();
    }

    public void setText(String pTexte) {
        this.fSle.setText(pTexte);
    }

    public JTextField getTextField() {
        return this.fSle;
    }

    public JLabel getLabel() {
        return this.fLib;
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.fLib.setEnabled(pEnabled);
        this.fSle.setEnabled(pEnabled);
    }

    public void setEditable(boolean pEditable) {
        this.fSle.setEditable(pEditable);
    }

    @Override
    public Map<Component, ValidationResult> getValidationResults() {
        if (this.fValidationResult.getState() == ValidationState.NONE) {
            this.valider();
        }
        HashMap<Component, ValidationResult> map = new HashMap<Component, ValidationResult>();
        map.put(this, this.fValidationResult);
        return map;
    }
}

