/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

public class Intervalle {
    private final int fDebut;
    private final int fFin;
    private final int fTaille;

    public Intervalle(int pDebut, int pFin) {
        this.fDebut = Math.max(0, pDebut);
        this.fFin = pFin;
        this.fTaille = this.fFin - this.fDebut + 1;
    }

    public Intervalle intersection(Intervalle pIntervalle) {
        if (pIntervalle == null) {
            return this;
        }
        return new Intervalle(Math.max(this.fDebut, pIntervalle.fDebut), Math.min(this.fFin, pIntervalle.fFin));
    }

    public int getDebut() {
        return this.fDebut;
    }

    public int getFin() {
        return this.fFin;
    }

    public int getTaille() {
        return this.fTaille;
    }

    public String toString() {
        return "Intervalle [" + this.fDebut + ", " + this.fFin + "] = " + this.fTaille;
    }

    public boolean equals(Object pIntervalle) {
        if (pIntervalle == null) {
            return false;
        }
        if (!(pIntervalle instanceof Intervalle)) {
            return false;
        }
        return ((Intervalle)pIntervalle).fDebut == this.fDebut && ((Intervalle)pIntervalle).fFin == this.fFin;
    }
}

