/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.ITypeDessin;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.xml.XmlUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Ligne
implements ITypeDessin {
    private Stroke fStroke = new BasicStroke(1.0f);

    @Override
    public void dessine(Serie pCourbe, Graphics pG, double pXMin, double pXMax, int pPasAffichage) {
        Plage plage = pCourbe.plageFor(pXMin, pXMax);
        int i0 = plage.getIndiceMin();
        int i1 = plage.getIndiceMax();
        if (i0 >= pCourbe.size()) {
            return;
        }
        Axe axeH = pCourbe.getRepere().getAxeH();
        Axe axeV = pCourbe.getRepere().getAxeV();
        Stroke oldStroke = ((Graphics2D)pG).getStroke();
        ((Graphics2D)pG).setStroke(this.fStroke);
        if (i0 < i1) {
            double x0 = axeH.valToPix(pCourbe.getX(i0));
            double y0 = axeV.valToPix(pCourbe.getY(i0));
            try {
                for (int j = i0 + pPasAffichage; j < i1; j += pPasAffichage) {
                    double x = axeH.valToPix(pCourbe.getX(j));
                    double valY = pCourbe.getY(j);
                    double y = axeV.valToPix(valY);
                    if (Double.isFinite(y) && Double.isFinite(y0)) {
                        pG.setColor(this.getColor(pCourbe, valY));
                        pG.drawLine((int)x0, (int)y0, (int)x, (int)y);
                    }
                    x0 = x;
                    y0 = y;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        ((Graphics2D)pG).setStroke(oldStroke);
    }

    @Override
    public Stroke getStroke() {
        return this.fStroke;
    }

    @Override
    public void setStroke(Stroke pStroke) {
        this.fStroke = pStroke == null ? new BasicStroke(1.0f) : pStroke;
    }

    protected Color getColor(Serie pCourbe, double pY) {
        return pCourbe.getCouleur();
    }

    public Element getDomElement(Document pDoc) {
        Element root = pDoc.createElement(MapXmlGraph.getInstance().getNomElement(ITypeDessin.class));
        root.appendChild(XmlUtils.createStrokeNode((Document)pDoc, (BasicStroke)((BasicStroke)this.fStroke)));
        return root;
    }

    public void setProperties(Node pNoeud) {
        this.setStroke(XmlUtils.getStroke((Node)pNoeud));
    }

    @Override
    public boolean hasFillColor() {
        return false;
    }

    @Override
    public Color getFillColor() {
        return null;
    }

    @Override
    public void setFillColor(Color pCOlor) {
    }

    @Override
    public int getDXMinAff() {
        return 0;
    }

    @Override
    public int getDXMaxAff() {
        return 0;
    }
}

