/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.Direction;
import fr.dbe.graphique.IWidget;
import fr.dbe.graphique.JProprietesGraphique;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.MinSpaceVerifier;
import fr.dbe.graphique.PositionComputer;
import fr.dbe.graphique.PositionGraduation;
import fr.dbe.graphique.Positionnable;
import fr.dbe.graphique.Repartition;
import fr.dbe.graphique.formatter.DecimalFormatter;
import fr.dbe.graphique.formatter.IFormatter;
import fr.dbe.util.commun.Dichotomie;
import fr.dbe.util.commun.ElementListenerHelper;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.commun.Vecteur;
import fr.dbe.util.ihm.SharedFrame;
import fr.dbe.util.xml.IXmlElement;
import fr.dbe.util.xml.XmlUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Graduation
extends MouseInputAdapter
implements IWidget,
Positionnable {
    public static final String PROPERTY_REPARTITION = "repartition";
    public static final String KEY_DRAWING = "drawing";
    public static final String KEY_DRAWN = "drawn";
    public static final String KEY_FORMATTER = "formatter";
    private static final String DOM_REPARTITION = "repartition";
    private static final String DOM_INTERVALLE = "intervalle";
    private static final String DOM_NOMBRE = "nombre";
    private static final String DOM_POSITIONS = "positions";
    private static final String DOM_TAILLE = "taille";
    private static final String DOM_ORIENTATION = "orientation";
    private static final String DOM_VISIBLE = "visible";
    private static final String DOM_MARGE_HAUT = "marge-haut";
    private static final String DOM_MARGE_DROITE = "marge-droite";
    private static final String DOM_MARGE_BAS = "marge-bas";
    private static final String DOM_MARGE_GAUCHE = "marge-gauche";
    private static final String DOM_VALEURS_ENTIERES = "valeurs-entieres";
    private static final String DOM_VALEURS_RONDES = "valeurs-rondes";
    private final Axe fAxe;
    private final ElementListenerHelper fElementListenerHelper = new ElementListenerHelper();
    protected Point fSelectedPoint;
    protected Point fCurrentDrag;
    protected double fZoomDebutDrag;
    protected double fValSelection;
    protected Vecteur fLastDrawingPositions;
    protected boolean fValeursEntieres = false;
    protected boolean fValeursRondes = false;
    protected boolean fDeplacable = true;
    protected PositionGraduation positionGraduation = PositionGraduation.OUT_DRAW_CANVAS;
    private Font fPolice = Utilitaire.FONT_PLAIN_9;
    private Color fCouleur = Color.BLACK;
    private Color fCouleurTexte = Color.BLACK;
    private Repartition fRepartition;
    private double fIntervalle;
    private int fNombre;
    private double[] fPositions;
    private double fOrientation = 0.0;
    private int fTaille = 2;
    private IFormatter fFormatter = new DecimalFormatter();
    private boolean fVisible = true;
    private boolean fAfficheMinMax;
    private boolean fSelected;
    private MinSpaceVerifier fMinSpaceVerifier;
    private Marges fMarges = new Marges(3.0, 3.0, 3.0, 3.0);

    public Graduation(Axe pAxe) {
        this.fAxe = pAxe;
        this.fRepartition = Repartition.NOMBRE;
        this.setNombre(5);
    }

    public static Point2D rotate(double X, double Y, double Xc, double Yc, double A, double pTH) {
        double Xr = Math.round((X - Xc) * Math.cos(A) - (Y - Yc) * Math.sin(A) + Xc);
        double Yr = Math.round((Y - Yc) * Math.cos(A) + (X - Xc) * Math.sin(A) + Yc);
        return new Point2D.Double(Xr, Yr + pTH);
    }

    public static Polygon rotate(Polygon poly, Point pCenter, double pAlpha, double pTH) {
        Polygon res = new Polygon();
        for (int i = 0; i < poly.npoints; ++i) {
            Point2D p = Graduation.rotate(poly.xpoints[i], poly.ypoints[i], pCenter.getX(), pCenter.getY(), pAlpha, pTH);
            res.addPoint((int)p.getX(), (int)p.getY());
        }
        return res;
    }

    public static Polygon rectangleToPolygon(Rectangle rect) {
        if (rect == null) {
            return null;
        }
        Polygon result = new Polygon();
        result.addPoint(rect.x, rect.y);
        result.addPoint(rect.x + rect.width, rect.y);
        result.addPoint(rect.x + rect.width, rect.y + rect.height);
        result.addPoint(rect.x, rect.y + rect.height);
        return result;
    }

    private static double[] fromString(String string) {
        String[] strings = string.replace("[", "").replace("]", "").split(", ");
        double[] result = new double[strings.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Double.parseDouble(strings[i]);
        }
        return result;
    }

    public ElementListenerHelper getElementListenerHelper() {
        return this.fElementListenerHelper;
    }

    public double[] getLastDrawingPositions() {
        return this.fLastDrawingPositions == null ? new double[]{} : this.fLastDrawingPositions.toArray();
    }

    public Font getPolice() {
        return this.fPolice;
    }

    public void setPolice(Font pPolice) {
        this.fPolice = pPolice;
    }

    @Override
    public double getIntervalle() {
        return this.fIntervalle;
    }

    @Override
    public void setIntervalle(double pIntervalle) {
        if (this.getAxe().getMaster() != null) {
            return;
        }
        this.fRepartition = Repartition.INTERVALLE;
        this.fIntervalle = pIntervalle;
        for (Axe axe : this.getAxe().getLinkedAxes()) {
            axe.getGraduation().fIntervalle = this.fIntervalle;
            axe.getGraduation().fRepartition = this.fRepartition;
        }
        this.fElementListenerHelper.fireValueChanged("repartition", (Object)this);
    }

    @Override
    public int getNombre() {
        return this.fNombre;
    }

    @Override
    public void setNombre(int pNombre) {
        if (this.getAxe().getMaster() != null) {
            return;
        }
        this.fRepartition = Repartition.NOMBRE;
        this.fNombre = pNombre;
        for (Axe axe : this.getAxe().getLinkedAxes()) {
            axe.getGraduation().fNombre = this.fNombre;
            axe.getGraduation().fRepartition = this.fRepartition;
        }
        this.fElementListenerHelper.fireValueChanged("repartition", (Object)this);
    }

    public double[] getPositions() {
        return this.fPositions;
    }

    public void setPositions(double[] pPositions) {
        if (this.getAxe().getMaster() != null) {
            return;
        }
        this.fRepartition = Repartition.POSITIONS;
        this.fPositions = pPositions;
        for (Axe axe : this.getAxe().getLinkedAxes()) {
            axe.getGraduation().fPositions = this.fPositions;
            axe.getGraduation().fRepartition = this.fRepartition;
        }
        this.fElementListenerHelper.fireValueChanged("repartition", (Object)this);
    }

    public Color getCouleur() {
        return this.fCouleur;
    }

    public void setCouleur(Color pCouleur) {
        this.fCouleur = pCouleur;
    }

    public int getTaille() {
        return this.fTaille;
    }

    public void setTaille(int pHauteur) {
        if (this.getAxe().getMaster() != null) {
            return;
        }
        this.fTaille = pHauteur;
        for (Axe axe : this.getAxe().getLinkedAxes()) {
            axe.getGraduation().fTaille = this.fTaille;
        }
    }

    protected double[] computePositions(Axe pAxe) {
        Axe axe = pAxe.getMaster() == null ? pAxe : pAxe.getMaster();
        return PositionComputer.compute(this, axe, axe.getPositionAutreAxe(), this.fPositions);
    }

    @Override
    public void dessine(Graphics g) {
        this.getElementListenerHelper().fireValueChanged(KEY_DRAWING, (Object)this);
        this.fLastDrawingPositions = new Vecteur();
        if (!this.fVisible) {
            return;
        }
        double[] positions = this.computePositions(this.fAxe);
        if (positions.length == 0) {
            return;
        }
        g.setColor(this.fCouleur);
        Font oldFont = g.getFont();
        g.setFont(this.getActualFont());
        Polygon[] polygons = new Polygon[2];
        int i = 0;
        double val = this.fFormatter.valueFor(positions[i]);
        String[] sVals = this.fFormatter.format(positions);
        Polygon poly = this.dessineGraduation(g, (int)this.fAxe.valToPix(val), sVals[i], new Polygon[0]);
        if (poly != null) {
            this.fLastDrawingPositions.ajouter(val);
            polygons[0] = poly;
        }
        i = positions.length - 1;
        val = positions[i];
        poly = this.dessineGraduation(g, (int)this.fAxe.valToPix(val), sVals[i], new Polygon[]{polygons[0]});
        if (poly != null) {
            this.fLastDrawingPositions.ajouter(val);
            polygons[1] = poly;
        }
        for (i = 1; i < positions.length - 1; ++i) {
            val = positions[i];
            poly = this.dessineGraduation(g, (int)this.fAxe.valToPix(val), sVals[i], polygons);
            if (poly == null) continue;
            this.fLastDrawingPositions.ajouter(val);
            polygons[0] = poly;
        }
        g.setFont(oldFont);
        this.getElementListenerHelper().fireValueChanged(KEY_DRAWN, (Object)this);
    }

    public boolean isAfficheMinMax() {
        return this.fAfficheMinMax;
    }

    public void setAfficheMinMax(boolean pAfficheMinMax) {
        this.fAfficheMinMax = pAfficheMinMax;
    }

    protected Rectangle2D emprise(Graphics pGraphics) {
        Rectangle2D rect;
        int i;
        if (!this.fVisible) {
            return new Rectangle2D.Double();
        }
        double[] positions = this.computePositions(this.fAxe);
        if (positions.length == 0) {
            return new Rectangle2D.Double();
        }
        Font oldFont = pGraphics.getFont();
        pGraphics.setFont(this.getActualFont());
        ArrayList<Rectangle> rectList = new ArrayList<Rectangle>();
        String[] sVals = this.fFormatter.format(positions);
        Dichotomie dic = new Dichotomie(0, positions.length - 1);
        while (dic.hasNext()) {
            i = dic.next();
            double val = positions[i];
            Polygon poly = this.empriseGraduation(pGraphics, (int)this.fAxe.valToPix(val), sVals[i]);
            if (poly == null) continue;
            Rectangle r = poly.getBounds();
            if (this.intersects(r, rectList)) {
                dic.skip();
                continue;
            }
            rectList.add(r);
        }
        pGraphics.setFont(oldFont);
        if (rectList.isEmpty()) {
            rect = new Rectangle2D.Double();
        } else {
            rect = (Rectangle2D)rectList.get(0);
            for (i = 1; i < rectList.size(); ++i) {
                rect = rect.createUnion((Rectangle2D)rectList.get(i));
            }
        }
        return rect;
    }

    private boolean intersects(Rectangle pRect, List<Rectangle> pRectList) {
        for (Rectangle r : pRectList) {
            if (!pRect.intersects(r)) continue;
            return true;
        }
        return false;
    }

    protected abstract Polygon dessineGraduation(Graphics var1, int var2, String var3, Polygon[] var4);

    protected abstract Polygon empriseGraduation(Graphics var1, int var2, String var3);

    public Element getDomElement(Document doc) {
        Element elt = doc.createElement(MapXmlGraph.getInstance().getNomElement((IXmlElement)this));
        elt.appendChild(XmlUtils.createColorNode((Document)doc, (Color)this.fCouleur));
        elt.appendChild(XmlUtils.createPoliceNode((Document)doc, (Font)this.fPolice));
        elt.setAttribute("repartition", String.valueOf((Object)this.fRepartition));
        switch (this.fRepartition) {
            case NOMBRE: {
                elt.setAttribute(DOM_NOMBRE, String.valueOf(this.fNombre));
                break;
            }
            case INTERVALLE: {
                elt.setAttribute(DOM_INTERVALLE, String.valueOf(this.fIntervalle));
                break;
            }
            case POSITIONS: {
                elt.setAttribute(DOM_POSITIONS, Arrays.toString(this.fPositions));
                break;
            }
        }
        elt.setAttribute(DOM_TAILLE, String.valueOf(this.fTaille));
        elt.setAttribute(DOM_ORIENTATION, String.valueOf(this.fOrientation));
        elt.setAttribute(DOM_VISIBLE, String.valueOf(this.fVisible));
        elt.setAttribute(DOM_MARGE_HAUT, String.valueOf(this.fMarges.getHaut()));
        elt.setAttribute(DOM_MARGE_DROITE, String.valueOf(this.fMarges.getDroite()));
        elt.setAttribute(DOM_MARGE_BAS, String.valueOf(this.fMarges.getBas()));
        elt.setAttribute(DOM_MARGE_GAUCHE, String.valueOf(this.fMarges.getGauche()));
        elt.setAttribute(DOM_VALEURS_ENTIERES, String.valueOf(this.fValeursEntieres));
        elt.setAttribute(DOM_VALEURS_RONDES, String.valueOf(this.fValeursRondes));
        return elt;
    }

    public void setProperties(Node pNoeud) {
        Repartition repartition;
        this.setCouleur(XmlUtils.getColor((Node)pNoeud));
        this.setPolice(XmlUtils.getPolice((Node)pNoeud));
        try {
            repartition = Repartition.valueOf(XmlUtils.getAttributeStringValue((Node)pNoeud, (String)"repartition", (String)"NOMBRE"));
        }
        catch (Exception ex) {
            repartition = Repartition.NOMBRE;
        }
        switch (repartition) {
            case INTERVALLE: {
                this.setIntervalle(XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_INTERVALLE, (double)1.0));
                break;
            }
            case NOMBRE: {
                this.setNombre(XmlUtils.getAttributeIntValue((Node)pNoeud, (String)DOM_NOMBRE, (int)5));
                break;
            }
            case POSITIONS: {
                this.setPositions(Graduation.fromString(XmlUtils.getAttributeStringValue((Node)pNoeud, (String)DOM_POSITIONS, (String)"[]")));
                break;
            }
        }
        this.setTaille(XmlUtils.getAttributeIntValue((Node)pNoeud, (String)DOM_TAILLE, (int)2));
        this.setOrientation(XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_ORIENTATION, (double)0.0));
        this.setVisible(XmlUtils.getAttributeBooleanValue((Node)pNoeud, (String)DOM_VISIBLE, (boolean)true));
        this.setMarges(new Marges(XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_MARGE_HAUT, (double)3.0), XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_MARGE_DROITE, (double)3.0), XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_MARGE_BAS, (double)3.0), XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_MARGE_GAUCHE, (double)3.0)));
        this.setValeursEntieres(XmlUtils.getAttributeBooleanValue((Node)pNoeud, (String)DOM_VALEURS_ENTIERES, (boolean)true));
        this.setValeursRondes(XmlUtils.getAttributeBooleanValue((Node)pNoeud, (String)DOM_VALEURS_RONDES, (boolean)true));
    }

    @Override
    public boolean isVisible() {
        return this.fVisible;
    }

    @Override
    public void setVisible(boolean pVisible) {
        this.fVisible = pVisible;
    }

    public Color getCouleurTexte() {
        return this.fCouleurTexte;
    }

    public void setCouleurTexte(Color pCouleurTexte) {
        this.fCouleurTexte = pCouleurTexte;
    }

    public abstract Direction getDirection();

    public double getOrientation() {
        return this.fOrientation;
    }

    public void setOrientation(double pOrientation) {
        if (this.getAxe().getMaster() != null) {
            return;
        }
        this.fOrientation = pOrientation;
        for (Axe axe : this.getAxe().getLinkedAxes()) {
            axe.getGraduation().fOrientation = this.fOrientation;
        }
    }

    public IFormatter getFormatter() {
        return this.fFormatter;
    }

    public void setFormatter(IFormatter pFormatter) {
        this.fFormatter = pFormatter;
        this.getElementListenerHelper().fireValueChanged(KEY_FORMATTER, (Object)this);
    }

    public Axe getAxe() {
        return this.fAxe;
    }

    @Override
    public boolean isSelected() {
        return this.fSelected;
    }

    @Override
    public void setSelected(boolean pSelected) {
        this.fSelected = pSelected;
    }

    @Override
    public MinSpaceVerifier getMinSpaceVerifier() {
        return this.fMinSpaceVerifier;
    }

    public void setMinSpaceVerifier(MinSpaceVerifier pMinSpaceVerifier) {
        this.fMinSpaceVerifier = pMinSpaceVerifier;
    }

    @Override
    public Repartition getRepartition() {
        return this.fRepartition;
    }

    public boolean intersects(Polygon pPolygon, Polygon[] pPolygons) {
        if (pPolygon == null) {
            return false;
        }
        for (Polygon p : pPolygons) {
            if (p == null) continue;
            Area a = new Area(pPolygon);
            a.intersect(new Area(p));
            if (a.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Marges getMarges() {
        return this.fMarges;
    }

    public void setMarges(Marges pMarges) {
        this.fMarges = pMarges;
    }

    public Font getActualFont() {
        if (this.getAxe().getDessin().getHeight() / this.getPolice().getSize() < 8) {
            return new Font(this.getPolice().getFontName(), this.getPolice().getStyle(), this.getAxe().getDessin().getHeight() / 8);
        }
        return this.getPolice();
    }

    @Override
    public boolean isIntValues() {
        return this.fValeursEntieres;
    }

    public void setValeursEntieres(boolean pValeursEntieres) {
        this.fValeursEntieres = pValeursEntieres;
    }

    @Override
    public boolean isValeursRondes() {
        return this.fValeursRondes;
    }

    public void setValeursRondes(boolean pValeursRondes) {
        this.fValeursRondes = pValeursRondes;
    }

    public PositionGraduation getPositionGraduation() {
        return this.positionGraduation;
    }

    public void setPositionGraduation(PositionGraduation pPositionGraduation) {
        this.positionGraduation = pPositionGraduation;
    }

    @Override
    public void mouseClicked(MouseEvent pE) {
        if (pE.getClickCount() != 1) {
            SharedFrame f = new SharedFrame();
            SwingUtilities.invokeLater(() -> this.lambda$mouseClicked$0((JFrame)f, pE));
        }
    }

    @Override
    public boolean isDeplacable() {
        return this.fDeplacable;
    }

    public void setDeplacable(boolean pDeplacable) {
        this.fDeplacable = pDeplacable;
    }

    private /* synthetic */ void lambda$mouseClicked$0(JFrame f, MouseEvent pE) {
        JProprietesGraphique d = new JProprietesGraphique(f, this.getAxe().getDessin());
        d.selectRepere(this.getAxe().getRepere());
        d.setLocationRelativeTo(pE.getComponent());
        d.setVisible(true);
        f.dispose();
        pE.getComponent().repaint();
    }
}

