/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.utils;

import fr.geonosis.karstmod.viewfx.utils.TextPart;
import java.util.LinkedList;
import java.util.Queue;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SimpleHtmlHandler
extends DefaultHandler {
    private double fSize;
    private String prevTag = null;
    private boolean prevX;
    private double dy;
    private final FontWeight baseWeight;
    private final FontPosture basePosture;
    private FontWeight weight;
    private FontPosture posture;
    public static final double COEF_SIZE = 0.85;
    public static final double SUB_COEF = 0.3;
    public static final double SUP_COEF = 0.5;
    final Queue<TextPart> queue = new LinkedList<TextPart>();

    public SimpleHtmlHandler(double pSize, FontWeight pWeight, FontPosture pPosture) {
        this.fSize = pSize;
        this.baseWeight = this.weight = pWeight;
        this.basePosture = this.posture = pPosture;
    }

    @Override
    public void startElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws SAXException {
        String tn;
        this.prevX = false;
        switch (tn = pQName.toLowerCase()) {
            case "sub": {
                this.dy += this.fSize * 0.3;
                this.fSize *= 0.85;
                if (!"sup".equals(this.prevTag)) break;
                this.prevX = true;
                break;
            }
            case "sup": {
                this.dy -= this.fSize * 0.5;
                this.fSize *= 0.85;
                if (!"sub".equals(this.prevTag)) break;
                this.prevX = true;
                break;
            }
            case "b": {
                this.weight = FontWeight.BOLD;
                break;
            }
            case "i": {
                this.posture = FontPosture.ITALIC;
            }
        }
    }

    @Override
    public void characters(char[] pCh, int pStart, int pLength) throws SAXException {
        this.queue.add(new TextPart(new String(pCh, pStart, pLength), this.fSize, this.dy, this.prevX, this.weight, this.posture));
        this.prevTag = null;
        this.prevX = false;
    }

    @Override
    public void endElement(String pUri, String pLocalName, String pQName) throws SAXException {
        String tn;
        switch (tn = pQName.toLowerCase()) {
            case "sub": {
                this.fSize *= 1.1764705882352942;
                this.dy -= this.fSize * 0.3;
                break;
            }
            case "sup": {
                this.fSize *= 1.1764705882352942;
                this.dy += this.fSize * 0.5;
                break;
            }
            case "b": {
                this.weight = this.baseWeight;
                break;
            }
            case "i": {
                this.posture = this.basePosture;
            }
        }
        this.prevTag = pQName;
    }

    public Queue<TextPart> getQueue() {
        return this.queue;
    }
}

