/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.utils;

import fr.geonosis.karstmod.modele.Model;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.utils.csv.CSVException;
import fr.geonosis.karstmod.utils.csv.CSVLoader;
import fr.geonosis.karstmod.utils.csv.Column;
import fr.geonosis.karstmod.utils.csv.DataColumn;
import fr.geonosis.karstmod.utils.csv.DataColumnMap;
import fr.geonosis.karstmod.utils.csv.LoadException;
import fr.geonosis.karstmod.utils.csv.parser.DoubleType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javafx.beans.property.ReadOnlyListProperty;

public class ModelInput {
    public static Map<Parameter, double[]> loadParamsOut(String pFilename, Model pModel) throws CSVException, IOException, LoadException {
        ReadOnlyListProperty<Parameter> activeParameters = pModel.getActiveParameters();
        HashMap parameterMap = new HashMap(activeParameters.size());
        HashSet columnSet = new HashSet(activeParameters.size());
        activeParameters.forEach(param -> {
            String columnTitle = param.columnTitle();
            parameterMap.put(columnTitle, param);
            columnSet.add(new Column<Double>(columnTitle, DoubleType.getInstance()));
        });
        DataColumnMap columnMap = CSVLoader.load(pFilename, StandardCharsets.UTF_8, ";", "!", columnSet);
        ArrayList missingTitles = new ArrayList();
        parameterMap.keySet().forEach(title -> {
            if (!columnMap.containsKey((String)title)) {
                missingTitles.add(title);
            }
        });
        if (!missingTitles.isEmpty()) {
            throw new LoadException("Columns not found: " + missingTitles);
        }
        HashMap<Parameter, double[]> result = new HashMap<Parameter, double[]>(activeParameters.size());
        columnMap.entrySet().forEach(entry -> result.put((Parameter)parameterMap.get(entry.getKey()), ((DataColumn)entry.getValue()).getValues().parallelStream().map(o -> (Double)o).mapToDouble(d -> d).toArray()));
        return result;
    }
}

