/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.utils;

import fr.geonosis.karstmod.viewfx.utils.DecimalFormatHelper;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import javafx.scene.control.TextFormatter;

public class DecimalFormatter
extends TextFormatter<Double> {
    public DecimalFormatter() {
        this(-1.7976931348623157E308, Double.MAX_VALUE);
    }

    public DecimalFormatter(double pMin, double pMax) {
        super(c -> {
            try {
                if (c.getControlNewText().isEmpty()) {
                    return c;
                }
                String text = DecimalFormatHelper.preformat(c.getControlNewText()).trim().toUpperCase();
                if ("-".equals(text)) {
                    text = "-0";
                } else if (text.endsWith("E")) {
                    text = text.substring(0, text.length() - 1);
                } else if (text.endsWith("E-")) {
                    text = text.substring(0, text.length() - 2);
                }
                ParsePosition parsePosition = new ParsePosition(0);
                Number object = new DecimalFormat().parse(text, parsePosition);
                if (object == null || parsePosition.getIndex() != text.length()) {
                    return null;
                }
                if (object.doubleValue() > pMax || object.doubleValue() < pMin) {
                    return null;
                }
                return c;
            }
            catch (Exception ex) {
                return null;
            }
        });
    }
}

