/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.draw;

import fr.geonosis.karstmod.modele.Reservoir;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;

public class NoConfigReservoirGroup
extends Group {
    private final Rectangle center;

    public NoConfigReservoirGroup(Reservoir pReservoir, double pWidth, double pHeight) {
        this.center = new Rectangle(pWidth, pHeight);
        this.center.setFill((Paint)new Color(0.7254901960784313, 0.807843137254902, 0.8941176470588236, 1.0));
        Line leftBorder = new Line(0.0, -pHeight / 3.0, 0.0, pHeight);
        leftBorder.setStroke((Paint)Color.BLACK);
        leftBorder.setStrokeWidth(2.0);
        Line rightBorder = new Line(pWidth, -pHeight / 3.0, pWidth, pHeight);
        rightBorder.setStroke((Paint)Color.BLACK);
        rightBorder.setStrokeWidth(2.0);
        Line bottomBorder = new Line(0.0, pHeight, pWidth, pHeight);
        rightBorder.setStroke((Paint)Color.BLACK);
        rightBorder.setStrokeWidth(2.0);
        HtmlTextBox label = new HtmlTextBox(pReservoir.getHtmlLabel(), StylesV2.FONT_RESERVOIR_LABEL);
        label.setTranslateX((pWidth - label.getComputedWidth()) / 2.0);
        label.setTranslateY((pHeight - label.getComputedHeight()) / 2.0);
        this.getChildren().add((Object)this.center);
        this.getChildren().add((Object)leftBorder);
        this.getChildren().add((Object)rightBorder);
        this.getChildren().add((Object)bottomBorder);
        this.getChildren().add((Object)label);
        pReservoir.addListener(pObservable -> this.setOpacity(pReservoir.isActive() ? 1.0 : 0.2));
        this.setOpacity(pReservoir.isActive() ? 1.0 : 0.2);
    }

    public double getWidth() {
        return this.center.getWidth();
    }

    public double getYWaterTop() {
        return 0.0;
    }

    public double getYWaterMiddle() {
        return this.center.getHeight() / 2.0;
    }

    public double getYMin() {
        return this.center.getHeight();
    }
}

