/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.draw;

import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.Reservoir;
import fr.geonosis.karstmod.modele.reservoirconfig.ClassicalReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfigType;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.draw.ReservoirGroup;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;

public class ClassicalReservoirGroup
extends Group {
    private final double fWidth;
    private final double fHeight;
    private final HtmlTextBox fZeroLabel;
    private final HtmlTextBox fMinLabel;
    private final Rectangle fStandardBottom;
    private final Line fRightBottomBorder;
    private final Line fLeftBottomBorder;
    private final Line fBottomLine;
    private final Line fLine0;
    private final Rectangle center;
    private final ReservoirGroup.ZeroPos fInit0Pos;

    public ClassicalReservoirGroup(Reservoir pReservoir, double pWidth, double pHeight, ReservoirGroup.ZeroPos pInit0Pos) {
        Parameter min;
        this.fWidth = pWidth;
        this.fHeight = pHeight;
        this.fInit0Pos = pInit0Pos;
        this.center = new Rectangle(pWidth, pHeight);
        this.center.setFill((Paint)new Color(0.7254901960784313, 0.807843137254902, 0.8941176470588236, 1.0));
        Line leftBorder = new Line(0.0, -this.fHeight / 3.0, 0.0, this.fHeight);
        leftBorder.setStroke((Paint)Color.BLACK);
        leftBorder.setStrokeWidth(2.0);
        Line rightBorder = new Line(this.fWidth, -this.fHeight / 3.0, this.fWidth, this.fHeight);
        rightBorder.setStroke((Paint)Color.BLACK);
        rightBorder.setStrokeWidth(2.0);
        HtmlTextBox label = new HtmlTextBox(pReservoir.getHtmlLabel(), StylesV2.FONT_RESERVOIR_LABEL);
        label.setTranslateX((this.fWidth - label.getComputedWidth()) / 2.0);
        label.setTranslateY((this.fHeight - label.getComputedHeight()) / 2.0);
        this.fStandardBottom = new Rectangle(0.0, pHeight, pWidth, 2.0 * pHeight / 3.0);
        this.fStandardBottom.setFill((Paint)StylesV2.COLOR_RESERVOIR_BACKGROUND);
        this.fStandardBottom.setVisible(false);
        this.fLine0 = new Line(0.0, this.fHeight, this.fWidth, this.fHeight);
        this.fLine0.setStroke((Paint)Color.BLACK);
        this.fLine0.setStrokeWidth(2.0);
        this.fLeftBottomBorder = new Line(0.0, this.fHeight, 0.0, this.fHeight + 2.0 * this.fHeight / 3.0);
        this.fLeftBottomBorder.setStroke((Paint)Color.BLACK);
        this.fLeftBottomBorder.setStrokeWidth(2.0);
        this.fLeftBottomBorder.setVisible(false);
        this.fRightBottomBorder = new Line(this.fWidth, this.fHeight, this.fWidth, this.fHeight + 2.0 * this.fHeight / 3.0);
        this.fRightBottomBorder.setStroke((Paint)Color.BLACK);
        this.fRightBottomBorder.setStrokeWidth(2.0);
        this.fRightBottomBorder.setVisible(false);
        this.fBottomLine = new Line(0.0, this.fHeight + 2.0 * this.fHeight / 3.0, this.fWidth, this.fHeight + 2.0 * this.fHeight / 3.0);
        this.fBottomLine.setStroke((Paint)Color.BLACK);
        this.fBottomLine.setStrokeWidth(2.0);
        this.fBottomLine.setVisible(false);
        this.fMinLabel = new HtmlTextBox(pReservoir.getHtmlLabel() + "<sub>min</sub>");
        this.fMinLabel.setTranslateX(4.0);
        this.fMinLabel.setTranslateY(this.fHeight + 2.0 * this.fHeight / 3.0 - this.fMinLabel.getComputedHeight());
        this.fMinLabel.setVisible(false);
        this.fZeroLabel = new HtmlTextBox("0");
        this.getChildren().add((Object)this.center);
        this.getChildren().add((Object)leftBorder);
        this.getChildren().add((Object)rightBorder);
        this.getChildren().add((Object)this.fStandardBottom);
        this.getChildren().add((Object)this.fLine0);
        this.getChildren().add((Object)this.fLeftBottomBorder);
        this.getChildren().add((Object)this.fRightBottomBorder);
        this.getChildren().add((Object)this.fBottomLine);
        this.getChildren().add((Object)label);
        this.getChildren().add((Object)this.fMinLabel);
        this.getChildren().add((Object)this.fZeroLabel);
        pReservoir.addListener(pObservable -> this.setOpacity(pReservoir.isActive() ? 1.0 : 0.2));
        this.setOpacity(pReservoir.isActive() ? 1.0 : 0.2);
        Parameter bottomless = ((ClassicalReservoirConfig)pReservoir.getConfig(ReservoirConfigType.CLASSICAL)).getBottomless();
        if (bottomless != null) {
            bottomless.activeProperty().addListener((pObservable, pOldValue, pNewValue) -> this.setBottomless((boolean)pNewValue));
            this.setBottomless(bottomless.isActive());
        }
        if ((min = ((ClassicalReservoirConfig)pReservoir.getConfig(ReservoirConfigType.CLASSICAL)).getHmin()) != null) {
            min.activeProperty().addListener((pObservable, pOldValue, pNewValue) -> this.setMin((boolean)pNewValue));
            this.setMin(min.isActive());
        }
        this.set0Pos(this.fInit0Pos);
    }

    private void set0Pos(ReservoirGroup.ZeroPos pPos) {
        switch (pPos) {
            case IN: {
                this.fZeroLabel.setTranslateX(4.0);
                this.fZeroLabel.setTranslateY(this.fHeight - this.fZeroLabel.getComputedHeight());
                break;
            }
            case LEFT: {
                this.fZeroLabel.setTranslateX(-this.fZeroLabel.getComputedWidth() - 2.0);
                this.fZeroLabel.setTranslateY(this.fHeight - this.fZeroLabel.getComputedHeight() / 2.0);
                break;
            }
            case RIGHT: {
                this.fZeroLabel.setTranslateX(this.fWidth + 3.0);
                this.fZeroLabel.setTranslateY(this.fHeight - this.fZeroLabel.getComputedHeight() / 2.0);
            }
        }
    }

    private void setMin(boolean pMin) {
        this.fMinLabel.setVisible(pMin);
        this.fStandardBottom.setVisible(pMin);
        this.fLeftBottomBorder.setVisible(pMin);
        this.fRightBottomBorder.setVisible(pMin);
        this.fBottomLine.setVisible(pMin);
        if (pMin) {
            this.fLine0.getStrokeDashArray().addAll((Object[])new Double[]{this.fWidth / 21.0, this.fWidth / 21.0});
            this.fLine0.setStrokeWidth(1.0);
        } else {
            this.fLine0.getStrokeDashArray().clear();
            this.fLine0.setStrokeWidth(2.0);
        }
    }

    private void setBottomless(boolean pBottomLess) {
        this.set0Pos(pBottomLess ? ReservoirGroup.ZeroPos.IN : this.fInit0Pos);
        this.fMinLabel.setVisible(false);
        this.fLeftBottomBorder.setVisible(pBottomLess);
        this.fRightBottomBorder.setVisible(pBottomLess);
        this.fBottomLine.setVisible(false);
        if (pBottomLess) {
            this.fLeftBottomBorder.getStrokeDashArray().addAll((Object[])new Double[]{4.0, 4.0});
            this.fLeftBottomBorder.setStroke((Paint)ReservoirGroup.BOTTOMLESS_BORDER_GRADIENT);
            this.fRightBottomBorder.getStrokeDashArray().addAll((Object[])new Double[]{4.0, 4.0});
            this.fRightBottomBorder.setStroke((Paint)ReservoirGroup.BOTTOMLESS_BORDER_GRADIENT);
            this.fLine0.getStrokeDashArray().addAll((Object[])new Double[]{this.fWidth / 21.0, this.fWidth / 21.0});
            this.fLine0.setStrokeWidth(1.0);
        } else {
            this.fLeftBottomBorder.getStrokeDashArray().clear();
            this.fRightBottomBorder.getStrokeDashArray().clear();
            this.fLine0.getStrokeDashArray().clear();
            this.fLine0.setStrokeWidth(2.0);
        }
        this.fStandardBottom.setVisible(pBottomLess);
        this.fStandardBottom.setFill((Paint)(pBottomLess ? ReservoirGroup.BOTTOMLESS_GRADIENT : StylesV2.COLOR_RESERVOIR_BACKGROUND));
    }

    public double getWidth() {
        return this.fWidth;
    }

    public double getY0() {
        return this.fLine0.getStartY();
    }

    public double getYWaterTop() {
        return this.center.getLayoutY();
    }

    public double getBottomHeight() {
        return this.fStandardBottom.getHeight();
    }
}

