/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.modele.RunParameters;
import fr.geonosis.karstmod.modele.obj.AbstractObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.BE;
import fr.geonosis.karstmod.modele.obj.GlobalObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.KGE;
import fr.geonosis.karstmod.modele.obj.KGENP;
import fr.geonosis.karstmod.modele.obj.NSE;
import fr.geonosis.karstmod.modele.obj.ObjectiveFunctionDescriptor;
import fr.geonosis.karstmod.modele.obj.ObjectiveFunctionFactory;
import fr.geonosis.karstmod.modele.obj.RPearson;
import fr.geonosis.karstmod.modele.obj.RSpearman;
import fr.geonosis.karstmod.modele.obj.VE;
import fr.geonosis.karstmod.modele.obj.WobjDataConverter;
import fr.geonosis.karstmod.modele.obj.parser.Part;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.modele.obj.parser.WobjExpression;
import fr.geonosis.karstmod.utils.csv.DoubleRange;
import fr.geonosis.karstmod.viewfx.utils.DecimalFormatter;
import fr.geonosis.karstmod.viewfx.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.VBox;

public class WobjDialogPaneController {
    static final List<Fct> FUNCTION_LIST = new ArrayList<Fct>();
    @FXML
    private VBox stdBox;
    @FXML
    private ComboBox<Fct> obj1FctComboBox;
    @FXML
    private ComboBox<Varname> obj1VarComboBox;
    @FXML
    private ComboBox<Transform> obj1TransformComboBox;
    @FXML
    private TextField obj1LowField;
    @FXML
    private TextField obj1HighField;
    @FXML
    private Label obj1Label;
    @FXML
    private ComboBox<Fct> obj2FctComboBox;
    @FXML
    private ComboBox<Varname> obj2VarComboBox;
    @FXML
    private ComboBox<Transform> obj2TransformComboBox;
    @FXML
    private TextField obj2LowField;
    @FXML
    private TextField obj2HighField;
    @FXML
    private Label obj2Label;
    @FXML
    private TextField wField;
    @FXML
    private TextArea exprField;
    @FXML
    private Label libErrUserDefined;
    @FXML
    private RadioButton rbStd;
    @FXML
    private RadioButton rbUserDefined;
    @FXML
    private ToggleGroup typeGroup;
    @FXML
    private Button okButton;
    private GlobalObjectiveFunction fFunction;
    private ButtonType fButtonType;

    @FXML
    private void initialize() {
        for (Fct fct : FUNCTION_LIST) {
            this.obj1FctComboBox.getItems().add((Object)fct);
            this.obj2FctComboBox.getItems().add((Object)fct);
        }
        ChangeListener obj1Listener = (pObservable, pOldValue, pNewValue) -> {
            Varname varname = (Varname)((Object)((Object)this.obj1VarComboBox.getSelectionModel().getSelectedItem()));
            this.obj1Label.setText(String.format("\u2264 %s \u2264", varname == null ? "?" : varname.getLabel()));
            WobjDataConverter selectedConverter = null;
            if (this.obj1TransformComboBox.getSelectionModel().getSelectedIndex() >= 0) {
                selectedConverter = ((Transform)this.obj1TransformComboBox.getSelectionModel().getSelectedItem()).getConverter();
            }
            this.obj1TransformComboBox.getItems().clear();
            this.obj1TransformComboBox.getSelectionModel().clearSelection();
            for (WobjDataConverter converter : WobjDataConverter.values()) {
                Transform t = new Transform(varname, converter);
                this.obj1TransformComboBox.getItems().add((Object)t);
                if (!converter.equals((Object)selectedConverter)) continue;
                this.obj1TransformComboBox.setValue((Object)t);
            }
        };
        ChangeListener obj2Listener = (pObservable, pOldValue, pNewValue) -> {
            Varname varname = (Varname)((Object)((Object)this.obj2VarComboBox.getSelectionModel().getSelectedItem()));
            this.obj2Label.setText(String.format("\u2264 %s \u2264", varname == null ? "?" : varname.getLabel()));
            WobjDataConverter selectedConverter = null;
            if (this.obj2TransformComboBox.getSelectionModel().getSelectedIndex() >= 0) {
                selectedConverter = ((Transform)this.obj2TransformComboBox.getSelectionModel().getSelectedItem()).getConverter();
            }
            this.obj2TransformComboBox.getItems().clear();
            this.obj2TransformComboBox.getSelectionModel().clearSelection();
            for (WobjDataConverter converter : WobjDataConverter.values()) {
                Transform t = new Transform(varname, converter);
                this.obj2TransformComboBox.getItems().add((Object)t);
                if (!converter.equals((Object)selectedConverter)) continue;
                this.obj2TransformComboBox.setValue((Object)t);
            }
        };
        this.obj1FctComboBox.valueProperty().addListener(obj1Listener);
        this.obj1VarComboBox.valueProperty().addListener(obj1Listener);
        this.obj2FctComboBox.valueProperty().addListener(obj2Listener);
        this.obj2VarComboBox.valueProperty().addListener(obj2Listener);
        this.obj1LowField.setTextFormatter((TextFormatter)new DecimalFormatter());
        this.obj1HighField.setTextFormatter((TextFormatter)new DecimalFormatter());
        this.obj2LowField.setTextFormatter((TextFormatter)new DecimalFormatter());
        this.obj2HighField.setTextFormatter((TextFormatter)new DecimalFormatter());
        this.wField.setTextFormatter((TextFormatter)new DecimalFormatter(0.0, 1.0));
        ChangeListener listener = (pObservable, pOldValue, pNewValue) -> this.validate();
        this.obj1LowField.textProperty().addListener(listener);
        this.obj1HighField.textProperty().addListener(listener);
        this.obj2LowField.textProperty().addListener(listener);
        this.obj2HighField.textProperty().addListener(listener);
        this.wField.textProperty().addListener(listener);
        this.exprField.textProperty().addListener(listener);
        this.rbStd.selectedProperty().addListener(listener);
        this.rbUserDefined.selectedProperty().addListener(listener);
        this.obj1FctComboBox.valueProperty().addListener(listener);
        this.obj1VarComboBox.valueProperty().addListener(listener);
        this.obj1TransformComboBox.valueProperty().addListener(listener);
        this.obj2FctComboBox.valueProperty().addListener(listener);
        this.obj2VarComboBox.valueProperty().addListener(listener);
        this.obj2TransformComboBox.valueProperty().addListener(listener);
        ChangeListener typeListener = (pObservable, pOldValue, pNewValue) -> {
            this.exprField.setDisable(this.rbStd.isSelected());
            this.stdBox.setDisable(this.rbUserDefined.isSelected());
            if (this.rbUserDefined.isSelected()) {
                this.exprField.requestFocus();
            }
        };
        this.rbUserDefined.selectedProperty().addListener(typeListener);
        this.rbStd.selectedProperty().addListener(typeListener);
    }

    public void setFunction(RunParameters pRunParameters) {
        Varname selectedVarname1 = (Varname)((Object)this.obj1VarComboBox.getSelectionModel().getSelectedItem());
        Varname selectedVarname2 = (Varname)((Object)this.obj1VarComboBox.getSelectionModel().getSelectedItem());
        this.obj1VarComboBox.getItems().clear();
        this.obj1VarComboBox.getSelectionModel().clearSelection();
        this.obj2VarComboBox.getItems().clear();
        this.obj2VarComboBox.getSelectionModel().clearSelection();
        for (Varname var : Varname.values()) {
            if (!pRunParameters.getModel().useVar(var) || !pRunParameters.getInputData().contains(var.getColumnName())) continue;
            this.obj1VarComboBox.getItems().add((Object)var);
            this.obj2VarComboBox.getItems().add((Object)var);
            if (var == selectedVarname1) {
                this.obj1VarComboBox.setValue((Object)var);
            }
            if (var != selectedVarname2) continue;
            this.obj2VarComboBox.setValue((Object)var);
        }
        this.fFunction = pRunParameters.getWobjFunction();
        if (this.fFunction.isFromExpression()) {
            this.rbUserDefined.setSelected(true);
            this.exprField.setText(this.fFunction.toString());
        } else if (this.fFunction.getDescriptors().size() == 2) {
            Double d;
            this.rbStd.setSelected(true);
            ObjectiveFunctionDescriptor descriptor1 = this.fFunction.getDescriptors().get(0);
            ObjectiveFunctionDescriptor descriptor2 = this.fFunction.getDescriptors().get(1);
            this.obj1FctComboBox.setValue((Object)new Fct(descriptor1.getFunctionClass()));
            this.obj1VarComboBox.setValue((Object)descriptor1.getVarname());
            this.obj1TransformComboBox.setValue((Object)new Transform(descriptor1.getVarname(), descriptor1.getConverter()));
            if (descriptor1.getRange() == null) {
                this.obj1LowField.setText("");
                this.obj1HighField.setText("");
            } else {
                d = descriptor1.getRange().min();
                this.obj1LowField.setText(d == null ? "" : String.valueOf(d));
                d = descriptor1.getRange().max();
                this.obj1HighField.setText(d == null ? "" : String.valueOf(d));
            }
            this.obj2FctComboBox.setValue((Object)new Fct(descriptor2.getFunctionClass()));
            this.obj2VarComboBox.setValue((Object)descriptor2.getVarname());
            this.obj2TransformComboBox.setValue((Object)new Transform(descriptor2.getVarname(), descriptor2.getConverter()));
            if (descriptor2.getRange() == null) {
                this.obj2LowField.setText("");
                this.obj2HighField.setText("");
            } else {
                d = descriptor2.getRange().min();
                this.obj2LowField.setText(d == null ? "" : String.valueOf(d));
                d = descriptor2.getRange().max();
                this.obj2HighField.setText(d == null ? "" : String.valueOf(d));
            }
            this.wField.setText(String.valueOf(descriptor1.getWeight()));
        }
        if (this.obj1FctComboBox.getValue() == null) {
            this.obj1FctComboBox.setValue((Object)new Fct(NSE.class));
        }
        if (this.obj2FctComboBox.getValue() == null) {
            this.obj2FctComboBox.setValue((Object)new Fct(NSE.class));
        }
        if (this.obj1VarComboBox.getValue() == null) {
            this.obj1VarComboBox.setValue((Object)Varname.QS);
        }
        if (this.obj2VarComboBox.getValue() == null) {
            this.obj2VarComboBox.setValue((Object)Varname.QS);
        }
        if (this.obj1TransformComboBox.getValue() == null) {
            this.obj1TransformComboBox.setValue((Object)new Transform((Varname)((Object)this.obj1VarComboBox.getValue()), WobjDataConverter.IDENTITY));
        }
        if (this.obj2TransformComboBox.getValue() == null) {
            this.obj2TransformComboBox.setValue((Object)new Transform((Varname)((Object)this.obj2VarComboBox.getValue()), WobjDataConverter.IDENTITY));
        }
        this.validate();
    }

    private Object getObj1Name() {
        if (this.obj1FctComboBox.getValue() == null) {
            return "OBJ1";
        }
        if (this.obj1VarComboBox.getValue() == null) {
            return String.format("%s(?)", ObjectiveFunctionFactory.createFunction(((Fct)this.obj1FctComboBox.getValue()).getFctClass()).getFunctionName());
        }
        return ((Varname)((Object)this.obj1VarComboBox.getValue())).getLabel();
    }

    private Object getObj2Name() {
        if (this.obj2FctComboBox.getValue() == null) {
            return "OBJ2";
        }
        if (this.obj2VarComboBox.getValue() == null) {
            return String.format("%s(?)", ObjectiveFunctionFactory.createFunction(((Fct)this.obj2FctComboBox.getValue()).getFctClass()).getFunctionName());
        }
        return String.format("%s", ((Varname)((Object)this.obj2VarComboBox.getValue())).getLabel());
    }

    private void validate() {
        boolean ko = false;
        if (this.rbStd.isSelected()) {
            this.libErrUserDefined.setVisible(false);
            ValidationUtils.clearError((Control)this.obj1LowField);
            ValidationUtils.clearError((Control)this.obj1HighField);
            ValidationUtils.clearError((Control)this.obj2LowField);
            ValidationUtils.clearError((Control)this.obj2HighField);
            ValidationUtils.clearError((Control)this.wField);
            ValidationUtils.clearError(this.obj1FctComboBox);
            ValidationUtils.clearError(this.obj1VarComboBox);
            ValidationUtils.clearError(this.obj1TransformComboBox);
            ValidationUtils.clearError(this.obj2FctComboBox);
            ValidationUtils.clearError(this.obj2VarComboBox);
            ValidationUtils.clearError(this.obj2TransformComboBox);
            if (!ValidationUtils.isSet(this.wField)) {
                ValidationUtils.addError((Control)this.wField, "w must be set");
                ko = true;
            } else {
                String msg;
                double max;
                double min2;
                double w = Double.parseDouble(this.wField.getText().replace(',', '.'));
                if (w > 0.0) {
                    if (this.obj1VarComboBox.getSelectionModel().getSelectedIndex() < 0) {
                        ValidationUtils.addError(this.obj1VarComboBox, "OBJ1 variable must be set");
                        ko = true;
                    }
                    if (this.obj1TransformComboBox.getSelectionModel().getSelectedIndex() < 0) {
                        ValidationUtils.addError(this.obj1TransformComboBox, "OBJ1 transform must be set");
                        ko = true;
                    }
                    if (ValidationUtils.isSet(this.obj1LowField, this.obj1HighField)) {
                        try {
                            min2 = Double.parseDouble(this.obj1LowField.getText().replace(',', '.'));
                            max = Double.parseDouble(this.obj1HighField.getText().replace(',', '.'));
                            if (min2 >= max) {
                                msg = "OBJ1 low threshold must be lesser than OBJ1 high threshold";
                                ValidationUtils.addError((Control)this.obj1LowField, msg);
                                ValidationUtils.addError((Control)this.obj1HighField, msg);
                                ko = true;
                            }
                        }
                        catch (Exception min2) {
                            // empty catch block
                        }
                    }
                }
                if (w < 1.0) {
                    if (this.obj2VarComboBox.getSelectionModel().getSelectedIndex() < 0) {
                        ValidationUtils.addError(this.obj2VarComboBox, "OBJ2 variable must be set");
                        ko = true;
                    }
                    if (this.obj2TransformComboBox.getSelectionModel().getSelectedIndex() < 0) {
                        ValidationUtils.addError(this.obj2TransformComboBox, "OBJ2 transform must be set");
                        ko = true;
                    }
                    if (ValidationUtils.isSet(this.obj2LowField, this.obj2HighField)) {
                        try {
                            min2 = Double.parseDouble(this.obj2LowField.getText().replace(',', '.'));
                            max = Double.parseDouble(this.obj2HighField.getText().replace(',', '.'));
                            if (min2 >= max) {
                                msg = "OBJ2 low threshold must be lesser than OBJ2 high threshold";
                                ValidationUtils.addError((Control)this.obj2LowField, msg);
                                ValidationUtils.addError((Control)this.obj2HighField, msg);
                                ko = true;
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        } else {
            ValidationUtils.clearError((Control)this.exprField);
            try {
                WobjExpression.buildExpression(this.exprField.getText());
                this.libErrUserDefined.setVisible(false);
            }
            catch (Exception e) {
                ko = true;
                this.libErrUserDefined.setVisible(true);
                this.libErrUserDefined.setText(e.getMessage());
                ValidationUtils.addError((Control)this.exprField, e.getMessage());
            }
        }
        this.okButton.setDisable(ko);
    }

    @FXML
    private void handleCancel() {
        this.fButtonType = ButtonType.CANCEL;
        this.obj1Label.getScene().getWindow().hide();
    }

    @FXML
    private void handleOk() {
        this.fFunction.clear();
        if (this.rbUserDefined.isSelected()) {
            this.fFunction.setFromExpression(true);
            WobjExpression expr = WobjExpression.buildExpression(this.exprField.getText());
            for (Part part : expr.getParts()) {
                this.fFunction.addPart(new ObjectiveFunctionDescriptor(part));
            }
        } else {
            this.fFunction.setFromExpression(false);
            double w = Double.parseDouble(this.wField.getText().replace(',', '.'));
            DoubleRange r1 = null;
            if (ValidationUtils.isSet(this.obj1LowField) || ValidationUtils.isSet(this.obj1HighField)) {
                r1 = new DoubleRange(ValidationUtils.isSet(this.obj1LowField) ? Double.valueOf(this.obj1LowField.getText().replace(',', '.')) : null, ValidationUtils.isSet(this.obj1HighField) ? Double.valueOf(this.obj1HighField.getText().replace(',', '.')) : null);
            }
            DoubleRange r2 = null;
            if (ValidationUtils.isSet(this.obj2LowField) || ValidationUtils.isSet(this.obj2HighField)) {
                r2 = new DoubleRange(ValidationUtils.isSet(this.obj2LowField) ? Double.valueOf(this.obj2LowField.getText().replace(',', '.')) : null, ValidationUtils.isSet(this.obj2HighField) ? Double.valueOf(this.obj2HighField.getText().replace(',', '.')) : null);
            }
            this.fFunction.addPart(new ObjectiveFunctionDescriptor(w, ((Fct)this.obj1FctComboBox.getValue()).getFctClass(), (Varname)((Object)this.obj1VarComboBox.getValue()), ((Transform)this.obj1TransformComboBox.getValue()).getConverter(), r1, null));
            this.fFunction.addPart(new ObjectiveFunctionDescriptor(1.0 - w, ((Fct)this.obj2FctComboBox.getValue()).getFctClass(), (Varname)((Object)this.obj2VarComboBox.getValue()), ((Transform)this.obj2TransformComboBox.getValue()).getConverter(), r2, null));
        }
        this.fButtonType = ButtonType.OK;
        this.obj1Label.getScene().getWindow().hide();
    }

    public GlobalObjectiveFunction getFunction() {
        return this.fFunction;
    }

    public ButtonType getButtonType() {
        return this.fButtonType;
    }

    static {
        FUNCTION_LIST.add(new Fct(NSE.class));
        FUNCTION_LIST.add(new Fct(BE.class));
        FUNCTION_LIST.add(new Fct(VE.class));
        FUNCTION_LIST.add(new Fct(KGE.class));
        FUNCTION_LIST.add(new Fct(KGENP.class));
        FUNCTION_LIST.add(new Fct(RPearson.class));
        FUNCTION_LIST.add(new Fct(RSpearman.class));
    }

    static class Fct {
        private final Class<? extends AbstractObjectiveFunction> fFctClass;

        public Fct(Class<? extends AbstractObjectiveFunction> pObjFct) {
            this.fFctClass = pObjFct;
        }

        public Class<? extends AbstractObjectiveFunction> getFctClass() {
            return this.fFctClass;
        }

        public String toString() {
            return ObjectiveFunctionFactory.createFunction(this.fFctClass).getFunctionName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fFctClass == null ? 0 : this.fFctClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Fct other = (Fct)obj;
            return this.toString().equals(other.toString());
        }
    }

    static class Transform {
        private final Varname fVarname;
        private final WobjDataConverter fConverter;

        public Transform(Varname pVarname, WobjDataConverter pConverter) {
            this.fVarname = pVarname;
            this.fConverter = pConverter;
        }

        public Varname getVarname() {
            return this.fVarname;
        }

        public String toString() {
            if (this.fVarname == null) {
                return "";
            }
            return this.fConverter.getVarnameConverter().apply(this.fVarname);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fConverter == null ? 0 : this.fConverter.hashCode());
            result = 31 * result + (this.fVarname == null ? 0 : this.fVarname.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Transform other = (Transform)obj;
            return Objects.equals((Object)this.fConverter, (Object)other.fConverter) && Objects.equals((Object)this.fVarname, (Object)other.fVarname);
        }

        public WobjDataConverter getConverter() {
            return this.fConverter;
        }
    }
}

