/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.KarstModLogger;
import fr.geonosis.karstmod.ihm.ModalResizableAlert;
import fr.geonosis.karstmod.modele.RunParameters;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.WobjDialogPaneController;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class WobjDialog
extends Stage {
    private WobjDialogPaneController fController;

    public static WobjDialog getInstance() {
        return WobjDialogHolder.INSTANCE;
    }

    private WobjDialog() {
        Pane dialogContent;
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        loader.setLocation(WobjDialog.class.getResource("WobjDialogPane.fxml"));
        try {
            dialogContent = (Pane)loader.load();
        }
        catch (IOException e) {
            KarstModLogger.severe("Internal error when loading WOBJ dialog. Karstmod is going to be closed", e, false);
            new ModalResizableAlert(Alert.AlertType.ERROR, "Internal error when loading WOBJ dialog. Karstmod is going to be closed", new ButtonType[0]).showAndWait();
            System.exit(1);
            return;
        }
        this.fController = (WobjDialogPaneController)loader.getController();
        this.setTitle("Objective function");
        this.initModality(Modality.APPLICATION_MODAL);
        Scene scene = new Scene((Parent)dialogContent);
        scene.getStylesheets().add((Object)StylesV2.class.getResource("km.css").toExternalForm());
        this.setScene(scene);
    }

    public boolean showDialog(RunParameters pRunParameters) {
        this.fController.setFunction(pRunParameters);
        this.showAndWait();
        return this.fController.getButtonType() == ButtonType.OK;
    }

    private static class WobjDialogHolder {
        private static final WobjDialog INSTANCE = new WobjDialog();

        private WobjDialogHolder() {
        }
    }
}

