/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.modele.SnowRoutine;
import fr.geonosis.karstmod.run.routine.SubcatchmentTable;
import fr.geonosis.karstmod.viewfx.utils.DecimalFormatter;
import fr.geonosis.karstmod.viewfx.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;

public class SubcatchmentsDialogPaneController {
    @FXML
    private GridPane grid;
    @FXML
    private Label errorLabel;
    @FXML
    private Button okButton;
    private SnowRoutine fSnowRoutine;
    private ButtonType fButtonType;
    private List<Subcatchment> fSubcatchments;

    @FXML
    private void initialize() {
        this.fSubcatchments = new ArrayList<Subcatchment>();
        this.errorLabel.managedProperty().bindBidirectional((Property)this.errorLabel.visibleProperty());
        this.errorLabel.setVisible(false);
        this.validate();
    }

    public void setSnowRoutine(SnowRoutine pSnowRoutine) {
        int i;
        this.fSnowRoutine = pSnowRoutine;
        for (i = this.grid.getRowCount(); i >= 2; --i) {
            this.deleteRow(i - 1);
        }
        if (!pSnowRoutine.getSubcatchmentTable().isEmpty()) {
            for (i = 0; i < pSnowRoutine.getSubcatchmentTable().size(); ++i) {
                this.handleAddSubcatchment();
                this.fSubcatchments.get(i).proportionField().setText(String.valueOf(pSnowRoutine.getSubcatchmentTable().getProportion(i)));
                this.fSubcatchments.get(i).tempShiftField().setText(String.valueOf(pSnowRoutine.getSubcatchmentTable().getTempShift(i)));
            }
        }
        this.validate();
    }

    @FXML
    private void handleAddSubcatchment() {
        Subcatchment subcatchment = new Subcatchment(new Label(), new TextField(), new TextField(), new Button());
        subcatchment.numLabel().setText(String.valueOf(this.fSubcatchments.size() + 1));
        subcatchment.proportionField().setTextFormatter((TextFormatter)new DecimalFormatter(0.0, 1.0));
        subcatchment.tempShiftField().setTextFormatter((TextFormatter)new DecimalFormatter(-100.0, 100.0));
        subcatchment.removeButton().setGraphic((Node)new ImageView(new Image(this.getClass().getResourceAsStream("resources/delete.png"))));
        subcatchment.removeButton().setTooltip(new Tooltip("Delete"));
        subcatchment.removeButton().setOnAction(e -> this.deleteRow(GridPane.getRowIndex((Node)subcatchment.removeButton())));
        this.fSubcatchments.add(subcatchment);
        int rowNum = this.fSubcatchments.size();
        this.grid.add((Node)subcatchment.numLabel(), 0, rowNum);
        this.grid.add((Node)subcatchment.proportionField(), 1, rowNum);
        this.grid.add((Node)subcatchment.tempShiftField(), 2, rowNum);
        this.grid.add((Node)subcatchment.removeButton(), 3, rowNum);
        ChangeListener listener = (pObservable, pOldValue, pNewValue) -> this.validate();
        subcatchment.proportionField().textProperty().addListener(listener);
        subcatchment.tempShiftField().textProperty().addListener(listener);
        this.validate();
    }

    private void validate() {
        boolean ko = false;
        boolean missing = false;
        this.errorLabel.setText("");
        this.errorLabel.setVisible(false);
        SubcatchmentTable tab = new SubcatchmentTable();
        if (this.fSubcatchments.isEmpty()) {
            tab.setRows(new SubcatchmentTable.Row[0]);
        } else {
            double propSum = 0.0;
            for (Subcatchment sc : this.fSubcatchments) {
                ValidationUtils.clearError((Control)sc.proportionField);
                ValidationUtils.clearError((Control)sc.tempShiftField);
                if (sc.proportionField().getText().isBlank()) {
                    missing = true;
                } else {
                    try {
                        double prop = Double.parseDouble(sc.proportionField().getText().replace(',', '.'));
                        if (prop == 0.0) {
                            ValidationUtils.addError((Control)sc.proportionField(), "0 is not a valid value");
                            ko = true;
                        } else {
                            propSum += prop;
                        }
                    }
                    catch (NumberFormatException e) {
                        ValidationUtils.addError((Control)sc.proportionField(), "Bad numeric format");
                        ko = true;
                    }
                }
                if (sc.tempShiftField().getText().isBlank()) {
                    missing = true;
                    continue;
                }
                try {
                    Double.parseDouble(sc.tempShiftField().getText().replace(',', '.'));
                }
                catch (NumberFormatException e) {
                    ValidationUtils.addError((Control)sc.proportionField(), "Bad numeric format");
                    ko = true;
                }
            }
            if (!ko && Math.abs(propSum - 1.0) > 1.0E-7) {
                this.errorLabel.setVisible(true);
                this.errorLabel.setText("The sum of proportions must be equal to 1");
                ko = true;
            } else if (!ko && missing) {
                this.errorLabel.setVisible(true);
                this.errorLabel.setText("All values are required");
                ko = true;
            }
        }
        this.okButton.setDisable(ko);
    }

    private void deleteRow(int row) {
        HashSet<Node> deleteNodes = new HashSet<Node>();
        for (Node child : this.grid.getChildren()) {
            int r;
            Integer rowIndex = GridPane.getRowIndex((Node)child);
            int n = r = rowIndex == null ? 0 : rowIndex;
            if (r > row) {
                GridPane.setRowIndex((Node)child, (Integer)(r - 1));
                continue;
            }
            if (r != row) continue;
            deleteNodes.add(child);
        }
        this.grid.getChildren().removeAll(deleteNodes);
        this.fSubcatchments.remove(row - 1);
        for (Subcatchment subcatchment : this.fSubcatchments) {
            subcatchment.numLabel().setText(String.valueOf(GridPane.getRowIndex((Node)subcatchment.numLabel())));
        }
        this.validate();
    }

    @FXML
    private void handleCancel() {
        this.fButtonType = ButtonType.CANCEL;
        this.grid.getScene().getWindow().hide();
    }

    @FXML
    private void handleOk() {
        try {
            if (this.fSubcatchments.isEmpty()) {
                this.fSnowRoutine.getSubcatchmentTable().setRows(new SubcatchmentTable.Row[0]);
            } else {
                SubcatchmentTable.Row[] rows = new SubcatchmentTable.Row[this.fSubcatchments.size()];
                for (int i = 0; i < this.fSubcatchments.size(); ++i) {
                    rows[i] = new SubcatchmentTable.Row(Double.parseDouble(this.fSubcatchments.get(i).proportionField().getText().replace(',', '.')), Double.parseDouble(this.fSubcatchments.get(i).tempShiftField().getText().replace(',', '.')));
                }
                this.fSnowRoutine.getSubcatchmentTable().setRows(rows);
            }
            this.fButtonType = ButtonType.OK;
            this.grid.getScene().getWindow().hide();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ButtonType getButtonType() {
        return this.fButtonType;
    }

    private static class Subcatchment {
        private final Label numLabel;
        private final TextField proportionField;
        private final TextField tempShiftField;
        private final Button removeButton;

        public Subcatchment(Label pNumLabel, TextField pProportionField, TextField pTempShiftField, Button pRemoveButton) {
            this.numLabel = pNumLabel;
            this.proportionField = pProportionField;
            this.tempShiftField = pTempShiftField;
            this.removeButton = pRemoveButton;
        }

        public Label numLabel() {
            return this.numLabel;
        }

        public TextField proportionField() {
            return this.proportionField;
        }

        public TextField tempShiftField() {
            return this.tempShiftField;
        }

        public Button removeButton() {
            return this.removeButton;
        }
    }
}

