/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.ihm.ModalResizableAlert;
import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.viewfx.FormDecorator;
import fr.geonosis.karstmod.viewfx.ResultsPaneController;
import fr.geonosis.karstmod.viewfx.SSIDialogPaneController;
import fr.geonosis.karstmod.viewfx.StylesV2;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class SSIDialog
extends Stage {
    private SSIDialogPaneController fController;

    public static SSIDialog getInstance() {
        return RunDialogHolder.INSTANCE;
    }

    private SSIDialog() {
        Pane dialogContent;
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        loader.setLocation(SSIDialog.class.getResource("SSIDialogPane.fxml"));
        try {
            dialogContent = (Pane)loader.load();
        }
        catch (IOException e) {
            new ModalResizableAlert(Alert.AlertType.ERROR, "Internal error when loading SSI dialog. Karstmod is going to be closed", new ButtonType[0]).showAndWait();
            System.exit(1);
            return;
        }
        this.fController = (SSIDialogPaneController)loader.getController();
        this.setTitle("Run in progress...");
        this.initModality(Modality.APPLICATION_MODAL);
        this.initStyle(StageStyle.UNDECORATED);
        Scene scene = new Scene((Parent)new FormDecorator(this, (Node)dialogContent));
        scene.setFill(null);
        scene.getStylesheets().add((Object)StylesV2.class.getResource("km.css").toExternalForm());
        this.setScene(scene);
    }

    public void showDialog(KarstModConfig pConfig, ResultsPaneController pResultsPane, int pNbRunTot) {
        this.fController.setConfig(pConfig, pResultsPane, pNbRunTot);
        this.showAndWait();
    }

    public void continuePrevious(int pNbRunTot) {
        this.fController.continuePrevious(pNbRunTot);
        this.showAndWait();
    }

    private static class RunDialogHolder {
        private static final SSIDialog INSTANCE = new SSIDialog();

        private RunDialogHolder() {
        }
    }
}

