/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.modele.Message;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.MessageType;
import fr.geonosis.karstmod.modele.RunParameters;
import fr.geonosis.karstmod.viewfx.ModelParamsPaneController;
import fr.geonosis.karstmod.viewfx.SetFunction;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.WobjDialog;
import fr.geonosis.karstmod.viewfx.utils.DecimalFormatHelper;
import fr.geonosis.karstmod.viewfx.utils.DecimalFormatter;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import fr.geonosis.karstmod.viewfx.utils.IntegerFormatter;
import fr.geonosis.karstmod.viewfx.utils.MyTooltip;
import fr.geonosis.karstmod.viewfx.utils.ValidationUtils;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.stage.DirectoryChooser;

public class RunParametersPaneController {
    @FXML
    private AnchorPane rootPane;
    @FXML
    private TextField warmupField;
    @FXML
    private TextField calibrationField;
    @FXML
    private TextField validationField;
    @FXML
    private TextField nObjField;
    @FXML
    private TextField tMaxField;
    @FXML
    private TextField wObjMinField;
    @FXML
    private TextField outputDirField;
    @FXML
    private Label calibParamsNumberLabel;
    @FXML
    private Pane nObjLabelPanel;
    @FXML
    private Pane wObjMinLabelPanel;
    @FXML
    private Pane wObjLabelPane;
    private RunParameters fRunParameters;

    public static RunParametersPaneController create() throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(RunParametersPaneController.class.getClassLoader());
        loader.setLocation(ModelParamsPaneController.class.getResource("RunParametersPane.fxml"));
        loader.load();
        return (RunParametersPaneController)loader.getController();
    }

    @FXML
    private void initialize() {
        this.nObjLabelPanel.getChildren().add((Object)new HtmlTextBox("<html>n<sub>obj</sub>:</html>"));
        this.wObjMinLabelPanel.getChildren().add((Object)new HtmlTextBox("<html>WOBJ<sub>min</sub>:</html>"));
        this.warmupField.setTextFormatter((TextFormatter)new IntegerFormatter(0, Integer.MAX_VALUE));
        this.nObjField.setTextFormatter((TextFormatter)new IntegerFormatter(1, Integer.MAX_VALUE));
        this.tMaxField.setTextFormatter((TextFormatter)new IntegerFormatter(1, Integer.MAX_VALUE));
        this.wObjMinField.setTextFormatter((TextFormatter)new DecimalFormatter(-1.7976931348623157E308, 1.0));
        this.calibParamsNumberLabel.setTextFill((Paint)StylesV2.COLOR_PARAMETER_TO_CALIBRATE);
        this.calibParamsNumberLabel.getStyleClass().add((Object)"bold");
    }

    public void setConfig(KarstModConfig pConfig) {
        this.fRunParameters = pConfig.getRunParameters();
        this.fRunParameters.getInputData().addListener(pObservable -> this.valuesChanged());
        this.valuesChanged();
        this.warmupField.setText(String.valueOf(this.fRunParameters.getWarmupBeginning()));
        this.listenFieldChange(this.warmupField, () -> this.fRunParameters.setWarmupBeginning(this.warmupField.getText().isEmpty() ? 0 : Integer.parseInt(this.warmupField.getText())));
        this.fRunParameters.warmupBeginningProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (pNewValue != 0 || !"".equals(this.warmupField.getText())) {
                this.warmupField.setText(String.valueOf(pNewValue));
            }
        });
        this.calibrationField.setText((String)this.fRunParameters.calibrationStagesProperty().get());
        this.validationField.setText((String)this.fRunParameters.validationStagesProperty().get());
        this.listenFieldChange(this.calibrationField, () -> this.fRunParameters.calibrationStagesProperty().set((Object)this.calibrationField.getText()));
        this.listenFieldChange(this.validationField, () -> this.fRunParameters.validationStagesProperty().set((Object)this.validationField.getText()));
        this.fRunParameters.calibrationStagesProperty().addListener((pObservable, pOldValue, pNewValue) -> this.calibrationField.setText((String)this.fRunParameters.calibrationStagesProperty().get()));
        this.fRunParameters.validationStagesProperty().addListener((pObservable, pOldValue, pNewValue) -> this.validationField.setText((String)this.fRunParameters.validationStagesProperty().get()));
        this.calibrationField.focusedProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (!pNewValue.booleanValue()) {
                this.fRunParameters.fitStages();
            }
        });
        this.validationField.focusedProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (!pNewValue.booleanValue()) {
                this.fRunParameters.fitStages();
            }
        });
        this.fRunParameters.getWobjFunction().addListener(pObservable -> this.updateWObjLabel());
        this.updateWObjLabel();
        this.wObjMinField.textProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.fRunParameters.setWobjMin(DecimalFormatHelper.parseExact(pNewValue));
            if (pNewValue == null || pNewValue.isEmpty()) {
                ValidationUtils.addError((Control)this.wObjMinField, "WOBJmin must be set");
            } else {
                ValidationUtils.clearError((Control)this.wObjMinField);
            }
        });
        this.nObjField.textProperty().addListener((pObservable, pOldValue, pNewValue) -> this.fRunParameters.setSimulationNumber(ValidationUtils.parseIntNull(pNewValue)));
        this.tMaxField.textProperty().addListener((pObservable, pOldValue, pNewValue) -> this.fRunParameters.setMaxTime(ValidationUtils.parseIntNull(pNewValue)));
        this.outputDirField.textProperty().addListener((pObservable, pOldValue, pNewValue) -> this.fRunParameters.setOutputDirectory((String)pNewValue));
        this.fRunParameters.wobjMinProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (DecimalFormatHelper.parseExact(this.wObjMinField.getText()) != pNewValue) {
                this.wObjMinField.setText(String.valueOf(pNewValue));
            }
        });
        this.fRunParameters.nObjProperty().addListener((pObservable, pOldValue, pNewValue) -> this.nObjField.setText(String.valueOf(pNewValue)));
        this.fRunParameters.maxTimeProperty().addListener((pObservable, pOldValue, pNewValue) -> this.tMaxField.setText(String.valueOf(pNewValue)));
        this.fRunParameters.outputDirectoryProperty().addListener((pObservable, pOldValue, pNewValue) -> this.outputDirField.setText(String.valueOf(pNewValue)));
        pConfig.getModel().getCalibrateParameters().addListener((pObservable, pOldValue, pNewValue) -> this.calibParamsNumberLabel.setText(String.valueOf(pConfig.getModel().getCalibrateParameters().size())));
        this.calibParamsNumberLabel.setText(String.valueOf(pConfig.getModel().getCalibrateParameters().size()));
        this.wObjMinField.setText(String.valueOf(this.fRunParameters.getWobjMin()));
        this.nObjField.setText(String.valueOf(this.fRunParameters.getNObj()));
        this.tMaxField.setText(String.valueOf(this.fRunParameters.getMaxTime()));
        this.outputDirField.setText(String.valueOf(this.fRunParameters.getOutputDirectory()));
        Platform.runLater(this::validate);
        pConfig.addListener(o -> Platform.runLater(this::validate));
    }

    private void valuesChanged() {
        this.validate();
    }

    @FXML
    private void browseOutputDir() {
        File selectedDirectory;
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle("Choose output dir");
        File dir = this.outputDirField.getText() != null && this.outputDirField.getText().trim().length() > 0 ? new File(this.outputDirField.getText()) : new File(Preferences.userRoot().node(this.getClass().getName()).get("LAST_OUTPUT_DIR", "."));
        if (dir.exists() && dir.isDirectory()) {
            directoryChooser.setInitialDirectory(dir);
        }
        if ((selectedDirectory = directoryChooser.showDialog(this.outputDirField.getScene().getWindow())) != null) {
            this.outputDirField.setText(selectedDirectory.getAbsolutePath());
            Preferences.userRoot().node(this.getClass().getName()).put("LAST_OUTPUT_DIR", selectedDirectory.getAbsolutePath());
        }
    }

    @FXML
    private void chooseWobj() {
        WobjDialog.getInstance().showDialog(this.fRunParameters);
    }

    private void listenFieldChange(TextField pTextField, SetFunction pRunnable) {
        pTextField.textProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            ValidationUtils.clearError((Control)pTextField);
            try {
                pRunnable.run();
            }
            catch (Exception ex) {
                ValidationUtils.addError((Control)pTextField, ex.getMessage());
            }
            this.validate();
        });
    }

    private void validate() {
        MessageList msgList;
        ValidationUtils.clearError((Control)this.warmupField);
        ValidationUtils.clearError((Control)this.calibrationField);
        ValidationUtils.clearError((Control)this.validationField);
        ValidationUtils.clearError((Control)this.wObjMinField);
        ValidationUtils.clearError((Control)this.nObjField);
        ValidationUtils.clearError((Control)this.tMaxField);
        ValidationUtils.clearError((Control)this.outputDirField);
        this.updateWObjLabel();
        Object formatString = "Format : beginning-end;beginning-end";
        if (this.fRunParameters.getInputData().isLoaded()) {
            formatString = (String)formatString + String.format("\nMax = %d", this.fRunParameters.getInputData().size() - 1);
        }
        if ((msgList = this.fRunParameters.validate()).has(MessageType.ERROR)) {
            for (Message msg : msgList.getMessages(MessageType.ERROR)) {
                if ("run-parameters.warmup-beginning".equals(msg.getFieldName())) {
                    ValidationUtils.addError((Control)this.warmupField, msg.getMessage());
                    continue;
                }
                if ("run-parameters.calibration-stages".equals(msg.getFieldName())) {
                    ValidationUtils.addError((Control)this.calibrationField, msg.getMessage());
                    ValidationUtils.addError((Control)this.calibrationField, (String)formatString);
                    continue;
                }
                if ("run-parameters.validations-stages".equals(msg.getFieldName())) {
                    ValidationUtils.addError((Control)this.validationField, msg.getMessage());
                    ValidationUtils.addError((Control)this.validationField, (String)formatString);
                    continue;
                }
                if ("run-parameters.wobj-min".equals(msg.getFieldName())) {
                    ValidationUtils.addError((Control)this.wObjMinField, msg.getMessage());
                    continue;
                }
                if ("run-parameters.simulations-number".equals(msg.getFieldName())) {
                    ValidationUtils.addError((Control)this.nObjField, msg.getMessage());
                    continue;
                }
                if ("run-parameters.max-time".equals(msg.getFieldName())) {
                    ValidationUtils.addError((Control)this.tMaxField, msg.getMessage());
                    continue;
                }
                if ("run-parameters.output-directory".equals(msg.getFieldName())) {
                    ValidationUtils.addError((Control)this.outputDirField, msg.getMessage());
                    continue;
                }
                if (!"run-parameters.wobj-function.".equals(msg.getFieldName())) continue;
                this.wObjLabelPane.getChildren().clear();
                ImageView errorImage = new ImageView(new Image(this.getClass().getResource("resources/red-error-24.png").toString()));
                Tooltip.install((Node)errorImage, (Tooltip)new MyTooltip(msg.getMessage(), 0.0, 60000.0, 200.0));
                this.wObjLabelPane.getChildren().add((Object)errorImage);
            }
        } else {
            ValidationUtils.setTooltipText(this.calibrationField, (String)formatString);
            ValidationUtils.setTooltipText(this.validationField, (String)formatString);
        }
    }

    private void updateWObjLabel() {
        this.wObjLabelPane.getChildren().clear();
        HtmlTextBox tb = new HtmlTextBox(this.fRunParameters.getWobjFunction().toString());
        tb.setTranslateY(4.0);
        this.wObjLabelPane.getChildren().add((Object)tb);
    }

    public AnchorPane getRootPane() {
        return this.rootPane;
    }
}

