/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.KarstModLogger;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.compute.ConfidenceInterval;
import fr.geonosis.karstmod.ihm.ModalResizableAlert;
import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.modele.ModeKarstMod;
import fr.geonosis.karstmod.modele.Model;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.RunParameters;
import fr.geonosis.karstmod.modele.obj.WobjRunResults;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.run.RunMonitor;
import fr.geonosis.karstmod.run.model.RunModel;
import fr.geonosis.karstmod.viewfx.CalibrationResultsPaneController;
import fr.geonosis.karstmod.viewfx.ResultsPaneController;
import fr.geonosis.karstmod.viewfx.RunDialog;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import fr.geonosis.karstmod.viewfx.utils.ModelInput;
import fr.geonosis.karstmod.viewfx.utils.ModelOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;

public class RunDialogPaneController {
    static final String PARAMS_OUT_CSV = Messages.getString("JRun.1") + ".csv";
    @FXML
    private VBox rootPane;
    @FXML
    private HBox resultProgressPane;
    @FXML
    private Label gridPane;
    @FXML
    private Label computeMessage;
    @FXML
    private ProgressBar timeProgress;
    @FXML
    private ProgressBar nObjProgress;
    @FXML
    private ProgressBar resultsProgress;
    @FXML
    private ProgressIndicator piTime;
    @FXML
    private ProgressIndicator piNObj;
    @FXML
    private Pane nObjLabelPane;
    @FXML
    private Button cancelButton;
    @FXML
    private Label lblTMax;
    @FXML
    private HBox boxTMax;
    private KarstModConfig fConfig;
    private RunMonitor fRunMonitor;
    private Service<Void> fTimeProgresseService;

    @FXML
    private void initialize() {
    }

    public void setConfig(KarstModConfig pConfig, ResultsPaneController pResultsPane, CalibrationResultsPaneController pCalibrationResultsPaneController, boolean pComputeCI) {
        this.resultsProgress.setProgress(-1.0);
        this.rootPane.setVisible(true);
        this.resultProgressPane.setVisible(false);
        this.resultProgressPane.managedProperty().bind((ObservableValue)this.resultProgressPane.visibleProperty());
        this.rootPane.managedProperty().bind((ObservableValue)this.rootPane.visibleProperty());
        this.cancelButton.setDisable(false);
        this.timeProgress.progressProperty().unbind();
        this.piTime.progressProperty().unbind();
        this.nObjProgress.setProgress(0.0);
        this.timeProgress.setProgress(0.0);
        this.fConfig = pConfig;
        this.nObjLabelPane.getChildren().clear();
        this.nObjLabelPane.getChildren().add((Object)new HtmlTextBox(String.format("<html>n<sub>obj</sub>(WOBJ \u2265 %s):</html>", this.fConfig.getRunParameters().getWobjMin())));
        pResultsPane.clearQsim(false);
        pCalibrationResultsPaneController.clear();
        if (this.fConfig.getMode() == ModeKarstMod.CALIBRATION) {
            pCalibrationResultsPaneController.setObjNum("-");
        }
        this.cancelButton.setDisable(false);
        this.fRunMonitor = new RunMonitor(this.fConfig, pComputeCI);
        this.fTimeProgresseService = this.createTimeProgressService(this.fConfig.getRunParameters().getMaxTime());
        this.timeProgress.progressProperty().bind((ObservableValue)this.fTimeProgresseService.progressProperty());
        this.piTime.progressProperty().bind((ObservableValue)this.fTimeProgresseService.progressProperty());
        this.fTimeProgresseService.start();
        Service<Void> runService = this.createRunService(pResultsPane, pCalibrationResultsPaneController);
        this.fTimeProgresseService.stateProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (pNewValue == Worker.State.SUCCEEDED) {
                this.fRunMonitor.cancel();
            }
        });
        this.cancelButton.setOnAction(e -> this.doCancel());
        runService.start();
    }

    void doCancel() {
        this.fRunMonitor.cancel();
    }

    private Service<Void> createTimeProgressService(final int pTMax) {
        return new Service<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() throws Exception {
                        double top = System.currentTimeMillis();
                        double pTMaxms = 1000.0 * (double)pTMax;
                        while (!this.isDone()) {
                            this.updateProgress((double)System.currentTimeMillis() - top, pTMaxms);
                            Thread.yield();
                        }
                        return null;
                    }
                };
            }
        };
    }

    private Service<Void> createRunService(final ResultsPaneController pResultsPaneController, final CalibrationResultsPaneController pCalibrationResultsPaneController) {
        return new Service<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() throws Exception {
                        try {
                            Platform.runLater(() -> {
                                RunDialogPaneController.this.nObjProgress.setProgress(0.0);
                                RunDialogPaneController.this.piNObj.setProgress(0.0);
                                pResultsPaneController.setVisible(false);
                            });
                            if (RunDialogPaneController.this.fConfig.getMode() == ModeKarstMod.RUN) {
                                RunDialogPaneController.this.doRun(pResultsPaneController, pCalibrationResultsPaneController);
                            } else if (RunDialogPaneController.this.fConfig.getMode() == ModeKarstMod.CALIBRATION) {
                                if (RunDialogPaneController.this.fConfig.isParamsFromFile()) {
                                    RunDialogPaneController.this.doMulti(pResultsPaneController, pCalibrationResultsPaneController);
                                } else {
                                    RunDialogPaneController.this.doCalibration(pResultsPaneController, pCalibrationResultsPaneController);
                                }
                            }
                            RunDialogPaneController.this.checkAppDom(RunDialogPaneController.this.fRunMonitor.getBestRunModel());
                        }
                        catch (Exception ex) {
                            KarstModLogger.dialogError(ex.getMessage());
                        }
                        finally {
                            RunDialogPaneController.this.dispose();
                            if (RunDialogPaneController.this.fRunMonitor != null) {
                                RunDialogPaneController.this.fRunMonitor.cancel();
                            }
                            Platform.runLater(() -> {
                                RunDialogPaneController.this.fTimeProgresseService.cancel();
                                pResultsPaneController.setVisible(true);
                            });
                        }
                        return null;
                    }
                };
            }
        };
    }

    private void doCalibration(ResultsPaneController pResultsPaneController, CalibrationResultsPaneController pCalibrationResultsPaneController) throws Exception {
        this.setTimeProgessVisible(true);
        this.fRunMonitor.setUseTmax(true);
        Model model = this.fConfig.getModel();
        RunParameters runParameters = this.fConfig.getRunParameters();
        double coefProgressNObj = 1.0 / (double)runParameters.getNObj().intValue();
        AtomicBoolean aff = new AtomicBoolean(false);
        this.fRunMonitor.addListener((pWObjCalibration, pWObjValidation, pNobjRun) -> {
            if (!aff.get()) {
                aff.set(true);
                Platform.runLater(() -> {
                    this.nObjProgress.setProgress((double)pNobjRun * coefProgressNObj);
                    this.piNObj.setProgress((double)pNobjRun * coefProgressNObj);
                    pCalibrationResultsPaneController.setObjNum(String.valueOf(pNobjRun));
                    pCalibrationResultsPaneController.setValues(pWObjCalibration.getRes(), pWObjValidation.getRes());
                    aff.set(false);
                });
            }
        });
        WobjRunResults results = this.fRunMonitor.doCalibration();
        this.showResultsMessage();
        Platform.runLater(() -> {
            pCalibrationResultsPaneController.setObjNum("" + this.fRunMonitor.getNobjRun());
            pCalibrationResultsPaneController.setValues(this.fRunMonitor.getWobjCalibrationBest().getRes(), this.fRunMonitor.getWobjValidationForCalibrationBest().getRes());
            this.nObjProgress.setProgress((double)this.fRunMonitor.getNobjRun() * coefProgressNObj);
            this.piNObj.setProgress((double)this.fRunMonitor.getNobjRun() * coefProgressNObj);
            this.cancelButton.setDisable(true);
            new Thread(() -> {
                if (this.fRunMonitor.getNobjRun() > 0) {
                    pResultsPaneController.getGraphiqueParametres().setValues(this.fRunMonitor.getParamsOutArray());
                    pResultsPaneController.repaintSelectedTab();
                    pResultsPaneController.update(this.fRunMonitor, results, (List<Parameter>)model.getCalibrateParameters());
                    if (this.hasCI()) {
                        this.doCI(pResultsPaneController);
                    }
                    try {
                        new ModelOutput(this.fRunMonitor, runParameters.getOutputDirectory(), null, true, false).saveAll(this.fConfig.getMode(), this.fRunMonitor.getBestRunModel());
                    }
                    catch (IOException e) {
                        KarstModLogger.dialogError(e.getMessage());
                    }
                } else {
                    pResultsPaneController.clearQsim(true);
                    KarstModLogger.dialogError(Messages.getString("JRun.53") + " \u2265 " + runParameters.getWobjMin());
                }
            }).start();
        });
    }

    private void doRun(ResultsPaneController pResultsPaneController, CalibrationResultsPaneController pCalibrationResultsPaneController) {
        this.setTimeProgessVisible(false);
        this.fRunMonitor.setUseTmax(false);
        Model model = this.fConfig.getModel();
        RunParameters runParameters = this.fConfig.getRunParameters();
        WobjRunResults results = this.fRunMonitor.doRun(true);
        Platform.runLater(() -> {
            pCalibrationResultsPaneController.setObjNum("-");
            pCalibrationResultsPaneController.setValues(results.getWobjCalibrationBest().getRes(), results.getWobjValidationForCalibrationBest().getRes());
        });
        new Thread(() -> {
            pResultsPaneController.update((List<Parameter>)model.getCalibrateParameters(), results, this.fRunMonitor);
            pResultsPaneController.getGraphiqueParametres().setValues(this.fRunMonitor.getParamsOutArray());
            pResultsPaneController.repaintSelectedTab();
            try {
                new ModelOutput(this.fRunMonitor, runParameters.getOutputDirectory(), "run", true, false).saveAll(this.fConfig.getMode(), this.fRunMonitor.getBestRunModel());
            }
            catch (IOException e) {
                KarstModLogger.dialogError(e.getMessage());
            }
        }).start();
    }

    private void doMulti(ResultsPaneController pResultsPaneController, CalibrationResultsPaneController pCalibrationResultsPaneController) throws Exception {
        this.setTimeProgessVisible(false);
        this.fRunMonitor.setUseTmax(false);
        Model model = this.fConfig.getModel();
        RunParameters runParameters = this.fConfig.getRunParameters();
        Map<Parameter, double[]> paramValues = ModelInput.loadParamsOut(runParameters.getOutputDirectory() + "/params_out.csv", model);
        AtomicBoolean aff = new AtomicBoolean(false);
        this.fRunMonitor.addListener((pWObjCalibration, pWObjValidation, pNobjRun) -> {
            if (!aff.get()) {
                aff.set(true);
                Platform.runLater(() -> {
                    this.nObjProgress.setProgress((double)pNobjRun / (double)this.fRunMonitor.getNObj());
                    this.piNObj.setProgress((double)pNobjRun / (double)this.fRunMonitor.getNObj());
                    pCalibrationResultsPaneController.setObjNum(String.valueOf(pNobjRun));
                    pCalibrationResultsPaneController.setValues(pWObjCalibration.getRes(), pWObjValidation.getRes());
                    aff.set(false);
                });
            }
        });
        WobjRunResults results = this.fRunMonitor.doCalibration(paramValues, runParameters.getOutputDirectory());
        Platform.runLater(() -> {
            pCalibrationResultsPaneController.setObjNum("" + this.fRunMonitor.getNobjRun());
            pCalibrationResultsPaneController.setValues(this.fRunMonitor.getWobjCalibrationBest().getRes(), this.fRunMonitor.getWobjValidationForCalibrationBest().getRes());
            this.nObjProgress.setProgress(0.0);
            this.piNObj.setProgress(0.0);
            this.cancelButton.setDisable(true);
            new Thread(() -> {
                if (this.fRunMonitor.getNobjRun() > 0) {
                    pResultsPaneController.getGraphiqueParametres().setValues(this.fRunMonitor.getParamsOutArray());
                    pResultsPaneController.repaintSelectedTab();
                    pResultsPaneController.update(this.fRunMonitor, results, (List<Parameter>)model.getCalibrateParameters());
                    if (this.hasCI()) {
                        this.doCI(pResultsPaneController);
                    }
                    try {
                        new ModelOutput(this.fRunMonitor, runParameters.getOutputDirectory(), "_all", true, false).saveAll(this.fConfig.getMode(), this.fRunMonitor.getBestRunModel());
                    }
                    catch (IOException e) {
                        KarstModLogger.dialogError(e.getMessage());
                    }
                } else {
                    pResultsPaneController.clearQsim(true);
                    KarstModLogger.dialogError(Messages.getString("JRun.53") + " \u2265 " + runParameters.getWobjMin());
                }
            }).start();
        });
    }

    private void showResultsMessage() {
        Platform.runLater(() -> {
            this.rootPane.setVisible(false);
            this.resultProgressPane.setVisible(true);
        });
    }

    private void dispose() {
        Platform.runLater(() -> this.rootPane.getScene().getWindow().hide());
    }

    public ConfidenceInterval getConfidenceInterval(Varname pVarname) {
        if (this.fRunMonitor == null) {
            return null;
        }
        return this.fRunMonitor.getConfidenceInterval(pVarname);
    }

    private void checkAppDom(RunModel pModel) {
        if (pModel != null && pModel.getBadsolE() > 0) {
            Platform.runLater(() -> new ModalResizableAlert(Alert.AlertType.ERROR, String.format("Warning ! Linearized solution of the flow equation is unaccurate on %d time step%s", pModel.getBadsolE(), pModel.getBadsolE() > 1 ? "s" : ""), ButtonType.OK).showAndWait());
        }
    }

    public boolean hasCI() {
        return this.fRunMonitor.hasCI();
    }

    private void doCI(ResultsPaneController pResultsPaneController) {
        for (Varname varname : Varname.values()) {
            if (!this.fConfig.getModel().useVar(varname)) continue;
            ConfidenceInterval confidenceInterval = RunDialog.getInstance().getConfidenceInterval(varname);
            if (confidenceInterval == null || confidenceInterval.isEmpty()) {
                return;
            }
            confidenceInterval.compute(30, 0.05, 0.95);
            pResultsPaneController.majConfidenceInterval(varname, confidenceInterval, true);
        }
    }

    public void setTimeProgessVisible(boolean pVisible) {
        this.lblTMax.setVisible(pVisible);
        this.boxTMax.setVisible(pVisible);
    }
}

