/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.compute.ConfidenceInterval;
import fr.geonosis.karstmod.ihm.ModalResizableAlert;
import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.viewfx.CalibrationResultsPaneController;
import fr.geonosis.karstmod.viewfx.FormDecorator;
import fr.geonosis.karstmod.viewfx.ResultsPaneController;
import fr.geonosis.karstmod.viewfx.RunDialogPaneController;
import fr.geonosis.karstmod.viewfx.StylesV2;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class RunDialog
extends Stage {
    private RunDialogPaneController fController;

    public static RunDialog getInstance() {
        return RunDialogHolder.INSTANCE;
    }

    private RunDialog() {
        Pane dialogContent;
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        loader.setLocation(((Object)((Object)this)).getClass().getResource("RunDialogPane.fxml"));
        try {
            dialogContent = (Pane)loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
            new ModalResizableAlert(Alert.AlertType.ERROR, "Internal error when loading run dialog. Karstmod is going to be closed", new ButtonType[0]).showAndWait();
            System.exit(1);
            return;
        }
        this.fController = (RunDialogPaneController)loader.getController();
        this.setTitle("Run in progress...");
        this.initModality(Modality.APPLICATION_MODAL);
        this.initStyle(StageStyle.UNDECORATED);
        Scene scene = new Scene((Parent)new FormDecorator(this, (Node)dialogContent));
        scene.setFill(null);
        scene.getStylesheets().add((Object)StylesV2.class.getResource("km.css").toExternalForm());
        this.setScene(scene);
    }

    public void showDialog(KarstModConfig pConfig, ResultsPaneController pResultsPane, CalibrationResultsPaneController pCalibrationResultsPaneController, boolean pComputeCI) {
        this.fController.setConfig(pConfig, pResultsPane, pCalibrationResultsPaneController, pComputeCI);
        this.showAndWait();
    }

    public ConfidenceInterval getConfidenceInterval(Varname pVarname) {
        return this.fController.getConfidenceInterval(pVarname);
    }

    public boolean hasCI() {
        return this.fController.hasCI();
    }

    private static class RunDialogHolder {
        private static final RunDialog INSTANCE = new RunDialog();

        private RunDialogHolder() {
        }
    }
}

