/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.modele.IParametrable;
import fr.geonosis.karstmod.modele.ParamChoiceType;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.viewfx.AbstractParamPaneController;
import fr.geonosis.karstmod.viewfx.CheckParamPaneController;
import fr.geonosis.karstmod.viewfx.ChoiceParamPaneController;
import fr.geonosis.karstmod.viewfx.ParamConstraintPaneController;
import fr.geonosis.karstmod.viewfx.ParamPaneController;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;

public class ParamPaneFactory {
    public static AbstractParamPaneController createPaneController(Parameter pParameter, ParamChoiceType pChoiceType) throws IOException {
        if (pParameter.hasValue()) {
            FXMLLoader loader = new FXMLLoader();
            loader.setClassLoader(ParamPaneFactory.class.getClassLoader());
            loader.setLocation(ParamPaneController.class.getResource("ParamPane.fxml"));
            loader.load();
            ParamPaneController paramPaneController = (ParamPaneController)loader.getController();
            paramPaneController.setParameter(pParameter);
            return paramPaneController;
        }
        if (Objects.requireNonNull(pChoiceType) == ParamChoiceType.RADIO) {
            return new ChoiceParamPaneController(pParameter);
        }
        return new CheckParamPaneController(pParameter);
    }

    public static void createAll(Pane pRoot, IParametrable pParametrable, boolean pTop) throws IOException {
        List<Parameter> parameters = pParametrable.getParameters();
        if (parameters.size() == 0) {
            return;
        }
        HBox hParamsBox = new HBox(10.0);
        ToggleGroup toggleGroup = new ToggleGroup();
        HashMap<Parameter, AbstractParamPaneController> map = new HashMap<Parameter, AbstractParamPaneController>();
        for (Parameter parameter : parameters) {
            AbstractParamPaneController n;
            if (pTop != parameter.isTop()) continue;
            if (parameter.getAttrName().startsWith("to ")) {
                n = ParamPaneFactory.createPaneController(parameter, pParametrable.getParamChoiceType());
                hParamsBox.getChildren().add((Object)n.getRootNode());
            } else {
                n = ParamPaneFactory.createPaneController(parameter, pParametrable.getParamChoiceType());
                pRoot.getChildren().add((Object)n.getRootNode());
            }
            map.put(parameter, n);
            if (n.getRootNode() instanceof RadioButton) {
                ((RadioButton)n.getRootNode()).setToggleGroup(toggleGroup);
            }
            if (parameter.getConstraint() == null) continue;
            FXMLLoader loader = new FXMLLoader();
            loader.setClassLoader(ParamPaneFactory.class.getClassLoader());
            loader.setLocation(ParamConstraintPaneController.class.getResource("ParamConstraintPane.fxml"));
            Node paramBox = (Node)loader.load();
            ParamConstraintPaneController paramConstraintPaneController = (ParamConstraintPaneController)loader.getController();
            paramConstraintPaneController.setParameter(parameter);
            pRoot.getChildren().add((Object)paramBox);
        }
        for (Map.Entry entry : map.entrySet()) {
            for (Parameter param : ((Parameter)entry.getKey()).getValidateChainedParameters()) {
                ((AbstractParamPaneController)entry.getValue()).addChainedValidationFor((AbstractParamPaneController)map.get(param));
            }
        }
        if (!hParamsBox.getChildren().isEmpty()) {
            pRoot.getChildren().add(0, (Object)hParamsBox);
        }
    }
}

