/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.utils.csv.parser;

import fr.geonosis.karstmod.utils.csv.parser.DataParseException;
import fr.geonosis.karstmod.utils.csv.parser.IColumnType;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;

public class UtcDateTimeType
implements IColumnType<ZonedDateTime> {
    private static final ZoneId UTC = ZoneId.of("UTC");
    private final String[] fPatterns;
    private DateTimeFormatter fFormatter;

    public UtcDateTimeType(String ... pPatterns) {
        if (Objects.isNull(pPatterns)) {
            throw new IllegalArgumentException("patterns cannot be null");
        }
        if (pPatterns.length == 0) {
            throw new IllegalArgumentException("patterns cannot be empty");
        }
        this.fPatterns = pPatterns;
    }

    @Override
    public ZonedDateTime parse(String pValue) throws DataParseException {
        if (pValue.isBlank()) {
            return null;
        }
        try {
            if (this.fFormatter == null) {
                for (String pattern : this.fPatterns) {
                    this.fFormatter = DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.of("UTC"));
                    try {
                        this.fFormatter.parse(pValue.trim());
                        break;
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                    }
                }
            }
            TemporalAccessor temporalAccessor = this.fFormatter.parse(pValue.trim());
            return ZonedDateTime.of(temporalAccessor.get(ChronoField.YEAR), temporalAccessor.get(ChronoField.MONTH_OF_YEAR), temporalAccessor.get(ChronoField.DAY_OF_MONTH), temporalAccessor.isSupported(ChronoField.HOUR_OF_DAY) ? temporalAccessor.get(ChronoField.HOUR_OF_DAY) : 0, temporalAccessor.isSupported(ChronoField.MINUTE_OF_HOUR) ? temporalAccessor.get(ChronoField.MINUTE_OF_HOUR) : 0, temporalAccessor.isSupported(ChronoField.SECOND_OF_MINUTE) ? temporalAccessor.get(ChronoField.SECOND_OF_MINUTE) : 0, temporalAccessor.isSupported(ChronoField.NANO_OF_SECOND) ? temporalAccessor.get(ChronoField.NANO_OF_SECOND) : 0, ZoneId.of("UTC"));
        }
        catch (Exception pE) {
            throw new DataParseException("bad datetime format for input " + pValue);
        }
    }

    @Override
    public String format(ZonedDateTime pValue) {
        if (pValue == null) {
            return "";
        }
        return this.fFormatter.format(pValue);
    }

    public DateTimeFormatter getFormatter() {
        return this.fFormatter;
    }

    @Override
    public void reset() {
        this.fFormatter = null;
    }
}

