/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.model.rk4;

import fr.geonosis.karstmod.run.model.rk4.IFunction;
import java.util.Locale;

public class RungeKutta4 {
    private final IFunction fFunction;

    public RungeKutta4(IFunction pFunction) {
        this.fFunction = pFunction;
    }

    public static void test1(String[] args) {
        Locale.setDefault(Locale.ENGLISH);
        double dt = 1.0;
        int n = (int)(1200.0 / dt);
        double RA = 3000000.0;
        double B = 8.64E7;
        final double[] P = new double[n];
        P[9] = 40.0;
        double[] H = new double[n];
        double[] Q = new double[n];
        double t0 = 0.0;
        RungeKutta4 rk4 = new RungeKutta4(new IFunction(){
            final double kES = 0.001;
            final double kEC = 0.0;
            final double uref = 1.0;
            final double alpha = 2.0;
            final double Threshold = 0.0;

            @Override
            public double uprime(double t0, double t, double u) {
                if (u <= 0.0) {
                    return 0.0;
                }
                return -0.001 * Math.pow((u - 0.0) / 1.0, 2.0) - 0.0 * u + P[(int)t0];
            }
        });
        H[0] = 50.0;
        double u0 = H[0];
        System.out.printf("%d\t%2.4f\n", 0, Q[0]);
        for (int i = 0; i < n - 1; ++i) {
            double t1 = t0 + dt;
            double u1 = rk4.next(t0, u0, dt);
            t0 = t1;
            u0 = u1;
            H[i + 1] = u1;
            Q[i + 1] = H[i + 1] - H[i] - P[i];
            System.out.printf("%d\t%.6g\n", i + 1, Q[i + 1] * RA / B);
        }
    }

    public static void test2(String[] args) {
        Locale.setDefault(Locale.ENGLISH);
        double dt = 1.0;
        int n = (int)(1200.0 / dt);
        double RA = 3000000.0;
        double B = 8.64E7;
        final double[] P = new double[n];
        P[9] = 40.0;
        double[] H = new double[n];
        double[] Q = new double[n];
        double t0 = 0.0;
        RungeKutta4 rk4 = new RungeKutta4(new IFunction(){
            final double kES = 0.001;
            final double kEC = 0.0;
            final double uref = 1.0;
            final double alpha = 2.0;
            final double Threshold = 0.0;

            @Override
            public double uprime(double t0, double t, double u) {
                if (u <= 0.0) {
                    return 0.0;
                }
                return -0.001 * Math.pow((u - 0.0) / 1.0, 2.0) - 0.0 * u + P[(int)t0];
            }
        });
        H[0] = 50.0;
        double u0 = H[0];
        System.out.printf("%d\t%2.4f\n", 0, Q[0]);
        for (int i = 0; i < n - 1; ++i) {
            double t1 = t0 + dt;
            double u1 = rk4.next(t0, u0, dt);
            t0 = t1;
            u0 = u1;
            H[i + 1] = u1;
            Q[i + 1] = H[i + 1] - H[i] - P[i];
            System.out.printf("%d\t%.6g\n", i + 1, Q[i + 1] * RA / B);
        }
    }

    public double next(double t0, double u0, double dt) {
        double f0 = this.fFunction.uprime(t0, t0, u0);
        double t1 = t0 + dt / 2.0;
        double u1 = u0 + dt * f0 / 2.0;
        double f1 = this.fFunction.uprime(t0, t1, u1);
        double t2 = t0 + dt / 2.0 + 0.0;
        double u2 = u0 + dt * f1 / 2.0 + 0.0;
        double f2 = this.fFunction.uprime(t0, t2, u2);
        double t3 = t0 + dt;
        double u3 = u0 + dt * f2;
        double f3 = this.fFunction.uprime(t0, t3, u3);
        return u0 + dt * (f0 + 2.0 * f1 + 2.0 * f2 + f3) / 6.0;
    }

    public static void main(String[] args) {
        RungeKutta4.test1(args);
    }
}

