/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.model.paramvalue;

import fr.geonosis.karstmod.modele.Parameter;

public abstract class ParamValue {
    private final Parameter fParameter;
    private double fValue;
    private double fMin;
    private double fMax;
    private double fBestValue;

    ParamValue(Parameter pParameter) {
        this.fParameter = pParameter;
        this.fValue = pParameter.getValue();
        this.fMin = pParameter.getMin();
        this.fMax = pParameter.getMax();
        this.fBestValue = this.fValue;
    }

    public abstract void init(double var1);

    public boolean needsInit() {
        return this.fMax != this.fMin || this.fParameter.getConstraint() != null && this.fParameter.getConstraint().isActive();
    }

    public double getMin() {
        return this.fMin;
    }

    public double getMax() {
        return this.fMax;
    }

    public void setValue(double pValue) {
        this.fValue = pValue;
    }

    public double getValue() {
        return this.fValue;
    }

    public void setMin(double pMin) {
        this.fMin = pMin;
    }

    public void setMax(double pMax) {
        this.fMax = pMax;
    }

    public boolean lesserThan(ParamValue pOther) {
        return this.fValue < pOther.fValue;
    }

    public void swapValueWith(ParamValue pOther) {
        double tmp = this.fValue;
        this.fValue = pOther.getValue();
        pOther.fValue = tmp;
    }

    public double getBestValue() {
        return this.fBestValue;
    }

    public void setBestValue(double pBestValue) {
        this.fBestValue = pBestValue;
    }

    public void saveBest() {
        this.fBestValue = this.fValue;
    }

    public void updateValueWithBest() {
        this.fValue = this.fBestValue;
        this.fParameter.setValue(this.fBestValue);
    }

    public Parameter getParameter() {
        return this.fParameter;
    }
}

