/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run;

public class SSIRunnerData {
    private double[] fS;
    private double[] fSt;
    private double fSumy;
    private double fSumy2;
    private int fNy;
    private double[] fA;
    private double[] fB;
    private double[][] fAB;

    public SSIRunnerData(int pNbParams) {
        this.fS = new double[pNbParams];
        this.fSt = new double[pNbParams];
        this.fSumy = 0.0;
        this.fSumy2 = 0.0;
        this.fNy = 0;
        this.fA = new double[0];
        this.fB = new double[0];
        this.fAB = new double[0][0];
    }

    public SSIRunnerData(double[] pS, double[] pSt, double pSumy, double pSumy2, int pNy, double[] pA, double[] pB, double[][] pAB) {
        this.fS = pS;
        this.fSt = pSt;
        this.fSumy = pSumy;
        this.fSumy2 = pSumy2;
        this.fNy = pNy;
        this.fA = pA;
        this.fB = pB;
        this.fAB = pAB;
    }

    public double[] getS() {
        return (double[])this.fS.clone();
    }

    public double[] getSt() {
        return (double[])this.fSt.clone();
    }

    public double getSumy() {
        return this.fSumy;
    }

    public double getSumy2() {
        return this.fSumy2;
    }

    public int getNy() {
        return this.fNy;
    }

    public int length() {
        return this.fA.length;
    }

    public double[] getA() {
        return this.fA;
    }

    public double[] getB() {
        return this.fB;
    }

    public double[][] getAB() {
        return this.fAB;
    }

    public void update(double[] pS, double[] pSt, double pSumy, double pSumy2, int pNy, double[] pA, double[] pB, double[][] pAB) {
        this.fS = pS;
        this.fSt = pSt;
        this.fSumy = pSumy;
        this.fSumy2 = pSumy2;
        this.fNy = pNy;
        this.fA = SSIRunnerData.concat(this.fA, pA);
        this.fB = SSIRunnerData.concat(this.fB, pB);
        this.fAB = SSIRunnerData.concat(this.fAB, pAB);
    }

    private static double[] concat(double[] pT1, double[] pT2) {
        if (pT1.length > 0) {
            double[] tmp = new double[pT1.length + pT2.length];
            System.arraycopy(pT1, 0, tmp, 0, pT1.length);
            System.arraycopy(pT2, 0, tmp, pT1.length, pT2.length);
            return tmp;
        }
        return pT2;
    }

    private static double[][] concat(double[][] pT1, double[][] pT2) {
        if (pT1.length == 0) {
            return pT2;
        }
        double[][] tmp = new double[pT1.length][pT1[0].length];
        for (int i = 0; i < pT1.length; ++i) {
            tmp[i] = SSIRunnerData.concat(pT1[i], pT2[i]);
        }
        return tmp;
    }
}

