/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run;

import fr.geonosis.karstmod.KarstModException;
import fr.geonosis.karstmod.KarstModLogger;
import fr.geonosis.karstmod.compute.ConfidenceInterval;
import fr.geonosis.karstmod.compute.ProbableDischarge;
import fr.geonosis.karstmod.modele.ConcurrentParameterValueSet;
import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.MessageType;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.StageBounds;
import fr.geonosis.karstmod.modele.obj.GlobalObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.WobjResult;
import fr.geonosis.karstmod.modele.obj.WobjRunResults;
import fr.geonosis.karstmod.modele.obj.WobjValues;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.run.AbstractMonitor;
import fr.geonosis.karstmod.run.IRunListener;
import fr.geonosis.karstmod.run.ParamsOutArray;
import fr.geonosis.karstmod.run.RunMonitorListener;
import fr.geonosis.karstmod.run.model.ModelRunner;
import fr.geonosis.karstmod.run.model.RunModel;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class RunMonitor
extends AbstractMonitor {
    private final long fTmax;
    private int fNobj;
    private final double fWobjMin;
    private final Map<Varname, ConfidenceInterval> fConfidenceIntervals;
    private final WobjResult fWobjValidationForCalibrationBest;
    private final WobjResult fWobjCalibrationBest;
    private final KarstModConfig fConfig;
    private final Object fLock = new Object();
    private AtomicInteger fNobjRun;
    private long fTop;
    private ModelRunner fBestModelRunner;
    private ProbableDischarge fProbableDischarge;
    private ParamsOutArray fParamsOutArray;
    private boolean fUseTmax;

    public RunMonitor(KarstModConfig pConfig, boolean pComputeCI) {
        super(pConfig.getModel(), pConfig.getRunParameters().getWarmupBeginning(), (List<StageBounds>)pConfig.getRunParameters().getCalibrationStages(), (List<StageBounds>)pConfig.getRunParameters().getValidationStages(), pConfig.getRunParameters().getWobjFunction());
        this.fConfig = pConfig;
        this.fTmax = pConfig.getRunParameters().getMaxTime().intValue();
        this.fUseTmax = true;
        this.fNobj = pConfig.getRunParameters().getNObj();
        this.fWobjMin = pConfig.getRunParameters().getWobjMin();
        if (pComputeCI) {
            this.fConfidenceIntervals = new EnumMap<Varname, ConfidenceInterval>(Varname.class);
            for (Varname varname : Varname.values()) {
                if (!pConfig.getModel().useVar(varname)) continue;
                this.fConfidenceIntervals.put(varname, new ConfidenceInterval((List<StageBounds>)this.fConfig.getRunParameters().getCalibrationStages(), (List<StageBounds>)this.fConfig.getRunParameters().getValidationStages()));
            }
        } else {
            this.fConfidenceIntervals = null;
        }
        double[] tab = new double[pConfig.getRunParameters().getWobjFunction().getActivePartNumber()];
        Arrays.fill(tab, Double.NEGATIVE_INFINITY);
        this.fWobjCalibrationBest = new WobjResult(tab);
        this.fWobjValidationForCalibrationBest = new WobjResult(tab);
    }

    public int getNObj() {
        return this.fNobj;
    }

    public boolean mustRetain(double pWobj) {
        return pWobj >= this.fWobjMin && this.fNobjRun.get() < this.fNobj;
    }

    @Override
    public boolean isDone() {
        if (this.isStopped()) {
            return true;
        }
        if (!this.fUseTmax) {
            return false;
        }
        long top = System.currentTimeMillis();
        if (top - this.fTop >= this.fTmax * 1000L) {
            this.cancel();
            return true;
        }
        return this.fNobjRun.get() >= this.fNobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireWorked(WobjResult pWObjCalibration, WobjResult pWObjValidation, ModelRunner pModelRunner) {
        Object object = this.fLock;
        synchronized (object) {
            if (pWObjCalibration.getRes() >= this.fWobjMin) {
                this.fNobjRun.incrementAndGet();
                if (pWObjCalibration.getRes() > this.fWobjCalibrationBest.getRes() || pWObjCalibration.getRes() == this.fWobjCalibrationBest.getRes() && pWObjValidation.getRes() > this.fWobjValidationForCalibrationBest.getRes()) {
                    this.fBestModelRunner = pModelRunner;
                    this.fWobjCalibrationBest.copy(pWObjCalibration);
                    this.fWobjValidationForCalibrationBest.copy(pWObjValidation);
                    this.fireWorked();
                    return true;
                }
                this.fireWorked();
            }
            return false;
        }
    }

    private void fireWorked() {
        for (IRunListener listener : this.getListeners()) {
            ((RunMonitorListener)listener).worked(this.fWobjCalibrationBest, this.fWobjValidationForCalibrationBest, this.fNobjRun.intValue());
        }
    }

    public WobjRunResults doCalibration() throws Exception {
        return this.doCalibration(null, null);
    }

    public WobjRunResults doCalibration(Map<Parameter, double[]> pParamValueSet, String pOutputDir) throws KarstModException, InterruptedException {
        ConcurrentParameterValueSet cpvs;
        this.start();
        this.fNobjRun = new AtomicInteger();
        this.fBestModelRunner = null;
        this.fProbableDischarge = new ProbableDischarge(this.getCalibrationStages(), this.getValidationStages());
        int nbTasks = this.getNumberOfTasks();
        ExecutorService eservice = Executors.newWorkStealingPool(nbTasks);
        ExecutorCompletionService<Object> cservice = new ExecutorCompletionService<Object>(eservice);
        this.fTop = System.currentTimeMillis();
        int nObjMax = this.fNobj + nbTasks;
        MessageList msgs = new MessageList();
        this.fParamsOutArray = new ParamsOutArray(nObjMax, new ModelRunner(this.fConfig, this.getGlobalStage()).getRunModel().getActiveParameters());
        ConcurrentParameterValueSet concurrentParameterValueSet = cpvs = pParamValueSet != null ? new ConcurrentParameterValueSet(pParamValueSet) : null;
        if (cpvs != null) {
            this.fNobj = cpvs.size();
        }
        for (int i = 0; i < nbTasks; ++i) {
            cservice.submit(() -> {
                try {
                    return new ModelRunner(this.fConfig, this.getGlobalStage()).doCalibration(this, nObjMax, this.fWobjMin, cpvs, pOutputDir);
                }
                catch (Exception ex) {
                    msgs.add(MessageType.ERROR, ex.getMessage());
                    KarstModLogger.severe("Run error", ex, false);
                    return null;
                }
            });
        }
        WobjRunResults results = new WobjRunResults(this.getWobj(), this.fNobj, this.fWobjCalibrationBest, this.fWobjValidationForCalibrationBest);
        for (int i = 0; i < nbTasks; ++i) {
            try {
                results.merge((WobjRunResults)cservice.take().get());
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                KarstModLogger.severe("Results merge error", e, false);
                throw new InterruptedException();
            }
        }
        eservice.shutdown();
        this.getListeners().clear();
        if (msgs.has(MessageType.ERROR)) {
            throw new KarstModException(msgs.toBasicString());
        }
        if (this.fBestModelRunner != null) {
            this.fBestModelRunner.updateParametersWithBestValues();
        } else {
            for (Parameter p : this.fConfig.getModel().getActiveParameters()) {
                p.resetToMidValue();
            }
        }
        this.doRun(false);
        return results;
    }

    public ParamsOutArray getParamsOutArray() {
        return this.fParamsOutArray;
    }

    public WobjRunResults doRun(GlobalObjectiveFunction pWobj) {
        this.fBestModelRunner = new ModelRunner(this.fConfig, this.getGlobalStage(), pWobj);
        WobjValues wobjResult = this.fBestModelRunner.doRun(this.getCalibrationStages(), this.getValidationStages(), this.fNobj + this.getNumberOfTasks(), this.fWobjMin);
        return new WobjRunResults(this.getWobj(), 1, wobjResult.getCalibration(), wobjResult.getValidation());
    }

    public WobjRunResults doRun(boolean bInitParamsOut) {
        this.fBestModelRunner = new ModelRunner(this.fConfig, this.getGlobalStage());
        if (bInitParamsOut) {
            this.fParamsOutArray = new ParamsOutArray(this.fNobj, this.fBestModelRunner.getRunModel().getActiveParameters());
        }
        WobjValues wobjResult = this.fBestModelRunner.doRun(this.getCalibrationStages(), this.getValidationStages(), this.fNobj + this.getNumberOfTasks(), this.fWobjMin);
        this.addOutput(wobjResult, this.fBestModelRunner.getRunModel().activeParamValues());
        return new WobjRunResults(this.getWobj(), 1, wobjResult.getCalibration(), wobjResult.getValidation());
    }

    public WobjResult getWobjCalibrationBest() {
        return this.fWobjCalibrationBest;
    }

    public WobjResult getWobjValidationForCalibrationBest() {
        return this.fWobjValidationForCalibrationBest;
    }

    public int getNobjRun() {
        return this.fNobjRun.get();
    }

    public void addOutput(WobjValues pWobjValues, double[] pParamValues) {
        this.fParamsOutArray.add(pWobjValues, pParamValues);
    }

    public void addOutput(Varname pVarname, double[] pOutput, WobjValues pWobjValues, double[] pParamValues) {
        if (this.fConfidenceIntervals != null) {
            this.fConfidenceIntervals.get((Object)pVarname).addOutput(pOutput, pWobjValues);
        }
        if (pVarname == Varname.QS) {
            this.fProbableDischarge.add(pOutput, pWobjValues);
            this.fParamsOutArray.add(pWobjValues, pParamValues);
        }
    }

    public RunModel getBestRunModel() {
        return this.fBestModelRunner.getRunModel();
    }

    public ProbableDischarge getProbableDischarge() {
        return this.fProbableDischarge;
    }

    public ConfidenceInterval getConfidenceInterval(Varname pVarname) {
        return this.fConfidenceIntervals == null ? null : this.fConfidenceIntervals.get((Object)pVarname);
    }

    public boolean hasCI() {
        return this.fConfidenceIntervals != null;
    }

    public KarstModConfig getConfig() {
        return this.fConfig;
    }

    public void setUseTmax(boolean pUseTmax) {
        this.fUseTmax = pUseTmax;
    }
}

