/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.obj.parser;

import fr.geonosis.karstmod.modele.ColumnName;
import fr.geonosis.karstmod.modele.obj.AbstractObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.BE;
import fr.geonosis.karstmod.modele.obj.KGE;
import fr.geonosis.karstmod.modele.obj.KGENP;
import fr.geonosis.karstmod.modele.obj.NSE;
import fr.geonosis.karstmod.modele.obj.RPearson;
import fr.geonosis.karstmod.modele.obj.RSpearman;
import fr.geonosis.karstmod.modele.obj.VE;
import java.util.Arrays;

public enum Varname {
    QS("QS", "Q<sub>S</sub>", ColumnName.QOBSS, true),
    QLOSS("Qloss", "Q<sub>loss</sub>", ColumnName.QLOSS, true),
    ZE("ZE", "Piezo<sub>E</sub>", ColumnName.ZOBSE, false),
    ZL("ZL", "Piezo<sub>L</sub>", ColumnName.ZOBSL, false),
    ZM("ZM", "Piezo<sub>M</sub>", ColumnName.ZOBSM, false),
    ZC("ZC", "Piezo<sub>C</sub>", ColumnName.ZOBSC, false);

    private final String fLabel;
    private final String fHtmlLabel;
    private final ColumnName fColumnName;
    private final boolean fDischarge;

    private Varname(String pLabel, String pHtmlLabel, ColumnName pColumnName, boolean pDischarge) {
        this.fLabel = pLabel;
        this.fHtmlLabel = pHtmlLabel;
        this.fColumnName = pColumnName;
        this.fDischarge = pDischarge;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public String getHtmlLabel() {
        return this.fHtmlLabel;
    }

    public ColumnName getColumnName() {
        return this.fColumnName;
    }

    public String toString() {
        return this.fLabel;
    }

    public boolean canBeUsedIn(Class<? extends AbstractObjectiveFunction> pClass) {
        return Arrays.stream(this.getAllowedFunc()).anyMatch(c -> c == pClass);
    }

    public Class<? extends AbstractObjectiveFunction>[] getAllowedFunc() {
        if (this.fDischarge) {
            return new Class[]{RPearson.class, VE.class, BE.class, KGENP.class, KGE.class, NSE.class, RSpearman.class};
        }
        return new Class[]{RPearson.class, KGENP.class, KGE.class, NSE.class, RSpearman.class};
    }
}

