/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.obj;

import fr.geonosis.karstmod.modele.StageBounds;
import fr.geonosis.karstmod.modele.obj.WobjDataConverter;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.utils.csv.DoubleRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class WobjVar {
    private final DoubleRange fRange;
    private final Varname fVarName;
    private final String fLabel;
    private final String fRangeLabel;
    private final WobjDataConverter fConverter;
    private double[] fData;
    private int[] fIndices;
    private double fSum = Double.NaN;
    private double fMean = Double.NaN;
    private double fMeanDev2 = Double.NaN;
    private double fStdDev = Double.NaN;
    private double[] fFdc;
    private double[] fRank;
    private double fRankSum = Double.NaN;
    private double fRankMean = Double.NaN;
    private double fRankMeanDev2 = Double.NaN;
    private double fRankStdDev = Double.NaN;

    private WobjVar(DoubleRange pRange, Varname pVarName, WobjDataConverter pConverter) {
        Double max;
        this.fVarName = pVarName;
        this.fRange = pRange;
        this.fConverter = pConverter;
        this.fLabel = pConverter.getVarnameConverter().apply(pVarName);
        Object s = this.fLabel;
        Double min = this.fRange == null ? null : this.fRange.min();
        Double d = max = this.fRange == null ? null : this.fRange.max();
        if (min != null && max != null) {
            s = (String)s + " \u2208 [" + min + ", " + max + "]";
        } else if (min != null) {
            s = (String)s + " \u2265 " + min;
        } else if (max != null) {
            s = (String)s + " \u2264 " + max;
        }
        this.fRangeLabel = s;
    }

    public WobjVar(Varname pVarName, double[] pData, DoubleRange pRange, WobjDataConverter pConverter, List<StageBounds> pStageBounds) {
        this(pRange, pVarName, pConverter);
        if (pData == null) {
            throw new UnsupportedOperationException("no data for " + pVarName);
        }
        ArrayList<Integer> indices = new ArrayList<Integer>(pData.length);
        Function<Double, Double> dataConverter = pConverter.getDataConverter();
        this.fData = new double[pData.length];
        boolean n = false;
        for (StageBounds p : pStageBounds) {
            for (int i = p.getDebut(); i <= p.getFin(); ++i) {
                if (!Double.isNaN(pData[i]) && (pRange == null || pRange.contains(pData[i]))) {
                    indices.add(i);
                    this.fData[i] = dataConverter.apply(pData[i]);
                    continue;
                }
                this.fData[i] = Double.NaN;
            }
        }
        this.fIndices = indices.stream().mapToInt(Integer::intValue).toArray();
    }

    public Varname getVarName() {
        return this.fVarName;
    }

    public String label() {
        return this.fLabel;
    }

    public String rangeLabel() {
        return this.fRangeLabel;
    }

    public double get(int pIndice) {
        return this.fData[pIndice];
    }

    public double getRank(int pIndice) {
        return this.fRank[pIndice];
    }

    public double getFdc(int pIndice) {
        return this.fFdc[pIndice];
    }

    public double getSum() {
        return this.fSum;
    }

    public double getMean() {
        return this.fMean;
    }

    public double getMeanDev2() {
        return this.fMeanDev2;
    }

    public double getStdDev() {
        return this.fStdDev;
    }

    public double[] getRank() {
        return this.fRank;
    }

    public double getRankMean() {
        return this.fRankMean;
    }

    public double getRankStdDev() {
        return this.fRankStdDev;
    }

    public void computeSum() {
        if (Double.isNaN(this.fSum)) {
            this.fSum = this.sum(this.fData);
        }
    }

    public void computeMean() {
        if (Double.isNaN(this.fMean)) {
            this.computeSum();
            this.fMean = this.mean(this.fSum);
        }
    }

    public void computeMeanDev2() {
        if (Double.isNaN(this.fMeanDev2)) {
            this.computeMean();
            this.fMeanDev2 = this.meanDev2(this.fData, this.fMean);
        }
    }

    public void computeStdDev() {
        if (Double.isNaN(this.fStdDev)) {
            this.computeMeanDev2();
            this.fStdDev = this.stdDev(this.fMeanDev2);
        }
    }

    public void computeRank() {
        if (Objects.isNull(this.fRank)) {
            this.fRank = this.rank(this.fData);
        }
    }

    public void computeFdc() {
        if (Objects.isNull(this.fFdc)) {
            this.computeMean();
            this.fFdc = new double[this.fData.length];
            Arrays.fill(this.fFdc, Double.NaN);
            int n = this.fIndices.length;
            for (int i : this.fIndices) {
                this.fFdc[i] = this.fData[i] / (this.fMean * (double)n);
            }
            Arrays.sort(this.fFdc);
        }
    }

    public void computeRankSum() {
        if (Double.isNaN(this.fRankSum)) {
            this.computeRank();
            this.fRankSum = this.sum(this.fRank);
        }
    }

    public void computeRankMean() {
        if (Double.isNaN(this.fRankMean)) {
            this.computeRankSum();
            this.fRankMean = this.mean(this.fRankSum);
        }
    }

    public void computeRankMeanDev2() {
        if (Double.isNaN(this.fRankMeanDev2)) {
            this.computeRankMean();
            this.fRankMeanDev2 = this.meanDev2(this.fRank, this.fRankMean);
        }
    }

    public void computeRankStdDev() {
        if (Double.isNaN(this.fRankStdDev)) {
            this.computeRankMeanDev2();
            this.fRankStdDev = this.stdDev(this.fRankMeanDev2);
        }
    }

    private double sum(double[] pData) {
        double sum = 0.0;
        int[] nArray = this.fIndices;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            sum += pData[i2];
        }
        return sum;
    }

    private double mean(double pSum) {
        return pSum / (double)this.fIndices.length;
    }

    private double meanDev2(double[] pData, double pMean) {
        double meanDev2 = 0.0;
        int[] nArray = this.fIndices;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            double sig = pData[i2] - pMean;
            meanDev2 += sig * sig;
        }
        return meanDev2;
    }

    private double stdDev(double pMeanErr2) {
        return Math.sqrt(pMeanErr2 / (double)(this.fIndices.length - 1));
    }

    private double[] rank(double[] pData) {
        int j;
        double v;
        int i;
        double[] t = (double[])pData.clone();
        Arrays.sort(t);
        int deb = 0;
        double cur = t[deb];
        double[] r = new double[t.length];
        r[0] = 1.0;
        for (i = 1; i < t.length; ++i) {
            if (t[i] == cur) continue;
            if (i > deb + 1) {
                v = (double)(i + deb + 1) / 2.0;
                for (j = deb; j < i; ++j) {
                    r[j] = v;
                }
            }
            r[i] = i + 1;
            cur = t[i];
            deb = i;
        }
        if (i > deb + 1) {
            v = (double)(i + deb + 1) / 2.0;
            for (j = deb; j < i; ++j) {
                r[j] = v;
            }
        }
        double[] rank = new double[t.length];
        for (int j2 : this.fIndices) {
            rank[j2] = r[Arrays.binarySearch(t, pData[j2])];
        }
        return rank;
    }

    public int[] getIndices() {
        return this.fIndices;
    }

    public int size() {
        return this.fData.length;
    }

    public WobjVar copyWith(double[] pData) {
        WobjVar var = new WobjVar(this.fRange, this.fVarName, this.fConverter);
        var.fIndices = this.fIndices;
        var.fData = new double[pData.length];
        Function<Double, Double> dataConverter = this.fConverter.getDataConverter();
        for (int i : this.fIndices) {
            var.fData[i] = dataConverter.apply(pData[i]);
        }
        return var;
    }
}

