/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.obj;

import fr.geonosis.karstmod.modele.obj.AbstractObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.NSE;
import fr.geonosis.karstmod.modele.obj.ObjectiveFunctionFactory;
import fr.geonosis.karstmod.modele.obj.WobjDataConverter;
import fr.geonosis.karstmod.modele.obj.parser.Part;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.utils.csv.DoubleRange;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class ObjectiveFunctionDescriptor
implements Cloneable {
    private static final String KEY_HIGH = "high";
    private static final String KEY_LOW = "low";
    private static final String KEY_CLASS = "class";
    private static final String KEY_WEIGHT = "w";
    private static final String KEY_ELEMENT_NAME = "elt-name";
    private static final String KEY_CONVERTER_NAME = "converter";
    private static final String KEY_PARAMETERS_NAME = "parameters";
    private final DoubleRange fRange;
    private final Class<? extends AbstractObjectiveFunction> fFunctionClass;
    private final WobjDataConverter fConverter;
    private final double fWeight;
    private final Varname fVarname;
    private final List<AbstractObjectiveFunction.FctParam> fParameters;

    public ObjectiveFunctionDescriptor(Part pPart) {
        this(pPart.getCoef(), pPart.getFunctionClass(), pPart.getVarName(), pPart.getConverter(), pPart.getRange(), pPart.getParameters());
    }

    public ObjectiveFunctionDescriptor(double pWeight, Class<? extends AbstractObjectiveFunction> pFunctionClass, Varname pVarName, WobjDataConverter pConverter, DoubleRange pRange, List<AbstractObjectiveFunction.FctParam> pParameters) {
        this.fWeight = pWeight;
        this.fRange = pRange;
        this.fParameters = pParameters == null ? new ArrayList() : pParameters;
        this.fFunctionClass = pFunctionClass;
        this.fVarname = pVarName;
        this.fConverter = pConverter;
    }

    public ObjectiveFunctionDescriptor(Properties pProperties, String pPrefixe) throws Exception {
        try {
            String className = pProperties.getProperty(pPrefixe + KEY_CLASS, NSE.class.getCanonicalName());
            if (className.contains("NSESqrt")) {
                className = className.replaceAll("NSESqrt", "NSE");
                pProperties.setProperty(pPrefixe + KEY_CONVERTER_NAME, WobjDataConverter.SQRT.name());
            }
            this.fWeight = !pProperties.containsKey(pPrefixe + KEY_WEIGHT) ? (pPrefixe.endsWith("f1.") ? Double.parseDouble(pProperties.getProperty(pPrefixe.replaceAll("f1\\.", "") + KEY_WEIGHT)) : (pPrefixe.endsWith("f2.") ? 1.0 - Double.parseDouble(pProperties.getProperty(pPrefixe.replaceAll("f2\\.", "") + KEY_WEIGHT)) : 0.0)) : Double.parseDouble(pProperties.getProperty(pPrefixe + KEY_WEIGHT));
            this.fFunctionClass = Class.forName(className);
            String sLow = pProperties.getProperty(pPrefixe + KEY_LOW, null);
            Double low = sLow == null ? null : Double.valueOf(sLow);
            String sHigh = pProperties.getProperty(pPrefixe + KEY_HIGH, null);
            Double high = sHigh == null ? null : Double.valueOf(sHigh);
            this.fRange = new DoubleRange(low, high);
            this.fVarname = Varname.valueOf(pProperties.getProperty(pPrefixe + KEY_ELEMENT_NAME, Varname.QS.name()).toUpperCase());
            this.fConverter = WobjDataConverter.valueOf(pProperties.getProperty(pPrefixe + KEY_CONVERTER_NAME, WobjDataConverter.IDENTITY.name()));
            this.fParameters = new ArrayList<AbstractObjectiveFunction.FctParam>();
            String strmap = pProperties.getProperty(pPrefixe + KEY_PARAMETERS_NAME, "");
            if (strmap.length() > 0) {
                String[] tab;
                for (String token : tab = strmap.split(";")) {
                    String[] entry = token.split("=");
                    this.fParameters.add(new AbstractObjectiveFunction.FctParam(entry[0], Double.parseDouble(entry[1].replaceAll(",", "."))));
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Wrong WOBJ expression : not loaded.");
        }
    }

    public List<AbstractObjectiveFunction.FctParam> getParameters() {
        return this.fParameters;
    }

    public double getWeight() {
        return this.fWeight;
    }

    public DoubleRange getRange() {
        return this.fRange;
    }

    public WobjDataConverter getConverter() {
        return this.fConverter;
    }

    public Class<? extends AbstractObjectiveFunction> getFunctionClass() {
        return this.fFunctionClass;
    }

    public void save(Properties pProperties, String pPrefixe) {
        pProperties.setProperty(pPrefixe + KEY_WEIGHT, String.valueOf(this.fWeight));
        if (this.fFunctionClass != null) {
            pProperties.setProperty(pPrefixe + KEY_CLASS, this.fFunctionClass.getCanonicalName());
        }
        if (this.fRange != null) {
            if (this.fRange.min() != null) {
                pProperties.setProperty(pPrefixe + KEY_LOW, String.valueOf(this.fRange.min()));
            }
            if (this.fRange.max() != null) {
                pProperties.setProperty(pPrefixe + KEY_HIGH, String.valueOf(this.fRange.max()));
            }
        }
        if (this.fVarname != null) {
            pProperties.setProperty(pPrefixe + KEY_ELEMENT_NAME, String.valueOf((Object)this.fVarname));
        }
        if (this.fConverter != null) {
            pProperties.setProperty(pPrefixe + KEY_CONVERTER_NAME, this.fConverter.name());
        }
        if (this.fParameters != null) {
            StringBuilder sb = new StringBuilder();
            for (AbstractObjectiveFunction.FctParam param : this.fParameters) {
                sb.append(param.getKey()).append("=").append(param.getValue()).append(";");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            pProperties.setProperty(pPrefixe + KEY_PARAMETERS_NAME, sb.toString());
        }
    }

    public Varname getVarname() {
        return this.fVarname;
    }

    protected ObjectiveFunctionDescriptor clone() {
        return new ObjectiveFunctionDescriptor(this.fWeight, this.fFunctionClass, this.fVarname, this.fConverter, this.fRange, this.fParameters);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fVarname == null ? 0 : this.fVarname.hashCode());
        result = 31 * result + (this.fFunctionClass == null ? 0 : this.fFunctionClass.hashCode());
        result = 31 * result + (this.fRange.min() == null ? 0 : this.fRange.min().hashCode());
        result = 31 * result + (this.fRange.max() == null ? 0 : this.fRange.max().hashCode());
        result = 31 * result + (this.fConverter == null ? 0 : this.fConverter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectiveFunctionDescriptor other = (ObjectiveFunctionDescriptor)obj;
        return Objects.equals((Object)this.fVarname, (Object)other.fVarname) && Objects.equals(this.fFunctionClass, other.fFunctionClass) && Objects.equals(this.fRange, other.fRange) && Objects.equals((Object)this.fConverter, (Object)other.fConverter);
    }

    public String toString() {
        if (this.fFunctionClass == null) {
            return "";
        }
        if (this.fWeight == 0.0) {
            return "";
        }
        Object sw = this.fWeight == 1.0 ? "" : (Math.floor(this.fWeight) == this.fWeight ? (int)Math.floor(this.fWeight) + "*" : new DecimalFormat("0.###").format(this.fWeight) + "*");
        return (String)sw + this.getFunctionName() + this.paramsString() + "(" + this.fConverter.getVarnameConverter().apply(this.fVarname) + (this.fRange == null ? "" : this.fRange) + ")";
    }

    private String paramsString() {
        if (this.fParameters.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        for (AbstractObjectiveFunction.FctParam param : this.fParameters) {
            sb.append(param.getValue()).append(",");
        }
        if (sb.length() > 0) {
            sb.setCharAt(sb.length() - 1, ']');
        }
        return sb.toString();
    }

    public String getFunctionName() {
        return ObjectiveFunctionFactory.createFunction(this.fFunctionClass).getFunctionName();
    }

    public String toStringWithoutWeight() {
        if (this.fFunctionClass == null) {
            return "";
        }
        if (this.fWeight == 0.0) {
            return "";
        }
        return ObjectiveFunctionFactory.createFunction(this.fFunctionClass).getFunctionName() + "(" + this.fConverter.getVarnameConverter().apply(this.fVarname) + (this.fRange == null ? "" : this.fRange) + ")";
    }
}

