/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.flow;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.ICible;
import fr.geonosis.karstmod.modele.IParametrable;
import fr.geonosis.karstmod.modele.ISource;
import fr.geonosis.karstmod.modele.ParamChoiceType;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.flow.Flow;

public class InfiniteTcDischargeFlow
extends Flow
implements IParametrable {
    public static final String TO = "to ";
    private final ICible[] fCiblesPossibles;
    private final ParamChoiceType fParamChoiceType;

    public InfiniteTcDischargeFlow(ISource pSource, String pNom, String pLibelleHtml, String pPropertyName, ICible[] pCiblesPossibles, ParamChoiceType pParamChoiceType) {
        super(pSource, pNom, pLibelleHtml, pPropertyName, false);
        this.fCiblesPossibles = pCiblesPossibles;
        this.fParamChoiceType = pParamChoiceType;
        this.initParameters();
    }

    private void initParameters() {
        for (final ICible cible : this.fCiblesPossibles) {
            Parameter p = new Parameter(TO + cible.getName(), TO + cible.getName(), TO + cible.getHtmlLabel(), false){

                @Override
                public String getHtmlFormulaLabel() {
                    return (InfiniteTcDischargeFlow.this.getHtmlLabel() + "<sub>" + cible.getHtmlLabel() + "</sub>").replaceAll("</sub><sub>", "");
                }
            };
            this.addParameter(p);
            p.getParentsHandler().addParent(cible);
            cible.addInput(p);
        }
    }

    public Parameter getParameterTo(ICible pCible) {
        return this.getParameter(TO + pCible.getName());
    }

    public String toString() {
        return Messages.getString("FluxVidange.0") + " " + this.getName();
    }

    @Override
    public String toStringHtml() {
        return Messages.getString("FluxVidange.0") + " " + this.getHtmlLabel();
    }

    @Override
    public String detail() {
        return super.detail() + "  - " + Messages.getString("FluxVidange.6") + " ";
    }

    @Override
    public void disable(int pT) {
    }

    @Override
    public ParamChoiceType getParamChoiceType() {
        return this.fParamChoiceType;
    }
}

