/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.flow;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.AbstractElement;
import fr.geonosis.karstmod.modele.ICible;
import fr.geonosis.karstmod.modele.ISource;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.flow.ClassicalDischargeFlow;
import fr.geonosis.karstmod.modele.flow.Flow;
import fr.geonosis.karstmod.modele.flow.law.LoiDerivation;
import fr.geonosis.karstmod.modele.observable.IChild;
import java.util.ArrayList;
import java.util.List;

public class FlowNode
extends AbstractElement
implements ISource,
ICible {
    private final List<Flow> fSorties = new ArrayList<Flow>();
    private IChild fSource = null;

    public FlowNode(String pNom, String pLibelleHtml) {
        this(pNom, pLibelleHtml, pNom);
    }

    public FlowNode(String pNom, String pLibelleHtml, String pPropertyName) {
        super(pNom, pLibelleHtml, pPropertyName);
        this.tooltipTextproperty().set((Object)"Flow node");
    }

    @Override
    public MessageList validate() {
        MessageList messages = super.validate();
        if (this.fSource == null) {
            messages.addError(Messages.getString("FlowNode.0"), this.getName());
        }
        if (this.fSorties.isEmpty()) {
            messages.addError(Messages.getString("FlowNode.1"), this.getName());
        }
        for (Flow f : this.fSorties) {
            if (!(f instanceof ClassicalDischargeFlow)) {
                messages.addError(Messages.getString("FlowNode.2"), this.getName());
                continue;
            }
            if (((ClassicalDischargeFlow)f).getDischargeLaw() instanceof LoiDerivation) continue;
            messages.addError(Messages.getString("FlowNode.3"), this.getName());
        }
        return messages;
    }

    @Override
    public void raz() {
    }

    @Override
    public void addInput(IChild pFlux) {
        if (this.fSource != null) {
            throw new IllegalArgumentException("Only one input source for a Flow Node");
        }
        this.fSource = pFlux;
    }

    @Override
    public void addOutputFlow(Flow pFlux) {
        this.fSorties.add(pFlux);
    }

    public IChild getSource() {
        return this.fSource;
    }
}

