/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.modele.StageBounds;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.collections.ObservableList;

public class StageUtils {
    public static void computeStages(List<StageBounds> pCalibration, List<StageBounds> pValidation) {
        StageBounds periodeSuivante;
        StageBounds periode;
        int i;
        if (pValidation == null || pCalibration == null) {
            return;
        }
        for (i = pCalibration.size() - 2; i >= 0; --i) {
            periode = pCalibration.get(i);
            periodeSuivante = pCalibration.get(i + 1);
            if (periodeSuivante.getDebut() > periode.getFin()) continue;
            pCalibration.remove(i + 1);
            pCalibration.set(i, new StageBounds(periode.getDebut(), Math.max(periode.getFin(), periodeSuivante.getFin())));
        }
        for (i = pValidation.size() - 2; i >= 0; --i) {
            periode = pValidation.get(i);
            periodeSuivante = pValidation.get(i + 1);
            if (periodeSuivante.getDebut() > periode.getFin()) continue;
            pValidation.remove(i + 1);
            pValidation.set(i, new StageBounds(periode.getDebut(), Math.max(periode.getFin(), periodeSuivante.getFin())));
        }
        block2: for (int i2 = 0; i2 < pValidation.size(); ++i2) {
            int vMin = pValidation.get(i2).getDebut();
            int vMax = pValidation.get(i2).getFin();
            for (StageBounds pStageBounds : pCalibration) {
                int cMin = pStageBounds.getDebut();
                int cMax = pStageBounds.getFin();
                if (vMin < cMin && cMin < vMax && vMin < cMax && cMax < vMax) {
                    periode = new StageBounds(vMin, cMin - 1);
                    pValidation.set(i2, periode);
                    periode = new StageBounds(cMax + 1, vMax);
                    pValidation.add(i2 + 1, periode);
                    vMax = pValidation.get(i2).getFin();
                    continue;
                }
                if (cMin <= vMin && cMax >= vMax) {
                    pValidation.remove(i2);
                    --i2;
                    continue block2;
                }
                if (cMin < vMin && vMin <= cMax && cMax < vMax) {
                    vMin = cMax + 1;
                    periode = new StageBounds(cMax + 1, vMax);
                    pValidation.set(i2, periode);
                    continue;
                }
                if (vMin >= cMin || cMin > vMax || vMax > cMax) continue;
                vMax = cMin - 1;
                periode = new StageBounds(vMin, cMin - 1);
                pValidation.set(i2, periode);
            }
        }
    }

    public static List<StageBounds> parse(String pString, int pMax) throws ParseException {
        return StageUtils.parse(pString, pMax, true);
    }

    public static List<StageBounds> parse(String pString, int pMax, boolean pSort) throws ParseException {
        ArrayList<StageBounds> list = new ArrayList<StageBounds>();
        for (String s : pString.split(";")) {
            list.add(new StageBounds(s, pMax));
        }
        if (pSort) {
            Collections.sort(list);
        }
        return list;
    }

    public static String format(List<StageBounds> pStageBounds) {
        StringBuilder sb = new StringBuilder();
        for (StageBounds bounds : pStageBounds) {
            sb.append(bounds.getDebut());
            sb.append("-");
            sb.append(bounds.getFin());
            sb.append(";");
        }
        return sb.toString();
    }

    public static Integer beginningOf(List<StageBounds> pStages) {
        if (pStages == null || pStages.isEmpty()) {
            return null;
        }
        int beginning = pStages.get(0).getDebut();
        for (int i = 1; i < pStages.size(); ++i) {
            int debut = pStages.get(i).getDebut();
            if (debut >= beginning) continue;
            beginning = debut;
        }
        return beginning;
    }

    public static Integer endOf(ObservableList<StageBounds> pStages) {
        if (pStages == null || pStages.isEmpty()) {
            return null;
        }
        int end = ((StageBounds)pStages.get(0)).getFin();
        for (int i = 1; i < pStages.size(); ++i) {
            int fin = ((StageBounds)pStages.get(i)).getDebut();
            if (fin <= fin) continue;
            end = fin;
        }
        return end;
    }

    public static void merge(List<StageBounds> pStageBounds) {
        Collections.sort(pStageBounds);
        for (int i = pStageBounds.size() - 2; i >= 0; --i) {
            StageBounds periode = pStageBounds.get(i);
            StageBounds periodeSuivante = pStageBounds.get(i + 1);
            if (periodeSuivante.getDebut() > periode.getFin()) continue;
            pStageBounds.remove(i + 1);
            pStageBounds.set(i, new StageBounds(periode.getDebut(), Math.max(periode.getFin(), periodeSuivante.getFin())));
        }
    }
}

