/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.ColumnName;
import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.MessageType;
import fr.geonosis.karstmod.modele.Model;
import fr.geonosis.karstmod.modele.StageBounds;
import fr.geonosis.karstmod.modele.StageUtils;
import fr.geonosis.karstmod.modele.obj.GlobalObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.ObjectiveFunctionDescriptor;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;

public class RunParameters {
    private static final String PREFIXE = "run-parameters.";
    public static final String WARMUP_BEGINNING = "run-parameters.warmup-beginning";
    public static final String CALIBRATION = "run-parameters.calibration-stages";
    public static final String VALIDATION = "run-parameters.validations-stages";
    public static final String SIMULATION_NUMBER = "run-parameters.simulations-number";
    public static final String MAX_TIME = "run-parameters.max-time";
    public static final String WOBJ_MIN = "run-parameters.wobj-min";
    public static final String WOBJ_FUNCTION = "run-parameters.wobj-function.";
    public static final String OUTPUT_DIRECTORY = "run-parameters.output-directory";
    private final ObjectProperty<Integer> fWarmupBeginningProperty;
    private final StringProperty fCalibrationStagesProperty;
    private final StringProperty fValidationStagesProperty;
    private final SimpleObjectProperty<Integer> fSimulationNumberProperty;
    private final SimpleObjectProperty<Integer> fMaxTimeProperty;
    private final ObjectProperty<Double> fWobjMinProperty;
    private final GlobalObjectiveFunction fWobjFunction;
    private final StringProperty fOutputDirectoryProperty;
    private final SimpleObjectProperty<Integer> fCalibParamsNumberProperty;
    private final ReadOnlyListWrapper<StageBounds> fCalibrationStages;
    private final ReadOnlyListWrapper<StageBounds> fValidationStages;
    private final InputData fInputData;
    private final Model fModel;

    public RunParameters(Model pModel, InputData pInputData) {
        this.fInputData = pInputData;
        this.fModel = pModel;
        this.fInputData.addListener(pObservable -> this.initStages());
        this.fWarmupBeginningProperty = new SimpleObjectProperty((Object)0);
        this.fCalibrationStagesProperty = new SimpleStringProperty();
        this.fValidationStagesProperty = new SimpleStringProperty();
        this.fSimulationNumberProperty = new SimpleObjectProperty((Object)1000);
        this.fMaxTimeProperty = new SimpleObjectProperty((Object)30);
        this.fWobjMinProperty = new SimpleObjectProperty((Object)0.4);
        this.fWobjFunction = new GlobalObjectiveFunction();
        this.fOutputDirectoryProperty = new SimpleStringProperty(".");
        this.fCalibParamsNumberProperty = new SimpleObjectProperty();
        this.fCalibrationStages = new ReadOnlyListWrapper(FXCollections.observableArrayList());
        this.fValidationStages = new ReadOnlyListWrapper(FXCollections.observableArrayList());
        this.fCalibrationStagesProperty.addListener((pObservable, pOldValue, pNewValue) -> {
            this.fCalibrationStages.clear();
            try {
                this.fCalibrationStages.addAll(StageUtils.parse((String)this.fCalibrationStagesProperty.get(), this.fInputData.size() - 1));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        });
        this.fValidationStagesProperty.addListener((pObservable, pOldValue, pNewValue) -> {
            this.fValidationStages.clear();
            try {
                this.fValidationStages.addAll(StageUtils.parse((String)this.fValidationStagesProperty.get(), this.fInputData.size() - 1));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        });
    }

    private void initStages() {
        if (!this.fInputData.isEmpty()) {
            String old;
            int n = this.fInputData.size();
            if (this.getWarmupBeginning() == null || this.getWarmupBeginning() >= this.fInputData.size()) {
                this.setWarmupBeginning(0);
            }
            if (this.fCalibrationStagesProperty.get() == null || ((String)this.fCalibrationStagesProperty.get()).trim().length() == 0) {
                this.fCalibrationStagesProperty.set((Object)"");
                this.fCalibrationStagesProperty.set((Object)(n / 4 + "-" + n / 2 + ";"));
            } else {
                old = (String)this.fCalibrationStagesProperty.get();
                this.fCalibrationStagesProperty.set((Object)"");
                this.fCalibrationStagesProperty.set((Object)old);
            }
            if (this.fValidationStagesProperty.get() == null || ((String)this.fValidationStagesProperty.get()).trim().length() == 0) {
                this.fValidationStagesProperty.set((Object)"");
                this.fValidationStagesProperty.set((Object)(n / 2 + 1 + "-" + (n - 1) + ";"));
            } else {
                old = (String)this.fValidationStagesProperty.get();
                this.fValidationStagesProperty.set((Object)"");
                this.fValidationStagesProperty.set((Object)old);
            }
            this.fitStages();
        }
    }

    public void fitStages() {
        Collections.sort(this.fCalibrationStages);
        Collections.sort(this.fValidationStages);
        StageUtils.computeStages(this.fCalibrationStages, this.fValidationStages);
        this.fCalibrationStagesProperty.set((Object)StageUtils.format(this.fCalibrationStages));
        this.fValidationStagesProperty.set((Object)StageUtils.format(this.fValidationStages));
    }

    public ObjectProperty<Integer> warmupBeginningProperty() {
        return this.fWarmupBeginningProperty;
    }

    public ReadOnlyListProperty<StageBounds> getCalibrationStages() {
        return this.fCalibrationStages.getReadOnlyProperty();
    }

    public ReadOnlyListProperty<StageBounds> getValidationStages() {
        return this.fValidationStages.getReadOnlyProperty();
    }

    public ObjectProperty<Integer> nObjProperty() {
        return this.fSimulationNumberProperty;
    }

    public ObjectProperty<Integer> maxTimeProperty() {
        return this.fMaxTimeProperty;
    }

    public ObjectProperty<Double> wobjMinProperty() {
        return this.fWobjMinProperty;
    }

    public StringProperty outputDirectoryProperty() {
        return this.fOutputDirectoryProperty;
    }

    public ObjectProperty<Integer> calibParamsNumberProperty() {
        return this.fCalibParamsNumberProperty;
    }

    public Integer getNObj() {
        return (Integer)this.fSimulationNumberProperty.getValue();
    }

    public void setSimulationNumber(Integer pSimulationNumber) {
        this.fSimulationNumberProperty.setValue((Object)pSimulationNumber);
    }

    public Integer getMaxTime() {
        return (Integer)this.fMaxTimeProperty.getValue();
    }

    public void setMaxTime(Integer pMaxTime) {
        this.fMaxTimeProperty.set((Object)pMaxTime);
    }

    public Double getWobjMin() {
        return (Double)this.fWobjMinProperty.get();
    }

    public void setWobjMin(Double pWobjMin) {
        this.fWobjMinProperty.set((Object)pWobjMin);
    }

    public GlobalObjectiveFunction getWobjFunction() {
        return this.fWobjFunction;
    }

    public String getOutputDirectory() {
        return (String)this.fOutputDirectoryProperty.get();
    }

    public void setOutputDirectory(String pOutputDirectory) {
        this.fOutputDirectoryProperty.set((Object)pOutputDirectory);
    }

    public Integer getCalibParamsNumber() {
        return (Integer)this.fCalibParamsNumberProperty.get();
    }

    public void setCalibParamsNumber(Integer pCalibParamsNumber) {
        this.fCalibParamsNumberProperty.set((Object)pCalibParamsNumber);
    }

    public Integer getWarmupBeginning() {
        return (Integer)this.fWarmupBeginningProperty.get();
    }

    public void setWarmupBeginning(Integer pWarmupBeginning) {
        this.fWarmupBeginningProperty.set((Object)pWarmupBeginning);
    }

    public MessageList validate() {
        MessageList msgList = new MessageList();
        if (this.getWarmupBeginning() == null) {
            msgList.addError("The beginning of the warmup stage must be set", WARMUP_BEGINNING);
        } else if (this.getWarmupBeginning() < 0) {
            msgList.addError("The beginning of the warmup stage must be positive", WARMUP_BEGINNING);
        } else if (this.fInputData.isLoaded() && this.getWarmupBeginning() >= this.fInputData.size()) {
            msgList.addError("The beginning of the warmup stage must be lesser than the data size", WARMUP_BEGINNING);
        } else if (this.getWarmupBeginning() < this.fInputData.getIOShift()) {
            msgList.addError(String.format("The beginning of the warm-up stage (%d) can not be smaller than the I/O shift (%d)", this.getWarmupBeginning(), this.fInputData.getIOShift()), WARMUP_BEGINNING);
        }
        if (this.getCalibrationStages() == null || this.getCalibrationStages().isEmpty()) {
            msgList.addError("The calibration stage must be set", CALIBRATION);
        }
        if (this.getValidationStages() != null && !this.getValidationStages().isEmpty()) {
            boolean containsData = false;
            block2: for (StageBounds stage : this.getValidationStages()) {
                if (stage.getFin() >= this.fInputData.size()) {
                    msgList.addError("The validation stage end is greater than the data size", VALIDATION);
                    continue;
                }
                for (int i = stage.getDebut(); i <= stage.getFin(); ++i) {
                    if (!Double.isFinite(this.fInputData.get(ColumnName.QOBSS, i))) continue;
                    containsData = true;
                    continue block2;
                }
            }
            if (!containsData) {
                msgList.addError("The validation stage contains no data", VALIDATION);
            }
        }
        if (this.getWarmupBeginning() != null) {
            if (this.getCalibrationStages() != null && !this.getCalibrationStages().isEmpty()) {
                Integer end;
                if (this.getWarmupBeginning().doubleValue() > (double)StageUtils.beginningOf(this.getCalibrationStages()).intValue()) {
                    msgList.addError("The beginning of the warmup stage must be lesser than the beginning of the calibration stage", WARMUP_BEGINNING);
                    msgList.addError("The beginning of the calibration stage must be greater than the beginning of the warmup stage", CALIBRATION);
                }
                if ((end = StageUtils.endOf(this.getCalibrationStages())) != null && end >= this.fInputData.size()) {
                    msgList.addError("The end of the calibration stage must be lesser than the data size", CALIBRATION);
                }
            }
            if (this.getValidationStages() != null && !this.getValidationStages().isEmpty()) {
                Integer end;
                if (this.getWarmupBeginning().doubleValue() > (double)StageUtils.beginningOf(this.getValidationStages()).intValue()) {
                    msgList.addError("The beginning of the warmup stage must be lesser than the beginning of the validation stage", WARMUP_BEGINNING);
                    msgList.addError("The beginning of the validation stage must be greater than the beginning of the warmup stage", VALIDATION);
                }
                if ((end = StageUtils.endOf(this.getValidationStages())) != null && end >= this.fInputData.size()) {
                    msgList.addError("The end of the validation stage must be lesser than the data size", VALIDATION);
                }
            }
        }
        if (this.getNObj() == null) {
            msgList.addError("The simulation number must be set", SIMULATION_NUMBER);
        } else if (this.getNObj() <= 0) {
            msgList.addError("The simulation number must be positive", SIMULATION_NUMBER);
        }
        if (this.getMaxTime() == null) {
            msgList.addError("The maximum time must be set", MAX_TIME);
        } else if (this.getMaxTime() <= 0) {
            msgList.addError("The maximum time  must be positive", MAX_TIME);
        }
        if (this.getWobjMin() == null || Double.isNaN(this.getWobjMin())) {
            msgList.addError("The minimal WOBJ value must be set", WOBJ_MIN);
        } else if (this.getWobjMin() > 1.0) {
            msgList.addError("The minimal WOBJ value must be lower than or equal to 1", WOBJ_MIN);
        }
        if (this.getWobjFunction() == null || this.getWobjFunction().getActivePartNumber() == 0) {
            msgList.addError("The WOBJ function value must be set", WOBJ_FUNCTION);
        }
        for (ObjectiveFunctionDescriptor descriptor : this.getWobjFunction().getDescriptors()) {
            if (descriptor.getWeight() == 0.0) continue;
            if (!this.getModel().useVar(descriptor.getVarname())) {
                msgList.addError("The WOBJ function uses an inactive element: " + descriptor.getVarname().getLabel(), WOBJ_FUNCTION);
                continue;
            }
            if (this.getInputData().contains(descriptor.getVarname().getColumnName())) continue;
            msgList.addError("The WOBJ function uses a missing element in the input data: " + descriptor.getVarname().getLabel(), WOBJ_FUNCTION);
        }
        if (this.getOutputDirectory() != null) {
            File d = new File(this.getOutputDirectory());
            if (!d.exists()) {
                if (!d.mkdirs()) {
                    msgList.addError("Unable to create the output directory", OUTPUT_DIRECTORY);
                }
            } else if (d.isFile()) {
                msgList.addError("The output directory must not be set to an existing file", OUTPUT_DIRECTORY);
            }
            if (d.exists() && d.isDirectory()) {
                byte[] b = new byte[19];
                Arrays.fill(b, (byte)65);
                File f = new File(this.getOutputDirectory(), new String(b) + ".csv");
                try {
                    if (!f.createNewFile()) {
                        msgList.addError("Unable to create the output files in the output directory", OUTPUT_DIRECTORY);
                    } else {
                        f.delete();
                    }
                }
                catch (IOException e) {
                    msgList.addError("Unable to create the output files in the output directory", OUTPUT_DIRECTORY);
                }
            }
        }
        return msgList;
    }

    public void save(Properties pProperties) {
        pProperties.put(WARMUP_BEGINNING, this.getWarmupBeginning() == null ? "" : String.valueOf(this.getWarmupBeginning()));
        String calibrationStages = (String)this.fCalibrationStagesProperty.get();
        pProperties.put(CALIBRATION, calibrationStages == null ? "" : calibrationStages);
        String validationStages = (String)this.fValidationStagesProperty.get();
        pProperties.put(VALIDATION, validationStages == null ? "" : validationStages);
        pProperties.put(SIMULATION_NUMBER, this.getNObj() == null ? "" : String.valueOf(this.getNObj()));
        pProperties.put(MAX_TIME, this.getMaxTime() == null ? "" : String.valueOf(this.getMaxTime()));
        pProperties.put(WOBJ_MIN, this.getWobjMin() == null ? "" : String.valueOf(this.getWobjMin()));
        pProperties.put(OUTPUT_DIRECTORY, this.getOutputDirectory());
        this.getWobjFunction().save(pProperties, WOBJ_FUNCTION);
    }

    public void load(Properties pProperties) throws Exception {
        for (String key : new String[]{WARMUP_BEGINNING, CALIBRATION, VALIDATION, SIMULATION_NUMBER, WOBJ_MIN, OUTPUT_DIRECTORY}) {
            if (pProperties.containsKey(key)) continue;
            throw new Exception(Messages.getString("JRunParams.17") + " : " + key);
        }
        this.setWarmupBeginning(Integer.valueOf(pProperties.getProperty(WARMUP_BEGINNING)));
        this.fCalibrationStagesProperty.set((Object)pProperties.getProperty(CALIBRATION));
        this.fValidationStagesProperty.set((Object)pProperties.getProperty(VALIDATION));
        this.setWobjMin(Double.valueOf(pProperties.getProperty(WOBJ_MIN)));
        this.setMaxTime(Integer.valueOf(pProperties.getProperty(MAX_TIME)));
        this.setSimulationNumber(Integer.valueOf(pProperties.getProperty(SIMULATION_NUMBER)));
        this.setOutputDirectory(pProperties.getProperty(OUTPUT_DIRECTORY));
        this.fWobjFunction.load(pProperties, WOBJ_FUNCTION);
    }

    public InputData getInputData() {
        return this.fInputData;
    }

    public StringProperty calibrationStagesProperty() {
        return this.fCalibrationStagesProperty;
    }

    public StringProperty validationStagesProperty() {
        return this.fValidationStagesProperty;
    }

    public Model getModel() {
        return this.fModel;
    }

    public boolean isValid() {
        return !this.validate().has(MessageType.ERROR);
    }
}

