/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.Dimension;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

public enum BaseUnit {
    DAY(Messages.getString("BaseUnite.0"), Messages.getString("BaseUnite.1"), 86400, "yyyy/MM/dd"),
    HOUR(Messages.getString("BaseUnite.2"), Messages.getString("BaseUnite.1"), 3600, "yyyy/MM/dd HH:mm");

    private final Map<Dimension, String> fTypes = new HashMap<Dimension, String>();
    private final int fSecondes;
    private final DateTimeFormatter fDateTimeFormatter;

    private BaseUnit(String pTime, String pHeight, int pSeconds, String pPattern) {
        this.fTypes.put(Dimension.TIME, pTime);
        this.fTypes.put(Dimension.HEIGHT, pHeight);
        this.fTypes.put(Dimension.K, pHeight + "/" + pTime);
        this.fTypes.put(Dimension.ET, pHeight + "/" + pTime);
        this.fTypes.put(Dimension.RAINFALL, pHeight + "/" + pTime);
        this.fTypes.put(Dimension.AREA, Messages.getString("BaseUnite.8"));
        this.fTypes.put(Dimension.DISCHARGE, Messages.getString("BaseUnite.9"));
        this.fTypes.put(Dimension.INTERNAL_DISCHARGE, pHeight + "/" + pTime);
        this.fTypes.put(Dimension.NONE, "");
        this.fTypes.put(Dimension.P, "");
        this.fTypes.put(Dimension.PIEZO, Messages.getString("BaseUnite.10"));
        this.fTypes.put(Dimension.TEMPERATURE, Messages.getString("BaseUnite.11"));
        this.fTypes.put(Dimension.ANGLE, Messages.getString("BaseUnite.12"));
        this.fTypes.put(Dimension.MF, pHeight + "/" + Messages.getString("BaseUnite.11") + "." + pTime);
        this.fSecondes = pSeconds;
        this.fDateTimeFormatter = DateTimeFormatter.ofPattern(pPattern).withZone(ZoneId.of("UTC"));
    }

    public String get(Dimension pType) {
        return this.fTypes.get((Object)pType);
    }

    public int getSecondes() {
        return this.fSecondes;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.fDateTimeFormatter;
    }
}

