/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.IElement;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.ParamChoiceType;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterList;
import fr.geonosis.karstmod.modele.observable.ChildrenHandler;
import fr.geonosis.karstmod.modele.observable.ParentsHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public abstract class AbstractElement
implements IElement {
    private final BooleanProperty fSelectedProperty = new SimpleBooleanProperty();
    private final BooleanProperty fActiveProperty = new SimpleBooleanProperty();
    private final BooleanProperty fShowLabelProperty;
    private final String fName;
    private final StringProperty fHtmlLabelProperty;
    private final StringProperty fHtmlLabelCpltProperty;
    private final StringProperty fTooltipTextProperty;
    private final ParameterList fParameters;
    private final String fPropertyName;
    private final ParentsHandler fParentsHandler;
    private final ChildrenHandler fChildrenHandler;
    private final List<InvalidationListener> fListeners;
    private final BooleanProperty fActivableProperty = new SimpleBooleanProperty();
    private boolean fAlwaysVisible = false;

    public AbstractElement(String pName, String pHtmlLabel, String pPropertyName) {
        this(pName, pHtmlLabel, pPropertyName, true);
    }

    public AbstractElement(String pName, String pHtmlLabel, String pPropertyName, boolean pActivable) {
        this.fShowLabelProperty = new SimpleBooleanProperty();
        this.fHtmlLabelCpltProperty = new SimpleStringProperty();
        this.fTooltipTextProperty = new SimpleStringProperty();
        this.fParameters = new ParameterList();
        this.fPropertyName = pPropertyName;
        this.fParentsHandler = new ParentsHandler(this);
        this.fChildrenHandler = new ChildrenHandler(this);
        this.fListeners = new ArrayList<InvalidationListener>();
        this.fName = pName == null ? "" : pName;
        this.fHtmlLabelProperty = new SimpleStringProperty(pHtmlLabel);
        this.fSelectedProperty.addListener((pObservable, pOldValue, pNewValue) -> {
            this.fActiveProperty.set(this.isActive());
            this.fireChanged();
        });
        this.setSelected(true);
        this.setActivable(pActivable);
        this.setShowLabel(true);
    }

    @Override
    public ChildrenHandler getChildrenHandler() {
        return this.fChildrenHandler;
    }

    @Override
    public ParentsHandler getParentsHandler() {
        return this.fParentsHandler;
    }

    @Override
    public Parameter getParameter(String pName) {
        return this.fParameters.getByName(pName);
    }

    @Override
    public boolean isSelected() {
        return this.fSelectedProperty.get();
    }

    @Override
    public void setSelected(boolean pSelected) {
        this.fSelectedProperty.set(pSelected);
    }

    @Override
    public boolean isActive() {
        return this.isSelected() && this.fParentsHandler.isActive();
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.fParameters.list();
    }

    @Override
    public void raz() {
        this.fParameters.raz();
    }

    @Override
    public void save(Properties pProperties, String pPrefixe, boolean pActiveOnly) {
        String prefixe = this.getPropertiesPrefixe(pPrefixe);
        if (!pActiveOnly || this.isActive()) {
            pProperties.put(prefixe + "selected", String.valueOf(this.isSelected()));
            this.fParameters.save(pProperties, prefixe, pActiveOnly);
        }
    }

    @Override
    public void load(Properties pProperties, String pPrefixe) throws Exception {
        String prefixe = this.getPropertiesPrefixe(pPrefixe);
        String key = prefixe + "selected";
        if (!pProperties.containsKey(key)) {
            throw new Exception(Messages.getString("AbstractElement.2") + " : " + key);
        }
        this.setSelected(Boolean.parseBoolean(pProperties.getProperty(key)));
        this.fParameters.load(pProperties, prefixe);
    }

    String getPropertiesPrefixe(String pPrefixe) {
        return pPrefixe + this.getPropertyName().replaceAll(" ", "_") + ".";
    }

    @Override
    public String detail() {
        return this.fName + (this.isActive() ? " (" + Messages.getString("AbstractElement.8") + ")" : " (" + Messages.getString("disabled") + ")") + " : \n";
    }

    @Override
    public String getHtmlLabel() {
        return (String)this.fHtmlLabelProperty.get();
    }

    public String getPropertyName() {
        return this.fPropertyName;
    }

    public BooleanProperty selectedProperty() {
        return this.fSelectedProperty;
    }

    @Override
    public StringProperty htmlLabelProperty() {
        return this.fHtmlLabelProperty;
    }

    @Override
    public BooleanProperty activeProperty() {
        return this.fActiveProperty;
    }

    protected final void addParameter(Parameter pParameter) {
        this.fParameters.add(pParameter);
        pParameter.getParentsHandler().addParent(this);
        pParameter.addListener(pObservable -> this.fireChanged());
    }

    protected final void addParameters(List<Parameter> pParameterList) {
        for (Parameter parameter : pParameterList) {
            this.addParameter(parameter);
        }
    }

    public void addListener(InvalidationListener pListener) {
        this.fListeners.add(pListener);
    }

    public void removeListener(InvalidationListener pListener) {
        this.fListeners.remove(pListener);
    }

    protected void fireChanged() {
        for (InvalidationListener listener : this.fListeners) {
            listener.invalidated((Observable)this);
        }
    }

    @Override
    public boolean isActivable() {
        return this.getParentsHandler().isActive() && this.fActivableProperty.get();
    }

    public BooleanProperty activableProperty() {
        return this.fActivableProperty;
    }

    private void setActivable(boolean pActivable) {
        this.fActivableProperty.set(pActivable);
    }

    public BooleanProperty showLabelProperty() {
        return this.fShowLabelProperty;
    }

    public boolean isShowLabel() {
        return this.fShowLabelProperty.get();
    }

    public void setShowLabel(boolean pState) {
        this.fShowLabelProperty.set(pState);
    }

    public StringProperty htmlLabelCpltProperty() {
        return this.fHtmlLabelCpltProperty;
    }

    public String getHtmlLabelCplt() {
        return (String)this.fHtmlLabelCpltProperty.get();
    }

    public void setHtmlLabelCplt(String pCplt) {
        this.fHtmlLabelCpltProperty.set((Object)pCplt);
    }

    @Override
    public MessageList validate() {
        MessageList res = new MessageList();
        for (Parameter parameter : this.fParameters.list()) {
            if (!parameter.isActive()) continue;
            res.addAll(parameter.validate());
        }
        return res;
    }

    @Override
    public ParamChoiceType getParamChoiceType() {
        return ParamChoiceType.CHECK;
    }

    public boolean isAlwaysVisible() {
        return this.fAlwaysVisible;
    }

    public void setAlwaysVisible(boolean pAlwaysVisible) {
        this.fAlwaysVisible = pAlwaysVisible;
    }

    @Override
    public StringProperty tooltipTextproperty() {
        return this.fTooltipTextProperty;
    }

    @Override
    public final String getToolTipText() {
        return (String)this.tooltipTextproperty().get();
    }

    public boolean needsCalibration() {
        for (Parameter p : this.fParameters.getActives()) {
            if (!p.needsCalibration()) continue;
            return true;
        }
        return false;
    }
}

