/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs.ssi;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.ihm.graphs.ssi.SobolIndex;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.SensitivityIndexes;
import java.util.Map;
import javax.swing.table.DefaultTableModel;

public class JTableauSSIModel
extends DefaultTableModel {
    private final String[] fTitles = new String[]{Messages.getString("JTableauSSI.parameter"), Messages.getString("JTableauSSI.S"), Messages.getString("JTableauSSI.St")};
    private SobolIndex[] fIndexes = new SobolIndex[0];
    private Parameter[] fParameters;

    protected void setIndexes(Map<Parameter, SensitivityIndexes> pValues) {
        if (pValues != null) {
            double fo = 0.0;
            double te = 0.0;
            this.fIndexes = new SobolIndex[pValues.size()];
            this.fParameters = new Parameter[pValues.size()];
            int i = 0;
            for (Map.Entry<Parameter, SensitivityIndexes> entry : pValues.entrySet()) {
                SobolIndex si = new SobolIndex("<html>" + entry.getKey().getHtmlLabel() + "</html>", entry.getValue().getS(), entry.getValue().getSt());
                if (si.getFirstOrderIndex() > 0.0) {
                    fo += si.getFirstOrderIndex();
                }
                if (si.getTotalEffectIndex() > 0.0) {
                    te += si.getTotalEffectIndex();
                }
                this.fIndexes[i] = si;
                this.fParameters[i] = entry.getKey();
                ++i;
            }
            for (SobolIndex s : this.fIndexes) {
                if (s.getFirstOrderIndex() > 0.0) {
                    s.setFirstOrderRank(s.getFirstOrderIndex() / fo);
                }
                if (!(s.getTotalEffectIndex() > 0.0)) continue;
                s.setTotalEffectRank(s.getTotalEffectIndex() / te);
            }
        } else {
            this.fIndexes = new SobolIndex[0];
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int pRow, int pColumn) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.fTitles.length;
    }

    @Override
    public String getColumnName(int pColumn) {
        return this.fTitles[pColumn];
    }

    @Override
    public int getRowCount() {
        return this.fIndexes == null ? 0 : this.fIndexes.length;
    }

    @Override
    public Object getValueAt(int pRow, int pColumn) {
        switch (pColumn) {
            case 0: {
                return this.fIndexes[pRow].getParameterName();
            }
            case 1: {
                return this.fIndexes[pRow].getFirstOrderIndex();
            }
            case 2: {
                return this.fIndexes[pRow].getTotalEffectIndex();
            }
        }
        return super.getValueAt(pRow, pColumn);
    }

    @Override
    public void setValueAt(Object pAValue, int pRow, int pColumn) {
    }

    @Override
    public Class<?> getColumnClass(int pColumnIndex) {
        switch (pColumnIndex) {
            case 1: 
            case 2: {
                return Double.TYPE;
            }
        }
        return String.class;
    }

    public SobolIndex getIndex(int pRow) {
        return this.fIndexes[pRow];
    }

    public Parameter getParameter(int pRow) {
        return this.fParameters[pRow];
    }
}

