/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs.de;

import fr.dbe.graphique.JDessinGraphique;
import fr.geonosis.karstmod.ihm.graphs.de.DECanvas;
import fr.geonosis.karstmod.ihm.graphs.de.DELabel;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class VerticalColorBar {
    private static final String[] LABELS = new String[]{"<0", "0.5", "1"};
    private static final int TIC_WIDTH = 0;
    private final int SPACING = 3;
    private final JDessinGraphique fDessin;
    private final DELabel fCaption;

    public VerticalColorBar(JDessinGraphique pDessin, String pCaption) {
        this.fDessin = pDessin;
        this.fCaption = new DELabel(pCaption, -1);
    }

    private int barWidth() {
        return Math.max(8, Math.min(40, this.fDessin.getWidth() / 25));
    }

    public int computeWidth(Graphics2D g) {
        double width = (double)(this.barWidth() + 6 + 0) + this.fCaption.getBounds(g).getHeight();
        FontMetrics fm = g.getFontMetrics();
        double maxW = 0.0;
        for (String label : LABELS) {
            Rectangle2D textbounds = fm.getStringBounds(label, g);
            maxW = Math.max(maxW, textbounds.getWidth());
        }
        return (int)(width + maxW);
    }

    public void draw(Graphics2D g, int x, int y0, int y1) {
        Rectangle2D textbounds;
        g.setColor(Color.BLACK);
        int height = y1 - y0;
        double dc = 255.0 / (double)height;
        int width = this.barWidth();
        for (int yl = 0; yl < height; ++yl) {
            double[] color = DECanvas.LUT[255 - (int)((double)yl * dc)];
            g.setColor(new Color((int)(color[0] * 255.0), (int)(color[1] * 255.0), (int)(color[2] * 255.0), (int)(color[3] * 255.0)));
            g.drawLine(x, y0 + yl, x + width, y0 + yl);
        }
        g.setColor(Color.BLACK);
        g.drawRect(x, y0, width, height);
        FontMetrics fm = g.getFontMetrics();
        double dl = (double)height / (double)(LABELS.length - 1);
        double maxW = 0.0;
        for (String label : LABELS) {
            textbounds = fm.getStringBounds(label, g);
            maxW = Math.max(maxW, textbounds.getWidth());
        }
        int yL = y1;
        int xl = x + width;
        for (String label : LABELS) {
            g.drawLine(xl, yL, xl + 0, yL);
            textbounds = fm.getStringBounds(label, g);
            g.drawString(label, xl + 0 + 3, (int)((double)yL + textbounds.getHeight() / 2.0) - 2);
            yL = (int)((double)yL - dl);
        }
        xl = (int)((double)xl + (0.0 + maxW + 3.0));
        this.fCaption.draw(g, xl, (int)((double)y0 + ((double)height - this.fCaption.getBounds(g).getHeight()) / 2.0));
    }
}

