/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs.de;

import fr.dbe.graphique.JPanneauGraphique;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.Repere;
import fr.dbe.graphique.Serie;
import fr.dbe.util.ihm.SharedFrame;
import fr.geonosis.karstmod.compute.DiagnosticEfficiency;
import fr.geonosis.karstmod.compute.PeriodType;
import fr.geonosis.karstmod.ihm.graphs.de.DECanvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;

public class DEChart
extends JPanneauGraphique {
    private static final String PREFS_KEY_SAVE = "fr.geonosis.karstmod.ihm.graphs.de.save";
    private final DiagnosticEfficiency fCalib;
    private final DiagnosticEfficiency fValid;

    public DEChart(String pNom, DiagnosticEfficiency pCalib, DiagnosticEfficiency pValid) {
        super(pNom);
        this.fCalib = pCalib;
        this.fValid = pValid;
        double eff = Math.max(this.fCalib == null ? 0.0 : this.fCalib.getEff(), this.fValid == null ? 0.0 : this.fValid.getEff());
        if (this.fCalib == null && this.fValid == null || eff >= 3.0) {
            this.setBusy("Value of 'DE' is out of bounds for visualization!");
            return;
        }
        this.setZoomEnabled(false);
        this.setAdjustEnabled(false);
        this.setCurseur(false);
        this.setPropertiesEnabled(false);
        this.setControleVisible(false);
        this.getDessin().getTitre().setVisible(false);
        this.getDessin().getTitre().setAlignment(GroupLayout.Alignment.LEADING);
        Font f = this.getDessin().getTitre().getFont();
        this.getDessin().getTitre().setFont(new Font(f.getFamily(), f.getStyle(), f.getSize() - 4));
        Repere repere = this.getRepere(0);
        repere.setVisible(false);
        repere.getAxeH().getGraduation().setVisible(false);
        repere.getAxeV().getGraduation().setVisible(false);
        repere.getAxeV().setBornes(0.0, 1.0);
        repere.getAxeH().setCouleur(Color.lightGray);
        repere.getAxeH().setCouleurEtiquette(Color.BLACK);
        repere.getAxeH().setBornes(0.0, 1.0);
        HashMap<PeriodType, DiagnosticEfficiency> map = new HashMap<PeriodType, DiagnosticEfficiency>();
        if (this.fCalib != null) {
            map.put(PeriodType.CALIBRATION, this.fCalib);
        }
        if (this.fValid != null) {
            map.put(PeriodType.VALIDATION, this.fValid);
        }
        final DECanvas canvas = new DECanvas(map);
        repere.ajouteFond(canvas);
        this.setLegende(true);
        this.getDessin().getLegende().deplace(600.0, 100.0);
        final int defaultDismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
        final int defaultInitialDelay = ToolTipManager.sharedInstance().getInitialDelay();
        this.getDessin().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager.sharedInstance().setInitialDelay(1);
                ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager.sharedInstance().setInitialDelay(defaultInitialDelay);
                ToolTipManager.sharedInstance().setDismissDelay(defaultDismissDelay);
            }
        });
        this.getDessin().addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PeriodType period = canvas.periodAt(e.getPoint());
                if (period != null) {
                    switch (period) {
                        case CALIBRATION: {
                            if (DEChart.this.fCalib == null) break;
                            DEChart.this.getDessin().setToolTipText(DEChart.this.toolTipText4(period, DEChart.this.fCalib));
                            break;
                        }
                        case VALIDATION: {
                            if (DEChart.this.fValid == null) break;
                            DEChart.this.getDessin().setToolTipText(DEChart.this.toolTipText4(period, DEChart.this.fValid));
                        }
                    }
                } else {
                    DEChart.this.getDessin().setToolTipText(null);
                }
            }
        });
    }

    private String toolTipText4(PeriodType pPeriodType, DiagnosticEfficiency pDiagEff) {
        return String.format("<html><p>%s</p><table><tr><td>Diagnostic-Efficiency</td><td>%.3f</td></tr><tr><td>Trigonometric inverse tangent</td><td>%.3f</td></tr><tr><td>Temporal correlation between<br/>observed and simulated time series</td><td>%.3f</td></tr><tr><td>Error contribution of high flows</td><td>%.3f</td></tr><tr><td>Error contribution of low flows</td><td>%.3f</td></tr><tr><td>Integrated relative bias for high flows</td><td>%.3f</td></tr><tr><td>Integrated relative bias for low flows</td><td>%.3f</td></tr><tr><td>Integrated relative bias for the entire<br/>flow duration curve</td><td>%.3f</td></tr><tr><td>Arithmetic mean of the relative bias</td><td>%.3f</td></tr></table></html>", pPeriodType.toString(), pDiagEff.getEff(), pDiagEff.getPhi(), pDiagEff.getTempCor(), pDiagEff.getErrHf(), pDiagEff.getErrLf(), pDiagEff.getbHf(), pDiagEff.getbLf(), pDiagEff.getbTot(), pDiagEff.getBrelMean());
    }

    @Override
    public void ajouterSerie(int pIndiceRepere, Serie pSerie) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ajouterSeries(int pIndiceRepere, List<? extends Serie> pSeries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() {
        SharedFrame f = new SharedFrame();
        SwingUtilities.invokeLater(() -> {
            try {
                JFileChooser jfc = new JFileChooser();
                jfc.setAcceptAllFileFilterUsed(false);
                jfc.setMultiSelectionEnabled(false);
                jfc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getAbsolutePath().toLowerCase().endsWith(".txt") || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return Messages.getString("JPanneauGraphique.38");
                    }
                });
                jfc.setSelectedFile(new File(Preferences.userRoot().get(PREFS_KEY_SAVE, ".")));
                boolean continuer = true;
                while (continuer) {
                    if (jfc.showSaveDialog(this.getDessin()) == 1) {
                        return;
                    }
                    if (jfc.getSelectedFile().exists()) {
                        switch (JOptionPane.showConfirmDialog(this.getDessin(), Messages.getString("JPanneauGraphique.39"), Messages.getString("JPanneauGraphique.40"), 1)) {
                            case 0: {
                                continuer = false;
                                break;
                            }
                            case 2: {
                                return;
                            }
                        }
                        continue;
                    }
                    continuer = false;
                }
                Preferences.userRoot().put(PREFS_KEY_SAVE, jfc.getSelectedFile().toString());
                try (PrintWriter pw = new PrintWriter(jfc.getSelectedFile().toString());){
                    pw.println(";Calibration;Validation");
                    pw.println("Diagnostic-Efficiency;" + (Serializable)(this.fCalib == null ? "-" : Double.valueOf(this.fCalib.getEff())) + ";" + (Serializable)(this.fValid == null ? "-" : Double.valueOf(this.fValid.getEff())));
                    pw.println("Trigonometric inverse tangent;" + (Serializable)(this.fCalib == null ? "-" : Double.valueOf(this.fCalib.getPhi())) + ";" + (Serializable)(this.fValid == null ? "-" : Double.valueOf(this.fValid.getPhi())));
                    pw.println("Temporal correlation between observed and simulated time series;" + (Serializable)(this.fCalib == null ? "-" : Double.valueOf(this.fCalib.getTempCor())) + ";" + (Serializable)(this.fValid == null ? "-" : Double.valueOf(this.fValid.getTempCor())));
                    pw.println("Error contribution of high flows;" + (Serializable)(this.fCalib == null ? "-" : Double.valueOf(this.fCalib.getErrHf())) + ";" + (Serializable)(this.fValid == null ? "-" : Double.valueOf(this.fValid.getErrHf())));
                    pw.println("Error contribution of low flows;" + (Serializable)(this.fCalib == null ? "-" : Double.valueOf(this.fCalib.getErrLf())) + ";" + (Serializable)(this.fValid == null ? "-" : Double.valueOf(this.fValid.getErrLf())));
                    pw.println("Integrated relative bias for high flows;" + (Serializable)(this.fCalib == null ? "-" : Double.valueOf(this.fCalib.getbHf())) + ";" + (Serializable)(this.fValid == null ? "-" : Double.valueOf(this.fValid.getbHf())));
                    pw.println("Integrated relative bias for low flows;" + (Serializable)(this.fCalib == null ? "-" : Double.valueOf(this.fCalib.getbLf())) + ";" + (Serializable)(this.fValid == null ? "-" : Double.valueOf(this.fValid.getbLf())));
                    pw.println("Integrated relative bias for the entire flow duration curve;" + (String)(this.fCalib == null ? "-" : (Serializable)(this.fValid == null ? "-" : Double.valueOf(this.fCalib.getbTot())) + ";" + this.fValid.getbTot()));
                    pw.println("Arithmetic mean of the relative bias;" + (Serializable)(this.fCalib == null ? "-" : Double.valueOf(this.fCalib.getBrelMean())) + ";" + (Serializable)(this.fValid == null ? "-" : Double.valueOf(this.fValid.getBrelMean())));
                    pw.flush();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getDessin(), Messages.getString("JPanneauGraphique.41"));
            }
        });
    }
}

