/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.JPanneauGraphique;
import fr.dbe.graphique.Log10Function;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.NuageDePoint;
import fr.dbe.graphique.PointCourbe;
import fr.dbe.graphique.Repere;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JParamChart
extends JPanel {
    private final JPanneauGraphique fGraph;
    private final NuageDePoint fCourbe;
    private final NuageDePoint fCourbeMeilleur;
    private final JLabel fTitre;
    private double fXBestY;
    private double fBestY;
    private final JLabel fLabel;
    private final JLabel fLabelUnite;
    private Parameter fParameter;

    public JParamChart() {
        super(new GridBagLayout());
        this.setVisible(false);
        this.fGraph = new JPanneauGraphique(""){

            @Override
            public void ajuster() {
                super.ajuster();
                Repere r = this.getRepere(0);
                double xMin = r.getAxeH().getMin();
                double xMax = r.getAxeH().getMax();
                double yMin = r.getAxeV().getMin();
                double yMax = r.getAxeV().getMax();
                boolean mod = false;
                if (JParamChart.this.fXBestY == xMax) {
                    xMax += 0.05 * (xMax - xMin);
                    mod = true;
                }
                if (JParamChart.this.fXBestY == xMin) {
                    xMin -= 0.05 * (xMax - xMin);
                    mod = true;
                }
                if (JParamChart.this.fBestY == yMax) {
                    yMax += 0.05 * (yMax - yMin);
                    mod = true;
                }
                if (JParamChart.this.fBestY == yMin) {
                    yMin -= 0.05 * (yMax - yMin);
                    mod = true;
                }
                if (mod) {
                    r.setBornes(xMin, xMax, yMin, yMax);
                }
            }
        };
        this.fGraph.getRepere(0).getAxeV().setEtiquette(Messages.getString("WOBJ.name"));
        this.fGraph.setBorder(BorderFactory.createEtchedBorder());
        this.fGraph.setControleVisible(false);
        this.fGraph.setControleEnabled(true);
        this.fGraph.setCurseur(false);
        this.fGraph.getDessin().setTauxAjustementV(80);
        this.fGraph.getDessin().setMarges(new Marges(6.0, 20.0, 3.0, 3.0));
        this.fGraph.getDessin().getTitre().setVisible(false);
        this.fGraph.getDessin().getTitre().setTransparence(0.0f);
        this.fGraph.getRepere(0).getAxeH().getGraduation().setNombre(4);
        this.fGraph.getRepere(0).getAxeH().getGraduation().setAfficheMinMax(true);
        this.fGraph.getRepere(0).getAxeV().getGraduation().setIntervalle(0.1);
        this.fGraph.getRepere(0).getQuadrillageH().setPositions(new double[0]);
        this.fGraph.getRepere(0).getQuadrillageV().setPositions(new double[0]);
        this.fGraph.getRepere(0).getAxeV().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.fGraph.getRepere(0).getAxeH().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.fGraph.getRepere(0).getAxeH().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION_NASH);
        this.fGraph.getRepere(0).getAxeV().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION_NASH);
        this.fCourbe = new NuageDePoint(Messages.getString("WOBJ.name"));
        this.fCourbeMeilleur = new NuageDePoint(Messages.getString("JGraphParam.9"));
        this.fCourbeMeilleur.setCouleur(Color.RED);
        this.fGraph.ajouterSerie(0, this.fCourbe);
        this.fGraph.ajouterSerie(0, this.fCourbeMeilleur);
        this.fLabel = new JLabel("-");
        this.fLabel.setFont(Styles.FONT_LIBELLE_NASH);
        this.fTitre = new JLabel("-");
        this.fTitre.setFont(Styles.FONT_VALEUR_NASH);
        this.fTitre.setForeground(Color.RED);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 23;
        constraints.fill = 0;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)this.fLabel, constraints);
        constraints.gridx = 1;
        this.add((Component)this.fTitre, constraints);
        this.fLabelUnite = new JLabel("");
        this.fLabelUnite.setFont(Styles.FONT_VALEUR_NASH);
        this.fLabelUnite.setForeground(Color.RED);
        constraints.fill = 0;
        constraints.gridx = 2;
        this.add((Component)this.fLabelUnite, constraints);
        Unit.getInstance().baseProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (this.fParameter != null) {
                String sUnite = pNewValue.get(this.fParameter.getDimension());
                if (sUnite.trim().length() == 0) {
                    sUnite = null;
                }
                this.fLabelUnite.setText(sUnite);
                this.fGraph.getRepere(0).getAxeH().setUnit("<html>" + sUnite + "</html>");
            }
        });
        constraints.fill = 1;
        constraints.gridy = 1;
        constraints.gridx = 0;
        constraints.gridwidth = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)this.fGraph, constraints);
    }

    public void setParameter(Parameter pParameter) {
        this.fParameter = pParameter;
        this.raz();
        this.fGraph.setNom(pParameter.getLabel());
        boolean log = pParameter.getDimension() == Dimension.K;
        String sUnite = Unit.getInstance().getBase().get(pParameter.getDimension());
        if (sUnite.trim().length() == 0) {
            sUnite = null;
        }
        this.fGraph.getRepere(0).getAxeH().setEtiquette("<html>" + pParameter.getHtmlLabel() + "</html>");
        this.fGraph.getRepere(0).getAxeH().setUnit((String)(sUnite == null ? "" : "<html>" + sUnite + "</html>"));
        this.fGraph.getDessin().setTitle("<html>" + pParameter.getHtmlLabel() + "</html>");
        if (log) {
            this.fGraph.setScaleFunctions(0, new Log10Function(), null);
        } else {
            this.fGraph.setScaleFunctions(0, null, null);
        }
        this.fLabel.setText("<html>" + pParameter.getHtmlLabel() + "&nbsp:&nbsp;</html>");
        this.fLabelUnite.setText(" " + (sUnite == null ? "" : sUnite));
    }

    void ajoute(double pX, double pY) {
        this.fCourbe.ajouterPoint(new PointCourbe(pX, pY, 2));
        if (pY > this.fBestY) {
            this.fBestY = pY;
            this.fXBestY = pX;
        }
        if ((1.0 - pY) / 0.1 > 20.0) {
            this.fGraph.getRepere(0).getAxeV().getGraduation().setNombre(10);
        }
    }

    void majTitre() {
        PointCourbe pt = new PointCourbe(this.fXBestY, this.fBestY, 6);
        pt.setCouleur(Color.RED);
        this.fCourbeMeilleur.clear();
        this.fCourbeMeilleur.ajouterPoint(pt);
        this.fTitre.setText(this.format(this.fXBestY));
        this.fTitre.setToolTipText(String.valueOf(this.fXBestY));
        this.fGraph.ajuster();
        this.fGraph.setBornesX(0, this.fParameter.getMin(), this.fParameter.getMax());
    }

    private String format(double pBest) {
        if (pBest > 0.01 || pBest < -0.01 || pBest == 0.0) {
            return new DecimalFormat("#.###").format(pBest);
        }
        return new DecimalFormat("0.###E0").format(pBest);
    }

    public void setYMin(double pMin) {
        this.fGraph.getDessin().getRepere(0).setBornesY(pMin, Math.min(1.0, pMin + 1.1 * (this.fBestY - pMin)));
    }

    public void raz() {
        this.fCourbe.clear();
        this.fCourbeMeilleur.clear();
        this.fTitre.setText("");
        this.fTitre.setToolTipText("");
        this.fXBestY = 0.0;
        this.fBestY = -1.7976931348623157E308;
    }
}

