/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.JPanneauGraphique;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.NuageDePoint;
import fr.dbe.graphique.PointCourbe;
import fr.dbe.graphique.PremiereBissectrice;
import fr.dbe.util.commun.Plage;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.ihm.graphs.FondPlage;
import java.awt.Color;
import javax.swing.BorderFactory;

public class JGraphiqueQSimVsQobs
extends JPanneauGraphique {
    private final NuageDePoint fSerieQsimVsQobsCalibration;
    private final NuageDePoint fSerieQsimVsQobsValidation;
    private final FondPlage fFondPlageCalibration;
    private final FondPlage fFondPlageValidation;
    private final Courbe fCourbeQobs;
    private final Courbe fCourbeQsim;

    public JGraphiqueQSimVsQobs(Courbe pCourbeQobs, String pQobsName, Courbe pCourbeQsim, String pQsimName, FondPlage pCalibration, FondPlage pValidation) {
        super(pQsimName + " vs " + pQobsName, Messages.getString("JResults.34"), false);
        this.fFondPlageCalibration = pCalibration;
        this.fFondPlageValidation = pValidation;
        this.fCourbeQobs = pCourbeQobs;
        this.fCourbeQsim = pCourbeQsim;
        this.fSerieQsimVsQobsCalibration = new NuageDePoint("Calibration");
        this.fSerieQsimVsQobsCalibration.setCouleur(Styles.COULEUR_CALIBRATION);
        this.fSerieQsimVsQobsCalibration.setCursorable(false);
        this.fSerieQsimVsQobsValidation = new NuageDePoint("Validation");
        this.fSerieQsimVsQobsValidation.setCouleur(Styles.COULEUR_VALIDATION);
        this.fSerieQsimVsQobsValidation.setCursorable(false);
        PremiereBissectrice bissectrice = new PremiereBissectrice("First bisector");
        bissectrice.setColor(new Color(120, 120, 120, 90));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setControleEnabled(true);
        this.getDessin().setAfficheNomCourbe(true);
        this.getDessin().setMarges(new Marges(10.0, 15.0, 3.0, 3.0));
        this.getDessin().setOrthonorme(true);
        this.getDessin().setTitle(this.getNom());
        this.getDessin().getTitre().setVisible(false);
        this.getDessin().getTitre().setTransparence(0.0f);
        this.getRepere(0).getAxeV().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeH().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeV().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).getAxeH().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).getQuadrillageH().linkToGraduation();
        this.getRepere(0).getQuadrillageV().linkToGraduation();
        this.getRepere(0).ajouteFond(bissectrice);
        this.ajouterSerie(0, this.fSerieQsimVsQobsCalibration);
        this.ajouterSerie(0, this.fSerieQsimVsQobsValidation);
        this.setEtiquette(0, pQobsName, pQsimName);
    }

    public void clear() {
        this.fSerieQsimVsQobsCalibration.clear();
        this.fSerieQsimVsQobsValidation.clear();
    }

    public void maj() {
        this.fSerieQsimVsQobsCalibration.clear();
        this.fSerieQsimVsQobsValidation.clear();
        if (!this.fCourbeQsim.isActive()) {
            return;
        }
        int diametre = 5;
        double[] qObs = this.fCourbeQobs.getValues().toArray();
        double[] qSim = this.fCourbeQsim.getValues().toArray();
        if (qSim.length > 0) {
            int i;
            for (Plage p : this.fFondPlageCalibration.getPlages()) {
                for (i = p.getIndiceMin(); i <= p.getIndiceMax(); ++i) {
                    if (Double.isNaN(qObs[i])) continue;
                    this.fSerieQsimVsQobsCalibration.ajouterPoint(new PointCourbe(qObs[i], qSim[i], diametre, this.fSerieQsimVsQobsCalibration.getCouleur()));
                }
            }
            for (Plage p : this.fFondPlageValidation.getPlages()) {
                for (i = p.getIndiceMin(); i <= p.getIndiceMax(); ++i) {
                    if (Double.isNaN(qObs[i])) continue;
                    this.fSerieQsimVsQobsValidation.ajouterPoint(new PointCourbe(qObs[i], qSim[i], diametre, this.fSerieQsimVsQobsValidation.getCouleur()));
                }
            }
        }
        this.ajuster();
    }
}

